% This function assumes two groups and that the memory mapped images have
% been kept. In future this will be expanded to work on the original
% images. 
% 

function [corrmat,zcorrmat,timeseries,timeseries_normalized] = debugGroupComparison(Params)

Pub = Params.PublicParams;
Priv = Params.PrivateParams;

doDebug = 0; % This is to prevent problems with the correlation overflows. 
             % It forces the correlation values to be smaller than 1 (in absolute value)
             % It also prints a message urging to check the data.
             % However, this probably slows down the code a bit and these problems have been rare 
             % so this feature can be turned off
epsilon1 = 0.99999999;
epsilon0 = 0.0000001;
dispDebugLim = 0; % this limits the number of debug messages
dispDebug = 0;

if any(Priv.dummies(:) > 0)
   error('Currently does not handle unequal group sizes');
end

maskfileformat = Pub.fileFormat;
if strcmp(maskfileformat(end-2:end),'nii') || strcmp(maskfileformat,'nii.gz')
    bmask = load_nii(Priv.brainMask);
    bmask = single(bmask.img);
else
    bmask = load(Priv.brainMask);
    fiel = fields(bmask);
    bmask = bmask.(fiel{1});
    bmask = single(bmask);
end
bandNr = 0;

load([Pub.dataDestination 'memMaps'])
for h = 1:Priv.nrSessions
    % fMRI-data (source data):
   mMap.(['sess' num2str(h)]) = memMaps.(Priv.origMapName).([Priv.prefixSession num2str(h)]);
end
clear memMaps

corrmat = zeros(Priv.nrSubjects*2,Priv.nrSubjects*2);
zcorrmat = zeros(Priv.nrSubjects*2,Priv.nrSubjects*2);
timeseries = zeros(Priv.dataSize(1,4),2,Priv.nrSubjects);
timeseries_normalized = zeros(Priv.dataSize(1,4),2,Priv.nrSubjects);

% if strcmp(Pub.fileFormatSubj,'nii')
%    I = load_nii(Pub.subjectSource{m,k});
%    I = single(I.img);
% else
%    I = load(Pub.subjectSource{m,k});
%    fiel = fields(I);
%    I = I.(fiel{1});
%    I = single(I);
% end

for xx = 1:Priv.dataSize(1,1)
    disp(['x: ' num2str(xx) '/' num2str(Priv.dataSize(1,1))])
    % init result matrix for across session data
    % process only non-zero x-slices:
    if sum(sum(squeeze(bmask(xx,:,:)))) > 0
        % init source time-series matrix:
        cDat = zeros([Priv.dataSize(1,[4 2 3]),Priv.nrSessions, Priv.nrSubjects]);
        % read multi-band time-series of the subjects:
        for f = 1:Priv.nrSessions
           for k = 1:Priv.nrSubjects
               cDat(:,:,:,f,k) = mMap.(['sess' num2str(f)]).([Priv.prefixSubject num2str(k)]).Data(xx).tyz; % time*y*z*sessions*subjects
           end
        end
        n1 = size(cDat,1);
        N = Priv.dataSize(1,4); % number of time points
		denom = N - 1;
        for yy = 1:Priv.dataSize(1,2)
            ziter = 0;
            for zz = 1:Priv.dataSize(1,3)
                if bmask(xx,yy,zz)
                   ziter = ziter + 1;
                    ts = squeeze(cDat(:,yy,zz,:,:)); % time*sessions*subjects 
                    ts(isnan(ts)) = 0;
                    timeseries = timeseries + ts;
					ts = bsxfun(@minus,ts,sum(ts)/N);  % de-meaning here (JT)
					tsvar = sum(abs(ts).^2) ./ denom;  %  compute time-wise variance
                    tsvar = tsvar + (tsvar == 0) + (tsvar < 0); % make sure that no division by zeros
					ts = bsxfun(@rdivide,ts,sqrt(tsvar));
                    ts(isnan(ts)) = 0;
                    timeseries_normalized = timeseries_normalized + ts;
                    ts_v1 = [squeeze(ts(:,1,:))  squeeze(ts(:,2,:))]; % time*total_subjects, session 2
                    
                    for m = 1:(2*Priv.nrSubjects)
                        for n = 1:(2*Priv.nrSubjects)
                            if m > n
                               r1 = ts_v1(:,m)'*ts_v1(:,n)/denom;
                               if doDebug
                                  if(abs(r1) > epsilon1)
                                   % disp([ 'Correlation overflow: Check the data of subjs' num2str(n) 'and' num2str(m) 'at the voxel' num2str(xx) ',' num2str(yy) ',' num2str(zz) '.']);
                                     r1 = r1/(abs(r1) + epsilon0);
                                 end
                               end
                             corrmat(m,n) = corrmat(m,n) + r1;
                             z12 = 0.5*(log((1+r1)./(1-r1)));
                             zcorrmat(m,n) = zcorrmat(m,n) + z12;
                            end  
                        end
                    end
                end
            end
        end
    end
end
len = sum(sum(sum(bmask)));
timeseries = timeseries/len;
timeseries_normalized = timeseries_normalized/len;
corrmat = corrmat/len;
zcorrmat = zcorrmat/len;
mkdir(Pub.dataDestination,'GroupCompDebug');
save(fullfile(Pub.dataDestination,'GroupCompDebug','GroupCompDebug'),'timeseries','timeseries_normalized','corrmat','zcorrmat');