function r = regress_univariate(x,y)

c = corrcoef(x,y); % Corr coeff is the off-diagonal (1,2) element
c = c(1,2);  % Sample regression coefficient

% Add to the scatterplot
%title(['c = ' num2str(0.01*round(c*100))])
xbar = mean(x);
ybar = mean(y);
sigx = std(x);
sigy = std(y);
a1 = c*sigy/sigx;   % Regression line slope

% Overplot regression line, adding means back in.

yhat = ybar + a1*(x - xbar);

% yhat = x*b;                     % Predicted responses at each data point.
r =  y - yhat;                     % Residuals.

% plot(x,yhat,'k-')

