function removeMemmapData(Params)
% The function removes the wanted memmapped binary data files (as defined in the GUI. 
% If the files are deleted the program generates them again when the analysis is rerun. 
%Note that regeneration of the filtered data can take a long time.

%Priv = Params.PrivateParams;
Pub = Params.PublicParams;
%get the current path ending (/ or \)
slash = Pub.dataDestination(end);

if(Pub.removeMemmaps)
    disp('Removing memmapped source data:')
    %define path and find the bin files
    rmpath = [Pub.dataDestination, 'fMRIpreprocessed', slash];
    files = dir([rmpath, '*.bin']);
    %deleting files one by one, just in case
    for k = 1:length(files)
        disp(['Removing file: ' files(k).name])
        delete([rmpath, files(k).name])
        fprintf('\b',1); disp('... Done!')
    end
    %should these also get cleared from memmap struct? 
else
    disp('Memmap removal not selected, skipping removal phase')
end

if(Pub.removeFiltermaps)
    disp('Removing Filtered data:')
    %define path and find the bin files
    rmpath = [Pub.dataDestination, 'fMRIfiltered', slash];
    files = dir([rmpath, '*.bin']);
    %deleting files one by one, just in case
    for k = 1:length(files)
        disp(['Removing file: ' files(k).name])
        delete([rmpath, files(k).name])
        fprintf('\b',1); disp('... Done!')
    end
    %should these also get cleared from memmap struct? 
else
    disp('Filtermap removal not selected, skipping removal phase')
end

if Params.PublicParams.FuSeOn
    if(Pub.FuSe_remove_temp)
        featureSet = Pub.FuSe_FSet;
        Xpath = [Params.PublicParams.dataDestination 'results/X.mat'];
        disp('Removing FuSe temporary files')
        tmpPath = [Pub.dataDestination 'results'];
        disp('FuSe: Removing KNN graph temp files...')
        delete([tmpPath slash 'KNNG_k*_featureSet' num2str(featureSet) '.mat']);
        disp('FuSe: Removing SNN graph temp...')
        delete([tmpPath slash 'SNN_k*_featureSet' num2str(featureSet) '.mat']);
    %    disp('FuSe: Removing X matrix...')
    %    delete(Xpath)
    else 
        disp('FuSe temporary files removal not selected, skipping removal phase')
    end
end
