function saveCsvResults(Params)
% function generates csv files from the computed thresholds
% Juha Pajula, 21.06.2016

disp('Saving thresholds to csv:')
Priv = Params.PrivateParams;
Pub = Params.PublicParams;
nrSession=size(Pub.subjectSource,1);
data = load([Priv.statsDestination 'Th' Priv.prefixFreqBand '0'...
    Priv.prefixSession '1win0.mat']);

datTab = cell(1,13); 
datTab(2:end)=data.Th_info;

winOn = Pub.winOn;
TW = {'Accross session (win0)','Time windows (win1)'};

for k = 1:nrSession
disp(['   Session: ' num2str(k)])
    for b = 0:Params.PrivateParams.maxScale + 1
disp(['      Band: ' num2str(b)])        
        for t = 0:winOn
disp(['         ' TW{t+1}])
            fid = fopen([Priv.resultsDestination 'Session' num2str(k) 'Band' num2str(b) 'ThresholdsWin' num2str(t) '.csv'],'w');

            fprintf(fid,'%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s\n',datTab{1,:});

            data = load([Priv.statsDestination 'Th' Priv.prefixFreqBand num2str(b)...
                Priv.prefixSession num2str(k) 'win' num2str(t) '.mat']);

            fprintf(fid,'%s,', ['Session' num2str(k) '_pvalsTh']);
            fprintf(fid,'%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',data.pvals_Th);

            fprintf(fid,'%s,', ['Session' num2str(k) '_Th']);
            fprintf(fid,'%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f\n',data.Th);
            fclose(fid);
        end
    end
end
    
%c = {'abc' 'def' 'ghk';[23],[24],[67];[87],[13],[999];[656],[6767],[546]}; 
if(Params.PublicParams.sessionCompOn)
    disp('Saving Session comparison Thresholds to csv')
%    data2 = load([Priv.PFsessionDestination 'ThPFBand0' Priv.prefixSessComp '1win0.mat']);

%F:\ISCtests\koe1\PFsession\ThPFBand0sessComp1win0.mat
%                           ThPFBand0sessComp1win0
    dat2Tab = cell(1,5); 
    dat2Tab(2:end)={'0.05','0.025','0.01','0.001'};
    paramString = generateSessCompParamString(Params);
    for s = 0:Pub.nrFreqBands
        disp(['   Band: ' num2str(s)])        
        for k = 1:((Priv.nrSessions)^2-(Priv.nrSessions))/2;
            disp(['   Session Comparison: ' num2str(k)])
            fid = fopen([Priv.resultsDestination 'SessionComparison' num2str(k) 'Band' num2str(s) 'ThresholdsWin0_' paramString '.csv'],'w');
            fprintf(fid,'%s, %s, %s, %s, %s\n',dat2Tab{1,:});
            data2 = load([Priv.PFsessionDestination 'ThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win0.mat']);
%                    load([Priv.PFsessionDestination 'ThPFBand0'           Priv.prefixSessComp '1win0.mat']);
            fprintf(fid,'%s,', ['SessionComparison' num2str(k) '_critVals']);
            fprintf(fid,'%f, %f, %f, %f\n',data2.critVals);

            fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (voxel FWER)']);
            fprintf(fid,'%f, %f, %f, %f\n',data2.Th);
            if exist([Priv.PFsessionDestination 'clusterThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win0.mat'],'file')
               data2 = load([Priv.PFsessionDestination 'clusterThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win0.mat']);
               fprintf(fid,'%s,', ['SessionComparison' num2str(k) '_critVals']);
               fprintf(fid,'%f, %f, %f, %f\n',data2.critVals);
               fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (positive cluster FWER))']);
               fprintf(fid,'%f, %f, %f, %f\n',data2.cThPos);
               fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (negative cluster FWER))']);
               fprintf(fid,'%f, %f, %f, %f\n',data2.cThNeg);
            end  
            if exist([Priv.PFsessionDestination 'fdr_ThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win0.mat'],'file')
                data2 = load([Priv.PFsessionDestination 'fdr_ThPFBand' num2str(s) Priv.prefixSessComp num2str(k) 'win0.mat']);
                fprintf(fid,'%s,', ['SessionComparison' num2str(k) '_critVals']);
                fprintf(fid,'%f, %f, %f, %f\n',data2.critVals);
                fprintf(fid,'%s,', ['SC' num2str(k) ' p (voxel FDRid))']);
                fprintf(fid,'%f, %f, %f, %f\n',data2.pthFDRid);
                % these are not maybe useful to print JT 1.2.2018
               % fprintf(fid,'%s,', ['SC' num2str(k) ' p (voxel FDRn))']);
               % 
               % fprintf(fid,'%f, %f, %f, %f\n',data2.pthFDRn);
                fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (voxel FDRid))']);
                fprintf(fid,'%f, %f, %f, %f\n',data2.zthFDRid);
                %fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (voxel FDRn))']);
                %fprintf(fid,'%f, %f, %f, %f\n',data2.zthFDRn);
                fprintf(fid,'%s,', ['SC' num2str(k) '_Threshold (voxel uncorrected))']);                
                fprintf(fid,'%f, %f, %f, %f\n',data2.zth_uncorrected);
                fprintf(fid,'%s,', ['SC' num2str(k) ' nonparametric p (voxel FDRid))']);
                fprintf(fid,'%f, %f, %f, %f\n',data2.nonparam_pthFDRid);
                %fprintf(fid,'%s,', ['SC' num2str(k) ' nonparametric p (voxel FDRn))']);
                % fprintf(fid,'%f, %f, %f, %f\n',data2.nonparam_pthFDRid);
                fprintf(fid,'%s,', ['SC' num2str(k) 'nonpZ_Threshold (voxel FDRid))']);
                fprintf(fid,'%f, %f, %f, %f\n',data2.nonparam_zthFDRid);
                fprintf(fid,'%s,', ['SC' num2str(k) 'nonpZ_Threshold (voxel uncorrected))']);                
                fprintf(fid,'%f, %f, %f, %f\n',data2.nonparam_zth_uncorrected);
                
            end
            fclose(fid);
        end
    end
end
function prm_str = generateSessCompParamString(Params)
% generate name prefix from Params to save the thresholds

Ctype = {'Group','Session'};
grp_perm = {'EW','SWdi','SW'};
corr_type = {'MCConly', 'VoxMCCextMCC','VoxMCCmbMCC'};
prim_th = num2str(Params.PublicParams.clusterThreshold);
nrPerm = num2str(Params.PublicParams.permutSessionComp);

prm_str = [Ctype{Params.PublicParams.pairedSessionComp+1},'_', ...
    grp_perm{Params.PublicParams.permutationType}, '_',...
    corr_type{Params.PublicParams.clusterCorrType+1}, '_',...
    prim_th, '_', nrPerm];
