function saveparametricZnii(Params)
% function that generates a Z-stat image based on p-to-Z transform and
% pvalmaps3D1Band0.nii
if isstruct(Params)
    Priv = Params.PrivateParams;
    Pub = Params.PublicParams;
else
    Priv.PFsessionDestination = Params;
end

nrBand = 0;
load([Priv.PFsessionDestination 'band' num2str(nrBand) 'pvalmaps3D1']);
load([Priv.PFsessionDestination 'band' num2str(nrBand) 'ZsumStat1'],'PFdata3D')
zp = zeros(PFsize(1:3));
pVs = pVs + (pVs == 0)*eps;
zp(indbmaskorig) = -sqrt(2).*erfcinv(2*(1 - pVs/2));
zp(indbmaskorig) = zp(indbmaskorig).*sign(PFdata3D(indbmaskorig));
nii = load_nii([Priv.PFsessionDestination 'pvalmaps3D1' 'band' num2str(nrBand) '.nii']);
nii.img = zp;
save_nii(nii,[Priv.PFsessionDestination 'z_global1' 'band' num2str(nrBand) '.nii']);



