function varargout = fMRI_GUI_export(varargin)

% FMRI_GUI_EXPORT M-file for fMRI_GUI_export.fig
%      FMRI_GUI_EXPORT, by itself, creates a new FMRI_GUI_EXPORT or raises the existing
%      singleton*.
%
%      H = FMRI_GUI_EXPORT returns the handle to a new FMRI_GUI_EXPORT or the handle to
%      the existing singleton*.
%
%      FMRI_GUI_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FMRI_GUI_EXPORT.M with the given input arguments.
%
%      FMRI_GUI_EXPORT('Property','Value',...) creates a new FMRI_GUI_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before fMRI_GUI_export_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to fMRI_GUI_export_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help fMRI_GUI_export

% Last Modified by GUIDE v2.5 23-May-2009 21:39:55

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @fMRI_GUI_export_OpeningFcn, ...
    'gui_OutputFcn',  @fMRI_GUI_export_OutputFcn, ...
    'gui_LayoutFcn',  @fMRI_GUI_export_LayoutFcn, ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    warning off
    gui_State.gui_Callback = str2func(varargin{1});
    warning on
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before fMRI_GUI_export is made visible.
function fMRI_GUI_export_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to fMRI_GUI_export (see VARARGIN)

set(gcf,'Name','ISC toolbox 3.0: Visualization GUI')
set(gcf,'CloseRequestFcn','ISCclosereq')
set(gcf,'units','normalized','Position',[0.0201 0.1144 0.9368 0.8144])
handles = disablePanels(handles);

% Open GUI depending on the given input.
flag = 1;
if ~isempty(varargin)
    flag = 0;
    if length(varargin) == 1 % At most one input must be given
        % Here, we deal with the case where the full pathname to
        % params-filename was given by a user:
        if ischar(varargin{1}) % Input must be a string.
            if exist(varargin{1}) == 2 % The given file must exists.
                handles.paramFile = varargin{1}; % Save file containing params-struct
                % Load params-struct in the specified location:
                [dn,fn] = fileparts(varargin{1});
                load(handles.paramFile);
                if exist('Params','var') % Params-struct must exists.
                    % Expected location of the atlas path:
                    atlasPath = Params.PublicParams.atlasPath;
                    % Check if atlas path is correct:
                    [flag,correctAtlasPath,Params] = checkAndSetMaskAndAtlasPath(atlasPath,Params);
                    if ~flag
                        delete(handles.figure1)
                        return
                    else
                        setAtlasAndMaskPath(correctAtlasPath,Params,handles.paramFile);
                    end
                    
                    if exist(Params.PublicParams.dataDestination,'dir') ~= 7
                        disp('Directory location changed -> correcting paths and pointers')
                        if ispc
                            dn = [dn '\'];
                        else
                            dn = [dn '/'];
                        end
                        [~,Params,~] = changeDirectory(dn);
                    end
                    %                   load(handles.paramFile);
                    handles.ParamStructInput = Params;
                    [handles,errFlag] = getParams(handles);
                    if errFlag
                        delete(handles.figure1)
                        return
                    end
                    guidata(hObject, handles);
                    handles = enablePanels(handles);
                    % use the following command to clear workspace
                    % memory pointers automatically:
                    assignin('base','memMaps',[])
                    guidata(hObject, handles);
                    flag = 1;
                end
            end
        else
            if isstruct(varargin{1}) % Params given as input.
                Params = varargin{1};
                if isfield(Params,'PublicParams')
                    Pub = Params.PublicParams;
                    if isfield(Params,'PublicParams')
                        Priv = Params.PrivateParams;
                        if ( isfield(Pub,'dataDestination') && ...
                                isfield(Pub,'dataDescription') )
                            handles.paramFile = [Pub.dataDestination Pub.dataDescription '_params'];
                            if ( isfield(Pub,'atlasPath') )
                                atlasPath = Pub.atlasPath;
                                % Check if atlas path is correct:
                                [flag,correctAtlasPath,Params] = checkAndSetMaskAndAtlasPath(atlasPath,Params);
                                if ~flag
                                    delete(handles.figure1)
                                    return
                                else
                                    setAtlasAndMaskPath(correctAtlasPath,Params,handles.paramFile);
                                end
%                                changeDirectory(Params.PublicParams.dataDestination);
                                load(handles.paramFile);
                                handles.ParamStructInput = Params;
                                [handles,errFlag] = getParams(handles);
                                if errFlag
                                    delete(handles.figure1)
                                    return
                                end
                                guidata(hObject, handles);
                                handles = enablePanels(handles);
                                %use the following command to clear workspace
                                %memory pointers automatically:
                                assignin('base','memMaps',[])
                                guidata(hObject, handles);
                                flag = 1;
                            end
                        end
                    end
                end
            end
        end
    end
end
% Choose default command line output for fMRI_GUI_export
handles.output = hObject;

if ~flag
    disp(' ')
    disp('Error!!! --> Input must be a valid Params-struct or a full pathname to a mat-file containing Params-struct!')
    disp(' ')
    uiresume(handles.figure1);
end

% if ~isempty(varargin)
%     if handles.Pub.winOn == 0
%         set(handles.uipanelSimMeasure,'Visible','off')
%     end
% end

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes fMRI_GUI_export wait for user response (see UIRESUME
uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = fMRI_GUI_export_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if ~isempty(handles)
    varargout{1} = handles.output;
    delete(handles.figure1)
    return
end

% --- Executes on button press in pushbuttonUpdate.
%function pushbuttonUpdate_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonUpdate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%handles = update_params(handles);
%handles = update_figs(handles);
%guidata(hObject, handles);

% --- Executes on slider movement.
function sliderLayer_Callback(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

origCoord = round(get(hObject,'Value'));

switch handles.activeAxes
    case 1
        set(handles.textAxial,'String',['z = ' num2str( handles.coordinateProd(3)*origCoord+handles.coordinateShift(3))])
        set(handles.editLayer,'String',['z = ' num2str( handles.coordinateProd(3)*origCoord+handles.coordinateShift(3))])
    case 2
        set(handles.textCoronal,'String',['y = ' num2str( handles.coordinateProd(2)*origCoord+handles.coordinateShift(2))])
        set(handles.editLayer,'String',['y = ' num2str( handles.coordinateProd(2)*origCoord+handles.coordinateShift(2))])
    case 3
        set(handles.textSagittal,'String',['x = ' num2str( handles.coordinateProd(1)*origCoord-handles.coordinateShift(1))])
        set(handles.editLayer,'String',['x = ' num2str( handles.coordinateProd(1)*origCoord-handles.coordinateShift(1))])
end




handles.layerVal = round(get(hObject,'Value'));
%set(handles.editLayer,'String',num2str(handles.layerVal));
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function sliderLayer_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

function pushbuttonPlotSynch_Callback(hObject, eventdata, handles)

if ~isempty(handles.plottedRegions)
    Curve = updateTemporalData(handles);
    plotTemporalData(handles,Curve);
else
    warndlg('You must select at least one brain region from atlas list!');
    %   disp('You must select at least one brain region.')
end

function pushbuttonExportSynch_Callback(hObject, eventdata, handles)

if ~isempty(handles.plottedRegions)
    handles = exportCurves(handles);
else
    warndlg('You must select at least one brain region from atlas list!');
end

function pushbuttonAnalysisSynch_Callback(hObject, eventdata, handles)

handles = update_params(handles);
H = handles;
set(hObject,'Enable','off')
% call temporal analysis -GUI:
H = plotTimeSeries_GUI(H);
handles.H = H;
set(hObject,'Enable','on')

% --- Executes on selection change in popupmenuAtlas.
function popupmenuAtlas_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuAtlas contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuAtlas

function pushbuttonUpdateRegions_Callback(hObject, eventdata, handles)


handles = loadAtlasData(handles);
handles = update_figs(handles);
guidata(hObject, handles);

function pushbuttonAddRegion_Callback(hObject, eventdata, handles)

handles.CurrentRegion = get(handles.popupmenuAtlas,'Value');
contents = get(handles.popupmenuAtlas,'String');
contents2 = get(handles.listboxAtlasList,'String');

if ~handles.atlasIndexList(handles.CurrentRegion,1)
    handles.atlasIndexList(handles.CurrentRegion,1) = 1;
    handles.atlasIndexList(handles.CurrentRegion,2) = length(contents2)+1;
    contents2{length(contents2)+1}=contents{handles.CurrentRegion};
    contents{handles.CurrentRegion} = ['---> ' contents{handles.CurrentRegion}];
    set(handles.popupmenuAtlas,'String',contents);
    handles.plottedRegions = [handles.plottedRegions handles.CurrentRegion];
    set(handles.listboxAtlasList,'String',contents2);
end

handles = loadAtlasData(handles);

if ( handles.Masking == 1 ) && ( handles.MaskingType  == 1 )
    handles.changeInCurrentAxes = 1;
end

handles = update_figs(handles);
guidata(hObject, handles);

function pushbuttonClearAtlas_Callback(hObject, eventdata, handles)

% load atlas image:
%handles.AtlasThreshold = 3;
% handles = loadAtlasData(handles);

handles.atlas = zeros(size(handles.anatomy));
handles.atlasIndexList = zeros(69,2);

handles = setAtlasList(handles);
handles.CurrentRegion = get(handles.popupmenuAtlas,'Value');
handles.atlasIndexList = zeros(size(handles.atlasIndexList));
handles.plottedRegions = [];
set(handles.listboxAtlasList,'String','');

handles = loadAtlasData(handles);
handles = update_figs(handles);
guidata(hObject, handles);


function pushbuttonRemoveRegion_Callback(hObject, eventdata, handles)

handles.CurrentRegion = get(handles.popupmenuAtlas,'Value');
contents = get(handles.popupmenuAtlas,'String');
contents2 = get(handles.listboxAtlasList,'String');

if handles.atlasIndexList(handles.CurrentRegion,1)
    handles.atlasIndexList(handles.CurrentRegion,1) = 0;
    contents2(handles.atlasIndexList(handles.CurrentRegion,2)) = [];
    set(handles.listboxAtlasList,'String',contents2)
    contents{handles.CurrentRegion}(1:5) = [];
    set(handles.popupmenuAtlas,'String',contents);
    handles.plottedRegions(handles.atlasIndexList(handles.CurrentRegion,2)) = [];
    
    handles.atlasIndexList(handles.atlasIndexList(:,2)>...
        handles.atlasIndexList(handles.CurrentRegion,2),2) = ...
        handles.atlasIndexList(handles.atlasIndexList(:,2)>...
        handles.atlasIndexList(handles.CurrentRegion,2),2) - 1;
    handles.atlasIndexList(handles.CurrentRegion,2) = 0;
end

handles = loadAtlasData(handles);

if ( handles.Masking == 1 ) && ( handles.MaskingType  == 1 )
    handles.changeInCurrentAxes = 1;
end

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuAtlas_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function editLayer_Callback(hObject, eventdata, handles)
% hObject    handle to editLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editLayer as text
%        str2double(get(hObject,'String')) returns contents of editLayer as a double

% --- Executes during object creation, after setting all properties.
function editLayer_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function editAtlasScaleMin_Callback(hObject, eventdata, handles)
% hObject    handle to editAtlasScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editAtlasScaleMin as text
%        str2double(get(hObject,'String')) returns contents of editAtlasScaleMin as a double

handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editAtlasScaleMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editAtlasScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit1ScaleMin_Callback(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1ScaleMin as text
%        str2double(get(hObject,'String')) returns contents of edit1ScaleMin as a double

Val = str2double(get(hObject,'String'));
if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 )
    if ~( Val < 0 || Val >= handles.ScaleMax1 )
        handles.ScaleMin1 = Val;
        handles = setCurrentColorBar(handles);
        handles.changeInCurrentAxes = 1;
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        handles = setCurrentColorBar(handles);
    end
end

% --- Executes during object creation, after setting all properties.
function edit1ScaleMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit1ScaleMax_Callback(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1ScaleMax as text
%        str2double(get(hObject,'String')) returns contents of edit1ScaleMax as a double

Val = str2double(get(hObject,'String'));
if ~(~isnumeric(Val) || isnan(Val) || isinf(Val) || length(Val) ~= 1 )
    %     if handles.freqCompOn
    %         switch handles.ZPFtest
    %             case 1
    %                 Val = floor(Val);
    %                 Val = Val/handles.subjPairs;
    %             case 2
    %                 Val = Val/handles.maxSc;
    %         end
    %     end
    %    if ~handles.freqCompOn
    %        if handles.mapType == 2 || handles.mapType == 3
    %            Val = round(Val);
    %            Val = Val/handles.maxSc;
    %        end
    %    end
    if ~( Val < 0 || Val <= handles.ScaleMin1 )
        handles.ScaleMax1 = Val;
        %        setFigureColorMap(handles);
        handles.changeInCurrentAxes = 1;
        handles = update_figs(handles);
        guidata(hObject, handles);
    else
        handles = setCurrentColorBar(handles);
    end
end

% --- Executes during object creation, after setting all properties.
function edit1ScaleMax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1ScaleMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuFreqBand.
function popupmenuFreqBand_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuFreqBand contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuFreqBand
handles.freqBand = get(hObject,'Value');
if handles.freqBand <= handles.freqBand2
    handles.freqComp = handles.freqBandCompTable(handles.freqBand,handles.freqBand2);
else
    handles.freqComp = handles.freqBandCompTable(handles.freqBand2,handles.freqBand);
end
%if handles.sessionCompOn
%    if isnan(handles.sessionComp)
%        guidata(hObject, handles);
%    else
%        handles.changeInCurrentAxes = 1;
%        handles = update_figs(handles);
%        guidata(hObject, handles);
%    end
%else
%handles = updateThreshold(handles);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);
%end

% --- Executes during object creation, after setting all properties.
function popupmenuFreqBand_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on selection change in popupmenuSimilarityMeasure.
function popupmenuSimilarityMeasure_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuSimilarityMeasure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuSimilarityMeasure contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuSimilarityMeasure

handles.SimMeasure = get(hObject,'Value');
if handles.SimMeasure > 1
    set(handles.popupmenuMapType,'Enable','off')
else
    set(handles.popupmenuMapType,'Enable','on')
end
handles = updateThreshold(handles);
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuSimilarityMeasure_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuSimilarityMeasure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuOrient.
function popupmenuOrient_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuOrient (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuOrient contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuOrient

contents = get(hObject,'String');
handles.orient = contents{get(hObject,'Value')};
switch handles.orient
    case 'axial'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,1),'Value',get(handles.sliderAxial,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,2),handles.datasize(handles.dataset,1)));axis image;
    case 'coronal'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,2),'Value',get(handles.sliderCoronal,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,1)));axis image;
    case 'sagittal'
        set(handles.sliderLayer,'Max',handles.datasize(handles.dataset,3),'Value',get(handles.sliderSagittal,'Value'));
        axes(handles.axes1)
        set(handles.dataImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
        axes(handles.axesAtlas)
        set(handles.atlasImage,'CData',zeros(handles.datasize(handles.dataset,3),handles.datasize(handles.dataset,2)));axis image;
end

handles.activeAxes = get(hObject,'Value');

origCoord = round(get(hObject,'Value'));

switch handles.activeAxes
    case 1
        set(handles.textAxial,'String',['z = ' num2str( handles.coordinateProd(3)*origCoord+handles.coordinateShift(3))])
        set(handles.editLayer,'String',['z = ' num2str( handles.coordinateProd(3)*origCoord+handles.coordinateShift(3))])
    case 2
        set(handles.textCoronal,'String',['y = ' num2str( handles.coordinateProd(2)*origCoord+handles.coordinateShift(2))])
        set(handles.editLayer,'String',['y = ' num2str( handles.coordinateProd(2)*origCoord+handles.coordinateShift(2))])
    case 3
        set(handles.textSagittal,'String',['x = ' num2str( handles.coordinateProd(1)*origCoord+handles.coordinateShift(1))])
        set(handles.editLayer,'String',['x = ' num2str( handles.coordinateProd(1)*origCoord+handles.coordinateShift(1))])
        
end

handles = update_params(handles);
handles = update_figs(handles);




guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuOrient_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuOrient (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in checkboxPixVal1.
function checkboxPixVal1_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxPixVal1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inds = [];
if get(hObject,'Value') == 0
    ww = get(gcf,'Children');
    for kk = 1:length(ww);
        if strcmp(get(ww(kk),'Tag'),'pixelinfo panel')
            inds = [inds kk];
        end
    end
    delete(ww(inds))
else
    impixelinfo;
end


function checkboxSwapBytes_Callback(hObject, eventdata, handles)

handles.changeInCurrentAxes = 1;
if get(hObject,'Value') == 1
    handles.swapBytesOn = 1;
else
    handles.swapBytesOn = 0;
end
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

%function pushbuttonupdateAtlasList_Callback(hObject, eventdata, handles)
% update atlas listbox information:

%handles = updateAtlasList(handles);
%guidata(hObject, handles);

% --- Executes on button press in pushbuttonLocate.
function pushbuttonLocate_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonLocate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% handles = update_params(handles);
% switch handles.coefType
%     case 1
%         data = handles.dataD1;
%     case 2
%         data = handles.dataA1;
% end
%
% switch handles.SimMeasure
%     case 1
%         data = data.cor;
%     case 2
%         data = data.ken;
% end
%
% [L SubCort Cort dataset2 txtCort TS] = findLocalMaxima(data,handles.LocalMaximaThreshold);
% guidata(hObject, handles);

% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --- Executes on button press in pushbuttonAnalysisSynch.
%function pushbuttonAnalysisSynch_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAnalysisSynch (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


function checkboxNormalSynch_Callback(hObject, eventdata, handles)

if get(hObject,'Value')
    handles.NormalSynch = 1;
else
    handles.NormalSynch = 0;
end
guidata(hObject,handles)

function checkboxAtlasRegionType_Callback(hObject, eventdata, handles)

if get(hObject,'Value')
    handles.Perim = 0;
else
    handles.Perim = 1;
end
handles = loadAtlasData(handles);
handles = update_figs(handles);
guidata(hObject,handles)

function radionButtonPhaseSynch_Callback(hObject, eventdata, handles)

set(hObject,'Value',1)
set(handles.radionButtonSynch,'Value',0)
handles.Synch = 0;
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject,handles)

function radionButtonSynch_Callback(hObject, eventdata, handles)

set(hObject,'Value',1)
set(handles.radionButtonPhaseSynch,'Value',0)
handles.Synch = 1;
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject,handles)

function radionButtonSynchMedian_Callback(hObject, eventdata, handles)

set(hObject,'Value',1)
set(handles.radionButtonSynchThres,'Value',0)
set(handles.radionButtonSynchMean,'Value',0)
handles.ROIcurve = 2;
guidata(hObject,handles);

function radionButtonSynchMean_Callback(hObject, eventdata, handles)

set(hObject,'Value',1)
set(handles.radionButtonSynchMedian,'Value',0)
set(handles.radionButtonSynchThres,'Value',0)
handles.ROIcurve = 1;
guidata(hObject,handles);

function radionButtonSynchThres_Callback(hObject, eventdata, handles)

set(hObject,'Value',1)
set(handles.radionButtonSynchMedian,'Value',0)
set(handles.radionButtonSynchMean,'Value',0)
handles.ROIcurve = 3;
guidata(hObject,handles);

function listboxAtlasList_Callback(hObject, eventdata, handles)

function listboxAtlasList_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on selection change in popupmenuAtlasThreshold.
function popupmenuAtlasThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlasThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuAtlasThreshold contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuAtlasThreshold

handles.AtlasThreshold = get(hObject,'Value');
%handles = setFigureColorMap(handles);
handles = loadAtlasData(handles);
%handles = setCurrentColorBar(handles);
%handles = update_params(handles);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuAtlasThreshold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAtlasThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --------------------------------------------------------------------
function menuFile_Callback(hObject, eventdata, handles)
% hObject    handle to menuFile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function fileMenuDatatoWS_Callback(hObject, eventdata, handles)
% hObject    handle to Untitled_2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);

prompt = {'Enter variable name:'};
title = 'Assign data to workspace';
lines = 1;
def = {'Im1'};
answer = inputdlg(prompt,title,lines,def);

T = createImageData(handles);

%T.info = handles.info;
assignin('base',answer{1},T);


guidata(hObject, handles);

% --------------------------------------------------------------------
function fileExit_Callback(hObject, eventdata, handles)

user_response = confCloseModal('Title','Confirm Exit');
switch lower(user_response)
    case 'no'
        % take no action
    case 'yes'
        handles.output = handles;
        guidata(hObject, handles)
        %uiresume(handles.figure1)
        %        delete(handles.figure1)
        if ~isempty(handles)
            varargout{1} = handles.output;
        end
        delete(handles.figure1)
        return
end


% --------------------------------------------------------------------
function menu_Callback(hObject, eventdata, handles)
% hObject    handle to menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderLayer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function sliderTime_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

handles.timeVal = round(get(hObject,'Value'));
if handles.Synch == 0
    intVal = calcInterval(handles.timeVal,handles,0,'phase');
else
    intVal = calcInterval(handles.timeVal,handles,0,'ISC');
end
set(handles.editTime,'String',intVal);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes on slider movement.
function pushbuttonTimeUp_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderTime,'Max');
mi = get(handles.sliderTime,'Min');
val = get(handles.sliderTime,'Value') + 1;
if val <= ma
    set(handles.sliderTime,'Value',val);
end

handles.timeVal = round(get(handles.sliderTime,'Value'));

if handles.Synch == 0
    intVal = calcInterval(handles.timeVal,handles,0,'phase');
else
    intVal = calcInterval(handles.timeVal,handles,0,'ISC');
end
set(handles.editTime,'String',intVal);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonTimeDown_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderTime,'Max');
mi = get(handles.sliderTime,'Min');
val = get(handles.sliderTime,'Value') - 1;
if val >= mi
    set(handles.sliderTime,'Value',val);
end

handles.timeVal = round(get(handles.sliderTime,'Value'));

if handles.Synch == 0
    intVal = calcInterval(handles.timeVal,handles,0,'phase');
else
    intVal = calcInterval(handles.timeVal,handles,0,'ISC');
end
set(handles.editTime,'String',intVal);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonTimeUpFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderTime,'Max');
mi = get(handles.sliderTime,'Min');
val = get(handles.sliderTime,'Value') + 5;
if val <= ma
    set(handles.sliderTime,'Value',val);
else
    set(handles.sliderTime,'Value',ma);
end

handles.timeVal = round(get(handles.sliderTime,'Value'));

if handles.Synch == 0
    intVal = calcInterval(handles.timeVal,handles,0,'phase');
else
    intVal = calcInterval(handles.timeVal,handles,0,'ISC');
end
set(handles.editTime,'String',intVal);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonTimeDownFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderTime,'Max');
mi = get(handles.sliderTime,'Min');
val = get(handles.sliderTime,'Value') - 5;
if val >= mi
    set(handles.sliderTime,'Value',val);
else
    set(handles.sliderTime,'Value',mi);
end

handles.timeVal = round(get(handles.sliderTime,'Value'));

if handles.Synch == 0
    intVal = calcInterval(handles.timeVal,handles,0,'phase');
else
    intVal = calcInterval(handles.timeVal,handles,0,'ISC');
end
set(handles.editTime,'String',intVal);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function sliderTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


function editTime_Callback(hObject, eventdata, handles)
% hObject    handle to editTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editTime as text
%        str2double(get(hObject,'String')) returns contents of editTime as a double


% --- Executes during object creation, after setting all properties.
function editTime_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editTime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuSession.
function popupmenuSession_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuSession contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuSession

handles.dataset = get(hObject,'Value');
handles.timeVal = 1;
if handles.Pub.winOn == 1
    intVal = calcInterval(handles.timeVal,handles);
    set(handles.editTime,'String',intVal);
    set(handles.sliderTime,'Value',1)
    nrTIs = handles.Priv.nrTimeIntervals(handles.dataset);
    set(handles.sliderTime,'max',nrTIs,...
        'SliderStep',[1/nrTIs 10/nrTIs])
end

if handles.dataset <= handles.dataset2
    handles.sessionComp = handles.sessionCompTable(handles.dataset,handles.dataset2);
else
    handles.sessionComp = handles.sessionCompTable(handles.dataset2,handles.dataset);
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuSession_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function popupmenuSessionComp_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.dataset2 = get(hObject,'Value');
if handles.dataset <= handles.dataset2
    handles.sessionComp = handles.sessionCompTable(handles.dataset,handles.dataset2);
else
    handles.sessionComp = handles.sessionCompTable(handles.dataset2,handles.dataset);
end
handles.changeInCurrentAxes = 1;
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);



% Hints: contents = get(hObject,'String') returns popupmenuSession contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuSession
%
% handles.dataset = get(hObject,'Value');
% handles.timeVal = 1;
% if handles.Pub.winOn == 1
%     intVal = calcInterval(handles.timeVal,handles);
%     set(handles.editTime,'String',intVal);
%     set(handles.sliderTime,'Value',1)
%     nrTIs = handles.Priv.nrTimeIntervals(handles.dataset);
%     set(handles.sliderTime,'max',nrTIs,...
%         'SliderStep',[1/nrTIs 10/nrTIs])
% end
% handles.changeInCurrentAxes = 1;
% handles = update_figs(handles);
% guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuSessionComp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuSession (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function checkboxTh_Callback(hObject, eventdata, handles)

handles = setThresholdView(handles);
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes on button press in radiobuttonIsolationAtlas.
function radiobuttonAutomaticTh_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationAtlas
set(hObject,'Value',1)
set(handles.radiobuttonAtlasTh,'Value',0)
set(handles.radiobuttonManualTh,'Value',0)
handles = setThresholdView(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in radiobuttonIsolationAtlas.
function radiobuttonManualTh_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationAtlas
set(hObject,'Value',1)
set(handles.radiobuttonAutomaticTh,'Value',0)
set(handles.radiobuttonAtlasTh,'Value',0)
handles = setThresholdView(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in radiobuttonIsolationAtlas.
function radiobuttonAtlasTh_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonIsolationAtlas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobuttonIsolationAtlas
set(hObject,'Value',1)
set(handles.radiobuttonAutomaticTh,'Value',0)
set(handles.radiobuttonManualTh,'Value',0)
handles = setThresholdView(handles);
handles = update_figs(handles);
guidata(hObject, handles);

function editThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to editThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editThreshold as text
%        str2double(get(hObject,'String')) returns contents of editThreshold as a double
Val = str2double(get(hObject,'String'));

if ~(~isnumeric(Val) || Val < 0 || isnan(Val) || isinf(Val) || length(Val) ~= 1 )
    % update threshold:
    handles.Threshold = Val;
    handles.changeInCurrentAxes = 1;
    %    if  Val > handles.ScaleMax1
    %        handles.ScaleMax1 = 2*Val;
    %    end
    %    if Val < handles.ScaleMin1
    %        handles.ScaleMin1 = Val/2;
    %    end
    handles = update_figs(handles);
    guidata(hObject, handles);
else
    set(hObject,'Value',handles.Threshold)
    handles = update_figs(handles);
    guidata(hObject, handles);
    %    handles = setCurrentColorBar(handles);
end

% --- Executes during object creation, after setting all properties.
function editThreshold_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonNewFigure.
function pushbuttonSliceFigure_Callback(hObject, eventdata, handles)

T = createImageData(handles);
if handles.allFreq
    STR = 'All frequency bands';
    titl = '';
elseif handles.freqCompOn && handles.ZPFtest == 2
    STR = 'comp';
    titl = 'Frequency band comparison';
elseif handles.sessionCompOn && handles.correction == 1
    STR = 'comp';
    titl = {['Session ' num2str(handles.dataset) ' > ' 'Session ' num2str(handles.dataset2)];['voxel based MCC']};
elseif handles.sessionCompOn && handles.correction == 2
    
    STR = 'nobars';
    titl = {['Session ' num2str(handles.dataset) ' > ' 'Session ' num2str(handles.dataset2)];['cluster based MCC']};
else
    STR = '';
    
    titl = ['Session ' num2str(handles.dataset)];
end
Colbar2 = kuvaPlottaus(T,STR,'');
text(200,30,titl,'color','white','Units','pixels')
assignin('base','Colbar2',Colbar2)


% --- Executes on button press in pushbuttonNewFigure.
function pushbuttonNewFigure_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonNewFigure (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%

% get plotting parameters:
H = gui_window_figure(handles);

handles.rowPlot = H.rowPlot;
handles.colPlot = H.colPlot;
handles.plotColbar = H.plotColbar;
handles.newFigure = H.newFigure;
handles.figureBand = H.figureBand;
handles.figureSim = H.figureSim;
handles.figureSet = H.figureSet;
handles.annotationsOn = H.annotationsOn;

if handles.newFigure
    handles.figureData{1} = find(handles.figureBand);
    handles.figureData{2} = find(handles.figureSim);
    handles.figureData{3} = find(handles.figureSet);
    iter = 1;
    CurrentDataTmp = handles.CurrentData;
    SimMeasureTmp = handles.SimMeasure;
    freqBandTmp = handles.freqBand;
    datasetTmp = handles.dataset;
    freqCompTmp = handles.freqComp;
    changeInCurrentAxesTmp = handles.changeInCurrentAxes;
    %HF = figure;
    if handles.freqCompOn
        K = 1;
    else
        K = length(handles.figureData{handles.rowPlot});
    end
    for k = 1:K
        for m = 1:length(handles.figureData{handles.colPlot})
            % set(0,'CurrentFigure',HF)
            %        subplot(length(simM),length(bands),iter)
            if handles.rowPlot == 1
                handles.freqBand = handles.figureData{1}(k);
            end
            if handles.colPlot == 1
                handles.freqBand = handles.figureData{1}(m);
            end
            if handles.rowPlot == 2
                handles.SimMeasure = handles.figureData{2}(k);
            end
            if handles.colPlot == 2
                handles.SimMeasure = handles.figureData{2}(m);
            end
            if handles.rowPlot == 3
                handles.dataset = handles.figureData{3}(k);
            end
            if handles.colPlot == 3
                handles.dataset = handles.figureData{3}(m);
            end
            %            handles.SimMeasure = simM(k);
            handles.freqComp = zeros(1,6);
            handles.freqComp(handles.figureData{1}(m)) = 1;
            handles.changeInCurrentAxes = 1;
            handles = update_figs(handles);
            iter = iter + 1;
            handles.newFigure = iter;
        end
    end
    for mm = 1:length(handles.CurrentData)
        figure;axis off;
        %        colMap = setFigureColorMap(handles);
        %montage(handles.CurrentData,colMap);
        %handles.CurrentData;
        %         G = cat(zeros(size(handles.CurrentData,1),size(handles.CurrentData,2),size(handles.CurrentData,3));
        %         G(:,:,:) = handles.CurrentData(:,:,:,mm);
        montageModif(handles.CurrentData{mm},handles.colMap,...
            length(handles.figureData{handles.rowPlot}),...
            length(handles.figureData{handles.colPlot}));
        if handles.annotationsOn
            switch handles.activeAxes
                case 1
                    STR = [get(handles.textAxial,'String')];
                case 2
                    STR = [get(handles.textCoronal,'String')];
                case 3
                    STR = [get(handles.textSagittal,'String')];
            end
            for m = 1:length(handles.figureData{handles.colPlot})
                for k = 1:length(handles.figureData{handles.rowPlot})
                    text(4+(m-1)*size(handles.CurrentData,2),6+(k-1)*size(handles.CurrentData,1),STR,'Color','w');
                end
            end
        end
        if handles.plotColbar
            %figure;
            %setFigureColorMap(handles);axis off;
            if handles.freqCompOn
                mi = handles.ScaleMinPF;
                Ma = handles.ScaleMaxPF;
            else
                mi = handles.ScaleMin1;
                Ma = handles.ScaleMax1;
            end
            figure;colormap(hot);M=colorbar;
            set(M,'YTick',[1 65],'YTickLabel',[mi Ma]);
            axis off;set(gcf,'Position',[843   378   157   418]);
        end
    end
    handles.SimMeasure = SimMeasureTmp;
    handles.CurrentData = CurrentDataTmp;
    handles.freqComp = freqCompTmp;
    handles.dataset = datasetTmp;
    handles.freqBand = freqBandTmp;
    changeInCurrentAxes = changeInCurrentAxesTmp;
    handles.newFigure = 0;
    guidata(hObject, handles);
end

% --- Executes on button press in checkboxCompareFreqs.
function checkboxCompareFreqs_Callback(hObject, eventdata, handles)

function checkboxAllFrequencies_Callback(hObject, eventdata, handles)

if get(hObject,'Value')
    set(handles.radiobuttonFreqCompOn,'Value',0)
    set(handles.checkboxSessionCompOn,'Value',0)
    set(handles.popupmenuFreqBandComp,'Enable','off')
    set(handles.popupmenuSessionComp,'Enable','off')
    handles.allFreq = 1;
    handles.sessionCompOn = 0;
    handles.freqCompOn = 0;
    %    set(gcf,'Colormap',handles.colMapAllBands);
else
    %    set(handles.radiobuttonFreqCompOn,'Enable','on')
    handles.allFreq = 0;
    %    set(gcf,'Colormap',handles.colMap);
end

if handles.Pub.winOn || handles.Pub.calcPhase
    set(handles.checkboxTimeWindow,'Enable','on')
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);





% --- Executes on button press in checkboxTimeWindow.
function checkboxTimeWindow_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxTimeWindow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxTimeWindow

if get(hObject,'Value')
    handles.timeWinAnalysis = 1;
    %    if Pub.winOn == 1
    if handles.Synch == 0
        nrTIs = handles.Priv.dataSize(handles.dataset,4);
        set(handles.sliderTime,'Value',1,'max',nrTIs,'SliderStep',[1/nrTIs 10/nrTIs])
        set(handles.pushbuttonAnalysisSynch,'Enable','on')
        % set initial time-interval for time-interval box:
        intVal = calcInterval(handles.timeVal,handles,0,'phase');
        set(handles.editTime,'String',intVal);
    else
        nrTIs = handles.Priv.nrTimeIntervals(1);
        handles.win = 1;
        set(handles.sliderTime,'Value',1,'max',nrTIs,'SliderStep',[1/nrTIs 10/nrTIs])
        set(handles.pushbuttonAnalysisSynch,'Enable','on')
        % set initial time-interval for time-interval box:
        intVal = calcInterval(handles.timeVal,handles,0,'ISC');
        set(handles.editTime,'String',intVal);
    end
    %    set(handles.sliderTime,'Visible','on')
    handles = setTemporalSettings(handles,'on');
    %    set(handles.editTime,'Visible','on')
    %    set(handles.textTime,'Visible','on')
    %    set(handles.pushbuttonTimeUp,'Visible','on')
    %    set(handles.pushbuttonTimeUpFast,'Visible','on')
    %    set(handles.pushbuttonTimeDown,'Visible','on')
    %    set(handles.pushbuttonTimeDownFast,'Visible','on')
    %
    %    set(handles.pushbuttonExportSynch,'Enable','on')
    %    set(handles.checkboxNormalSynch,'Enable','on')
    %    set(handles.pushbuttonPlotSynch,'Enable','on')
    %    set(handles.radionButtonPhaseSynch,'Enable','on')
    %    set(handles.radionButtonSynch,'Enable','on')
    %    set(handles.radionButtonSynchMean,'Enable','on')
    %    set(handles.radionButtonSynchMedian,'Enable','on')
    %    set(handles.radionButtonSynchThres,'Enable','on')
    %    set(handles.textROI,'Enable','on')
    %    %%%%%%%%%%%%%%%%%%%%%%%%
    % CURRENTLY SET OFF
    %    set(handles.pushbuttonAnalysisSynch,'Enable','off')
    %    set(handles.pushbuttonAnalysisSynch,'Enable','on')
    %%%%%%%%%%%%%%%%%%%%%%%%
else
    handles = setTemporalSettings(handles,'off');
    
    
    
    %   handles.timeVal = 1;
    %     set(handles.textROI,'Enable','off')
    %     set(handles.sliderTime,'Visible','off','Value',1)
    %     set(handles.editTime,'Visible','off')
    %     set(handles.pushbuttonTimeUp,'Visible','off')
    %     set(handles.pushbuttonTimeUpFast,'Visible','off')
    %     set(handles.pushbuttonTimeDown,'Visible','off')
    %     set(handles.pushbuttonTimeDownFast,'Visible','off')
    %     set(handles.textTime,'Visible','off')
    %     set(handles.pushbuttonExportSynch,'Enable','off')
    %     set(handles.pushbuttonPlotSynch,'Enable','off')
    %     set(handles.radionButtonPhaseSynch,'Enable','off')
    %     set(handles.checkboxNormalSynch,'Enable','off')
    %     set(handles.radionButtonSynch,'Enable','off')
    %     set(handles.radionButtonSynchMean,'Enable','off')
    %     set(handles.radionButtonSynchMedian,'Enable','off')
    %     set(handles.radionButtonSynchThres,'Enable','off')
    %     set(handles.pushbuttonAnalysisSynch,'Enable','off')
    %    handles.win = 0;
end

if handles.Pub.winOn == 0
    set(handles.radionButtonSynch,'Enable','off')
end
if handles.Pub.calcPhase == 0
    set(handles.radionButtonPhaseSynch,'Enable','off')
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in pushbuttonInspectRegion.
function pushbuttonInspectRegion_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonInspectRegion (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of pushbuttonNewFigure
%Q=get(handles.dataImage);
%E=Q.CData;
%E(find(E<65)) = round(100*(E(find(E<65))./64))./100;
%figure;H = image;
%set(H,'CData',E)

hpanel = impixelregion(handles.dataImage);
%set(hpanel, 'Position', [0 0 .5 .5])
%guidata(hObject, handles);

function checkboxShowAtlas_Callback(hObject, eventdata, handles)

handles.showAtlas = get(hObject,'Value');
%handles = loadAtlasData(handles);
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function sliderAxial_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

handles.activeAxes = 1;
origCoord = round(get(hObject,'Value'));
handles.zMNI = handles.coordinateProd(3)*origCoord+handles.coordinateShift(3);
%set(handles.textAxial,'String',['z (MNI in mm) = ' num2str(handles.zMNI)...
%    '                    z (matlab) = ' num2str(handles.layerVals(3))])

set(handles.textAxial,'String',['z (MNI mm) = ' num2str(handles.zMNI)])
set(handles.textAxialMatlab,'String',['z (Matlab) = ' num2str(handles.layerVals(3))])

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonAxialLeftSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderAxial,'max');
mi = get(handles.sliderAxial,'min');

%newCoord = min(round(get(handles.sliderAxial,'Value'))+10,ma);
newCoord = max(round(get(handles.sliderAxial,'Value'))-1,1);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-10,1);
%newCoord = min(round(get(handles.sliderAxial,'Value'))+1,ma);
set(handles.sliderAxial,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.zMNI = Coord_MNI(3);
handles.activeAxes = 1;

%origCoord = max(round(get(handles.sliderAxial,'Value')) - mi,1);
%set(handles.sliderAxial,'Value',origCoord)

%handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
%handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
%handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

%handles.activeAxes = 1;
%handles.zMNI = handles.coordinateProd(3)*origCoord+handles.coordinateShift(3);
%set(handles.textAxial,'String',['z (MNI in mm) = ' num2str(handles.zMNI)...
%    '                    z (matlab) = ' num2str(handles.layerVals(3))])

set(handles.textAxial,'String',['z (MNI mm) = ' num2str(handles.zMNI)])
set(handles.textAxialMatlab,'String',['z (Matlab) = ' num2str(handles.layerVals(3))])

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonAxialLeftFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderAxial,'max');
mi = get(handles.sliderAxial,'min');

%newCoord = min(round(get(handles.sliderAxial,'Value'))+10,ma);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-1,1);
newCoord = max(round(get(handles.sliderAxial,'Value'))-10,1);
%newCoord = min(round(get(handles.sliderAxial,'Value'))+1,ma);
set(handles.sliderAxial,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.zMNI = Coord_MNI(3);
handles.activeAxes = 1;

set(handles.textAxial,'String',['z (MNI mm) = ' num2str(handles.zMNI)])
set(handles.textAxialMatlab,'String',['z (Matlab) = ' num2str(handles.layerVals(3))])

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonAxialRightFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderAxial,'max');
mi = get(handles.sliderAxial,'min');

newCoord = min(round(get(handles.sliderAxial,'Value'))+10,ma);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-1,1);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-10,1);
%newCoord = min(round(get(handles.sliderAxial,'Value'))+1,ma);
set(handles.sliderAxial,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.zMNI = Coord_MNI(3);
handles.activeAxes = 1;

set(handles.textAxial,'String',['z (MNI mm) = ' num2str(handles.zMNI)])
set(handles.textAxialMatlab,'String',['z (Matlab) = ' num2str(handles.layerVals(3))])

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonAxialRightSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderAxial,'max');
mi = get(handles.sliderAxial,'min');

%newCoord = min(round(get(handles.sliderAxial,'Value'))+10,ma);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-1,1);
%newCoord = max(round(get(handles.sliderAxial,'Value'))-10,1);
newCoord = min(round(get(handles.sliderAxial,'Value'))+1,ma);
set(handles.sliderAxial,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.zMNI = Coord_MNI(3);
handles.activeAxes = 1;

set(handles.textAxial,'String',['z (MNI mm) = ' num2str(handles.zMNI)])
set(handles.textAxialMatlab,'String',['z (Matlab) = ' num2str(handles.layerVals(3))])

handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function sliderAxial_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --- Executes on slider movement.
function sliderCoronal_Callback(hObject, eventdata, handles)
% hObject    handle to sliderCoronal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

origCoord = round(get(hObject,'Value'));
handles.yMNI = handles.coordinateProd(2)*origCoord+handles.coordinateShift(2);
set(handles.textCoronal,'String',['y (MNI mm) = ' num2str(handles.yMNI)])
set(handles.textCoronalMatlab,'String',['y (Matlab) = ' num2str(handles.layerVals(2))])

handles.activeAxes = 2;

%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);

guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonCoronalLeftSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderCoronal,'max');
mi = get(handles.sliderCoronal,'min');

%origCoord = max(round(get(handles.sliderCoronal,'Value')) - mi,1);
%set(handles.sliderCoronal,'Value',origCoord)
%handles.yMNI = handles.coordinateProd(2)*origCoord+handles.coordinateShift(2);

newCoord = max(round(get(handles.sliderCoronal,'Value')) - 1,1);
set(handles.sliderCoronal,'Value',newCoord)

handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.yMNI = Coord_MNI(2);

set(handles.textCoronal,'String',['y (MNI mm) = ' num2str(handles.yMNI)])
set(handles.textCoronalMatlab,'String',['y (Matlab) = ' num2str(handles.layerVals(2))])

handles.activeAxes = 2;

%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);

guidata(hObject, handles);
% --- Executes on slider movement.
function pushbuttonCoronalLeftFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderCoronal,'max');
mi = get(handles.sliderCoronal,'min');

newCoord = max(round(get(handles.sliderCoronal,'Value')) - 10,1);
set(handles.sliderCoronal,'Value',newCoord)

handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.yMNI = Coord_MNI(2);

set(handles.textCoronal,'String',['y (MNI mm) = ' num2str(handles.yMNI)])
set(handles.textCoronalMatlab,'String',['y (Matlab) = ' num2str(handles.layerVals(2))])

handles.activeAxes = 2;

%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);

guidata(hObject, handles);
% --- Executes on slider movement.
function pushbuttonCoronalRightFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderCoronal,'max');
mi = get(handles.sliderCoronal,'min');

newCoord = min(round(get(handles.sliderCoronal,'Value')) + 10,ma);
set(handles.sliderCoronal,'Value',newCoord)

handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));

AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.yMNI = Coord_MNI(2);


% origCoord = min(round(get(handles.sliderCoronal,'Value')) + 10,ma);
% set(handles.sliderCoronal,'Value',origCoord)
% 
% handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
% handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
% handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
% handles.yMNI = handles.coordinateProd(2)*origCoord+handles.coordinateShift(2);


set(handles.textCoronal,'String',['y (MNI mm) = ' num2str(handles.yMNI)])
set(handles.textCoronalMatlab,'String',['y (Matlab) = ' num2str(handles.layerVals(2))])
handles.activeAxes = 2;
%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonCoronalRightSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

ma = get(handles.sliderCoronal,'max');
mi = get(handles.sliderCoronal,'min');

newCoord = min(round(get(handles.sliderCoronal,'Value')) + 1,ma);
set(handles.sliderCoronal,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.yMNI = Coord_MNI(2);

set(handles.textCoronal,'String',['y (MNI mm) = ' num2str(handles.yMNI)])
set(handles.textCoronalMatlab,'String',['y (Matlab) = ' num2str(handles.layerVals(2))])

handles.activeAxes = 2;
%set(handles.editLayer,'String',num2str(handles.layerVal));
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function sliderCoronal_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderCoronal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function sliderSagittal_Callback(hObject, eventdata, handles)
% hObject    handle to sliderSagittal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
origCoord = round(get(hObject,'Value'));
handles.xMNI = handles.coordinateProd(1)*origCoord+handles.coordinateShift(1);
%handles.xMNI = -1*handles.xMNI;
set(handles.textSagittal,'String',['x (MNI mm) = ' num2str(handles.xMNI)])
set(handles.textSagittalMatlab,'String',['x (Matlab) = ' num2str(handles.layerVals(1))])
handles.activeAxes = 3;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
function pushbuttonSagittalRightSlow_Callback(hObject, eventdata, handles)
%function pushbuttonSagittalLeftSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

% origCoord = max(round(get(handles.sliderSagittal,'Value')) - mi,1);
% set(handles.sliderSagittal,'Value',origCoord)
% 
% handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
% handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
% handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
% handles.xMNI = handles.coordinateProd(1)*origCoord+handles.coordinateShift(1);
%handles.xMNI = -1*handles.xMNI;

ma = get(handles.sliderSagittal,'max');
mi = get(handles.sliderSagittal,'min');

newCoord = max(round(get(handles.sliderSagittal,'Value'))+1,1);
set(handles.sliderSagittal,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.xMNI = Coord_MNI(1);

set(handles.textSagittal,'String',['x (MNI mm) = ' num2str(handles.xMNI)])
set(handles.textSagittalMatlab,'String',['x (Matlab) = ' num2str(handles.layerVals(1))])
handles.activeAxes = 3;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes on slider movement.
function pushbuttonSagittalRightFast_Callback(hObject, eventdata, handles)
%function pushbuttonSagittalLeftFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
ma = get(handles.sliderSagittal,'max');
mi = get(handles.sliderSagittal,'min');

newCoord = max(round(get(handles.sliderSagittal,'Value'))+10,1);
set(handles.sliderSagittal,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
%Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.xMNI = Coord_MNI(1);

set(handles.textSagittal,'String',['x (MNI mm) = ' num2str(handles.xMNI)])
set(handles.textSagittalMatlab,'String',['x (Matlab) = ' num2str(handles.layerVals(1))])
handles.activeAxes = 3;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
%function pushbuttonSagittalRightFast_Callback(hObject, eventdata, handles)
function pushbuttonSagittalLeftFast_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
ma = get(handles.sliderSagittal,'max');
mi = get(handles.sliderSagittal,'min');

newCoord = min(round(get(handles.sliderSagittal,'Value'))-10,ma);
set(handles.sliderSagittal,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.xMNI = Coord_MNI(1);

set(handles.textSagittal,'String',['x (MNI mm) = ' num2str(handles.xMNI)])
set(handles.textSagittalMatlab,'String',['x (Matlab) = ' num2str(handles.layerVals(1))])
handles.activeAxes = 3;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on slider movement.
%function pushbuttonSagittalRightSlow_Callback(hObject, eventdata, handles)
function pushbuttonSagittalLeftSlow_Callback(hObject, eventdata, handles)
% hObject    handle to sliderAxial (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
ma = get(handles.sliderSagittal,'max');
mi = get(handles.sliderSagittal,'min');

%newCoord = min(round(get(handles.sliderSagittal,'Value'))+10,ma);
%newCoord = max(round(get(handles.sliderSagittal,'Value'))-10,1);

newCoord = min(round(get(handles.sliderSagittal,'Value'))-1,ma);
set(handles.sliderSagittal,'Value',newCoord)
handles.layerVals(1) = round(get(handles.sliderSagittal,'Value'));
handles.layerVals(2) = round(get(handles.sliderCoronal,'Value'));
handles.layerVals(3) = round(get(handles.sliderAxial,'Value'));
AffMat = [-2 0 0 90; 0 2 0 -126;0 0 2 -72; 0 0 0 1];
Coord_matlab = handles.layerVals;
Coord_voxel = [91-Coord_matlab(1) Coord_matlab(2)-1 Coord_matlab(3)-1 1]';
Coord_MNI =  round(AffMat*Coord_voxel);
handles.xMNI = Coord_MNI(1);

set(handles.textSagittal,'String',['x (MNI mm) = ' num2str(handles.xMNI)])
set(handles.textSagittalMatlab,'String',['x (Matlab) = ' num2str(handles.layerVals(1))])
handles.activeAxes = 3;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function sliderSagittal_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderSagittal (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end

% --------------------------------------------------------------------
function FileOpen_Callback(hObject, eventdata, handles)
% hObject    handle to FileOpen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[filename, pathname] = uigetfile({'*.mat','MAT-files (*.mat)'},'Pick a file');
if ~isequal(filename,0)
    if exist([pathname filename],'file') == 2
        handles.paramFile = fullfile(pathname, filename);
        load(handles.paramFile);
        if exist('Params','var') % Params-struct must exists.
            % Expected location of the atlas path:
            atlasPath = Params.PublicParams.atlasPath;
            % Check if atlas path is correct:
            closeFig = 0;
            [flag,correctAtlasPath,Params] = checkAndSetMaskAndAtlasPath(atlasPath,Params,closeFig);
            if ~flag
                %                delete(handles.figure1)
                return
            else
                setAtlasAndMaskPath(correctAtlasPath,Params,handles.paramFile);
            end
        end
%        changeDirectory(pathname);
        load(handles.paramFile);
        handles.ParamStructInput = Params;
        [handles,errFlag] = getParams(handles);
        if errFlag == 0
            handles = enablePanels(handles);
            guidata(hObject, handles);
        end
    end
end

function handles = enablePanels(handles)

if handles.Pub.winOn == 0
    set(handles.radionButtonSynch,'Enable','off')
end
if handles.Pub.calcPhase == 0
    set(handles.radionButtonPhaseSynch,'Enable','off')
end

if handles.Pub.winOn == 0 && handles.Pub.calcPhase == 0
    %    set(handles.uipanelTemporalSettings,'Visible','off')
    set(handles.checkboxTimeWindow,'Enable','off')
else
    set(handles.checkboxTimeWindow,'Enable','on')
    %    set(handles.uipanelTemporalSettings,'Visible','on')
end

if handles.Priv.nrSessions > 1 && handles.Pub.sessionCompOn
    set(handles.checkboxSessionCompOn,'Enable','on')
    set(handles.popupmenuSessionComp,'Enable','off')
else
    set(handles.checkboxSessionCompOn,'Enable','off')
    set(handles.popupmenuSessionComp,'Enable','off')
end

if handles.Pub.nrFreqBands > 0 && handles.Pub.freqCompOn
    set(handles.radiobuttonFreqCompOn,'Visible','on')
    set(handles.popupmenuFreqBandComp,'Visible','on')
    set(handles.checkboxAllFrequencies,'Visible','on')
else
    set(handles.radiobuttonFreqCompOn,'Visible','off')
    set(handles.popupmenuFreqBandComp,'Visible','off')
    set(handles.checkboxAllFrequencies,'Visible','off')
end

set(handles.uipanelOrientation,'Visible','off')
%set(handles.uipanelOrientation,'Visible','on')
set(handles.pushbuttonTimeUp,'Visible','off')
set(handles.pushbuttonTimeUpFast,'Visible','off')
set(handles.pushbuttonTimeDown,'Visible','off')
set(handles.pushbuttonTimeDownFast,'Visible','off')


set(handles.uipanelSegment,'Visible','on')

set(handles.axialImage,'Visible','on')
set(handles.coronalImage,'Visible','on')
set(handles.sagittalImage,'Visible','on')
set(handles.axesAxial,'Visible','on')
set(handles.axesSagittal,'Visible','on')
set(handles.axesCoronal,'Visible','on')
%set(handles.sliderSagittal,'Visible','on')
%set(handles.sliderCoronal,'Visible','on')
%set(handles.sliderAxial,'Visible','on')
set(handles.checkboxSwapBytes,'Visible','on')

set(handles.edit1ScaleMax,'Visible','off')
set(handles.edit1ScaleMin,'Visible','off')
set(handles.text9,'Visible','off')
set(handles.text10,'Visible','off')

function handles = disablePanels(handles)

%set(handles.uipanelFrequency,'Visible','off')
%set(handles.uipanelTemporalSettings,'Visible','off')
set(handles.uipanelOrientation,'Visible','off')
set(handles.uipanelSegment,'Visible','off')
%set(handles.uipanelButtons,'Visible','off')
%set(h82,'Visible','off')

set(handles.edit1ScaleMax,'Visible','off')
set(handles.edit1ScaleMin,'Visible','off')
set(handles.editLayer,'Visible','off')
set(handles.editTime,'Visible','off')

set(handles.axesAxial,'Visible','off')
set(handles.axes1,'Visible','off')
set(handles.axesAtlas,'Visible','off')
set(handles.sliderLayer,'Visible','off')
set(handles.sliderTime,'Visible','off')
set(handles.sliderSagittal,'Visible','off')
set(handles.sliderCoronal,'Visible','off')
set(handles.sliderAxial,'Visible','off')
set(handles.checkboxSwapBytes,'Visible','off')

set(handles.axesSagittal,'Visible','off')
set(handles.axesCoronal,'Visible','off')







% --- Creates and returns a handle to the GUI figure.
function h1 = fMRI_GUI_export_LayoutFcn(policy)
% policy - create a new figure or use a singleton. 'new' or 'reuse'.

persistent hsingleton;
if strcmpi(policy, 'reuse') & ishandle(hsingleton)
    h1 = hsingleton;
    return;
end

appdata = [];
appdata.GUIDEOptions = struct(...
    'active_h', [], ...
    'taginfo', struct(...
    'figure', 2, ...
    'slider', 10, ...
    'edit', 11, ...
    'axes', 6, ...
    'uipanel', 16, ...
    'listbox', 3, ...
    'radiobutton', 22, ...
    'text', 26, ...
    'pushbutton', 7, ...
    'popupmenu', 13, ...
    'checkbox', 7), ...
    'override', 1, ...
    'release', 13, ...
    'resize', 'simple', ...
    'accessibility', 'callback', ...
    'mfile', 1, ...
    'callbacks', 1, ...
    'singleton', 1, ...
    'syscolorfig', 1, ...
    'blocking', 0, ...
    'lastSavedFile', 'D:\Tutkimus\fMRI\matlab codes\GUI2\fMRI_GUI_export.m', ...
    'lastFilename', 'C:\fMRI data\GUI\fMRI_GUI.fig');
appdata.lastValidTag = 'figure1';
appdata.GUIDELayoutEditor = [];

h1 = figure(...
    'Units','characters',...
    'PaperUnits',get(0,'defaultfigurePaperUnits'),...
    'Color',[0.941176470588235 0.941176470588235 0.941176470588235],...
    'Colormap',[0 0 0.5625;0 0 0.625;0 0 0.6875;0 0 0.75;0 0 0.8125;0 0 0.875;0 0 0.9375;0 0 1;0 0.0625 1;0 0.125 1;0 0.1875 1;0 0.25 1;0 0.3125 1;0 0.375 1;0 0.4375 1;0 0.5 1;0 0.5625 1;0 0.625 1;0 0.6875 1;0 0.75 1;0 0.8125 1;0 0.875 1;0 0.9375 1;0 1 1;0.0625 1 1;0.125 1 0.9375;0.1875 1 0.875;0.25 1 0.8125;0.3125 1 0.75;0.375 1 0.6875;0.4375 1 0.625;0.5 1 0.5625;0.5625 1 0.5;0.625 1 0.4375;0.6875 1 0.375;0.75 1 0.3125;0.8125 1 0.25;0.875 1 0.1875;0.9375 1 0.125;1 1 0.0625;1 1 0;1 0.9375 0;1 0.875 0;1 0.8125 0;1 0.75 0;1 0.6875 0;1 0.625 0;1 0.5625 0;1 0.5 0;1 0.4375 0;1 0.375 0;1 0.3125 0;1 0.25 0;1 0.1875 0;1 0.125 0;1 0.0625 0;1 0 0;0.9375 0 0;0.875 0 0;0.8125 0 0;0.75 0 0;0.6875 0 0;0.625 0 0;0.5625 0 0],...
    'IntegerHandle','off',...
    'InvertHardcopy',get(0,'defaultfigureInvertHardcopy'),...
    'MenuBar','none',...
    'Name','fMRI_GUI',...
    'NumberTitle','off',...
    'PaperPosition',get(0,'defaultfigurePaperPosition'),...
    'PaperSize',[20.98404194812 29.67743169791],...
    'PaperType',get(0,'defaultfigurePaperType'),...
    'Position',[5.6 8.76923076923077 246 56.5384615384615],...
    'ResizeFcn','fMRI_GUI_export(''figure1_ResizeFcn'',gcbo,[],guidata(gcbo))',...
    'HandleVisibility','callback',...
    'Tag','figure1',...
    'UserData',[],...
    'Behavior',get(0,'defaultfigureBehavior'),...
    'Visible','on',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'uipanelOrientation';

h2 = uipanel(...
    'Parent',h1,...
    'Title','Orientation',...
    'Tag','uipanelOrientation',...
    'Behavior',get(0,'defaultuipanelBehavior'),...
    'Clipping','on','Visible','off',...
    'Position',[0.0138211382113821 0.0122448979591837 0.116260162601626 0.0938775510204081],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'popupmenuOrient';

h3 = uicontrol(...
    'Parent',h2,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuOrient_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.143884892086331 0.39622641509434 0.712230215827338 0.433962264150943],...
    'String','-----',...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuOrient_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuOrient');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'uipanelAtlasSettings';

h2100 = uipanel(...
    'Parent',h1,...
    'Units','normalized',...
    'Title','Atlas settings',...
    'Tag','uipanelAtlasSettings',...
    'Behavior',get(0,'defaultuipanelBehavior'),...
    'Clipping','on',...
    'Position',[0.6 0.65 0.3 0.35],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'checkboxAtlasRegionType';


appdata = [];
appdata.lastValidTag = 'popupmenuAtlasThreshold';

h34 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuAtlasThreshold_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.3 0.25 0.1],...
    'String',[{'Th 0%'},{'Th 25%'},{'Th 50%'}],...
    'Style','popupmenu',...
    'Value',3,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuAtlasThreshold_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuAtlasThreshold');%,...
%  'Behavior',get(0,'defaultuicontrolBehavior'));

h1028 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxAtlasRegionType_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.73 0.25 0.1],...
    'String','Fill regions','Value',1,...
    'Style','checkbox',...
    'Tag','checkboxAtlasRegionType',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'pushbuttonAddRegion';

h1025 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAddRegion_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.6 0.28 0.1],...
    'String','select',...
    'Tag','pushbuttonAddRegion',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...



appdata = [];
appdata.lastValidTag = 'pushbuttonRemoveRegion';

h1026 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonRemoveRegion_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.45 0.28 0.1],...
    'String','de-select',...
    'Tag','pushbuttonRemoveRegion',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'pushbuttonClearAtlas';

h1026 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonClearAtlas_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.02 0.28 0.1],...
    'String','reset',...
    'Tag','pushbuttonClearAtlas',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%'Behavior',get(0,'defaultuicontrolBehavior'),...



appdata = [];
appdata.lastValidTag = 'checkboxShowAtlas';

h1024 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxShowAtlas_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.85 0.25 0.1],...
    'String','Show regions','Value',1,...
    'Style','checkbox',...
    'Tag','checkboxShowAtlas',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%   'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuAtlas';

h4 = uicontrol(...
    'Parent',h2100,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuAtlas_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.02 0.03 0.65 0.93],...
    'String',' ',...
    'Style','listbox',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuAtlas_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuAtlas');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'pushbuttonUpdateRegions';

h1026 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonUpdateRegions_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.82 0.9 0.053 0.03],'Visible','off',...
    'String','Update regions',...
    'Tag','pushbuttonUpdateRegions',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonSliceFigure';

h1027 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonSliceFigure_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.92 0.9 0.072 0.03],...
    'String','Plot axial slices',...
    'Tag','pushbuttonSliceFigure',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'listboxAtlasList';

h1022 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''listboxAtlasList_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.43 0.78 0.1 0.195],...
    'String','',...
    'Style','listbox',...
    'Value',1,'Enable','inactive','Visible','off',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''listboxAtlasList_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','listboxAtlasList');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'editLayer';

h5 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[0.949019607843137 0.949019607843137 0.949019607843137],...
    'Callback','fMRI_GUI_export(''editLayer_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.85609756097561 0.0625850340136054 0.0308943089430894 0.0285714285714286],...
    'String','50',...
    'Style','text',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''editLayer_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','editLayer');%,...
%   'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'axes1';

h6 = axes(...
    'Parent',h1,...
    'Position',[0.154471544715447 0.0938775510204081 0.336585365853659 0.657142857142857],...
    'CameraPosition',[0.5 0.5 9.16025403784439],...
    'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
    'Color',get(0,'defaultaxesColor'),...
    'ColorOrder',get(0,'defaultaxesColorOrder'),...
    'LooseInset',[0.25594596919316 0.109524315302329 0.18703743902577 0.0746756695243154],...
    'XColor',get(0,'defaultaxesXColor'),...
    'YColor',get(0,'defaultaxesYColor'),...
    'ZColor',get(0,'defaultaxesZColor'),...
    'CreateFcn', {@local_CreateFcn, '', appdata}, ...
    'Tag','axes1');%,...
%    'Behavior',get(0,'defaultaxesBehavior'),...


appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h7 = get(h6,'title');

set(h7,...
    'Parent',h6,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498792270531401 1.01345755693582 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h8 = get(h6,'xlabel');

set(h8,...
    'Parent',h6,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498792270531401 -0.0486542443064184 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','cap',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h9 = get(h6,'ylabel');

set(h9,...
    'Parent',h6,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.0688405797101449 0.497929606625259 1.00005459937205],...
    'Rotation',90,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h10 = get(h6,'zlabel');

set(h10,...
    'Parent',h6,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','right',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.460144927536232 1.37577639751553 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','middle',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','off',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.lastValidTag = 'edit1ScaleMin';

h11 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''edit1ScaleMin_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.156910569105691 0.00816326530612245 0.0317073170731707 0.0285714285714286],...
    'String','0',...
    'Style','edit',...
    'TooltipString','Set colorbar minimum scale',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''edit1ScaleMin_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','edit1ScaleMin');%,...
%  'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'edit1ScaleMax';

h12 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''edit1ScaleMax_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.37 0.00816326530612245 0.0333333333333333 0.0285714285714286],...
    'String','1',...
    'Style','edit',...
    'TooltipString','Set colorbar maximum scale',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''edit1ScaleMax_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','edit1ScaleMax');%,...
%   'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'axesAtlas';

h13 = axes(...
    'Parent',h1,...
    'Position',[0.513821138211382 0.0938775510204081 0.338211382113821 0.653061224489796],...
    'CameraPosition',[0.5 0.5 9.16025403784439],...
    'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
    'Color',get(0,'defaultaxesColor'),...
    'ColorOrder',get(0,'defaultaxesColorOrder'),...
    'LooseInset',[0.240188734523724 0.10931925547997 0.175522536767337 0.0745358560090703],...
    'XColor',get(0,'defaultaxesXColor'),...
    'YColor',get(0,'defaultaxesYColor'),...
    'ZColor',get(0,'defaultaxesZColor'),...
    'Tag','axesAtlas',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultaxesBehavior'),...


appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h14 = get(h13,'title');

set(h14,...
    'Parent',h13,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498798076923077 1.01354166666667 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h15 = get(h13,'xlabel');

set(h15,...
    'Parent',h13,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498798076923077 -0.0489583333333334 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','cap',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h16 = get(h13,'ylabel');

set(h16,...
    'Parent',h13,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.0685096153846152 0.496875 1.00005459937205],...
    'Rotation',90,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.SerializedAnnotationV7 = struct(...
    'LegendInformation', struct(...
    'IconDisplayStyle', 'on'));

h17 = get(h13,'zlabel');

set(h17,...
    'Parent',h13,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','right',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-1.52043269230769 1.384375 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','middle',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], appdata} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','off',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.lastValidTag = 'textSlice';

h18 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.85609756097561 0.0326530612244898 0.0357723577235772 0.0285714285714286],...
    'String','Slice',...
    'Style','text',...
    'Tag','textSlice',...
    'Visible','off',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'text9';

h19 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.1978 0.0108843537414966 0.02 0.0204081632653061],...
    'String','min',...
    'Visible','off',...
    'Style','text',...
    'Tag','text9',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'text10';

h20 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.33 0.00952380952380952 0.04 0.0204081632653061],...
    'String','max',...
    'Visible','off',...
    'Style','text',...
    'Tag','text10',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'text13';

h21 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.243089430894309 0.0571428571428571 0.13739837398374 0.0163265306122449],...
    'String','COLORBAR IS HERE',...
    'Style','text',...
    'Tag','text13',...
    'Visible','off',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'text15';

h22 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.622764227642276 0.0585034013605442 0.138211382113821 0.017687074829932],...
    'String','COLORBAR IS HERE',...
    'Style','text',...
    'Tag','text15',...
    'Visible','off',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'Untitled_2';

h23 = uicontextmenu(...
    'Parent',h1,...
    'Callback','fMRI_GUI_export(''Untitled_2_Callback'',gcbo,[],guidata(gcbo))',...
    'Tag','Untitled_2',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontextmenuBehavior'),...
appdata = [];
appdata.lastValidTag = 'menu';

h24 = uimenu(...
    'Parent',h1,...
    'Callback','fMRI_GUI_export(''menu_Callback'',gcbo,[],guidata(gcbo))',...
    'Label','File',...
    'Tag','menu',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuimenuBehavior'),...

appdata = [];
appdata.lastValidTag = 'FileOpen';

h25 = uimenu(...
    'Parent',h24,...
    'Accelerator','O',...
    'Callback','fMRI_GUI_export(''FileOpen_Callback'',gcbo,[],guidata(gcbo))',...
    'Label','Open...',...
    'Separator','on',...
    'Tag','FileOpen',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuimenuBehavior'),...

appdata = [];
appdata.lastValidTag = 'fileMenuDatatoWS';

h26 = uimenu(...
    'Parent',h24,...
    'Callback','fMRI_GUI_export(''fileMenuDatatoWS_Callback'',gcbo,[],guidata(gcbo))',...
    'Label','Export data to workspace',...
    'Tag','fileMenuDatatoWS',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

%    'Behavior',get(0,'defaultuimenuBehavior'),...
appdata = [];
appdata.lastValidTag = 'fileExit';

h260 = uimenu(...
    'Parent',h24,...
    'Callback','fMRI_GUI_export(''fileExit_Callback'',gcbo,[],guidata(gcbo))',...
    'Label','Exit visualization GUI',...
    'Tag','fileExit',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

%    'Behavior',get(0,'defaultuimenuBehavior'),...

appdata = [];
appdata.lastValidTag = 'sliderLayer';

h27 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[0.9 0.9 0.9],...
    'Callback','fMRI_GUI_export(''sliderLayer_Callback'',gcbo,[],guidata(gcbo))',...
    'Max',100000,...
    'Position',[0.865040650406504 0.102040816326531 0.0130081300813008 0.651700680272109],...
    'String',{  'Slider' },...
    'Style','slider',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''sliderLayer_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','sliderLayer');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'pushbuttonTimeUp';

h301 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonTimeUp_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.86-0.02-0.33 0.095+0.62 0.02 0.03],...
    'String','>',...
    'Tag','pushbuttonTimeUp',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%   'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonTimeDown';

h301 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonTimeDown_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.83-0.02-0.33 0.095+0.62 0.02 0.03],...
    'String','<',...
    'Tag','pushbuttonTimeDown',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonTimeUpFast';

h301 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonTimeUpFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.89-0.02-0.33 0.095+0.62 0.02 0.03],...
    'String','>>',...
    'Tag','pushbuttonTimeUpFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonTimeDownFast';

h301 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonTimeDownFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.80-0.02-0.33 0.095+0.62 0.02 0.03],...
    'String','<<',...
    'Tag','pushbuttonTimeDownFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'sliderTime';

h28 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[0.9 0.9 0.9],...
    'Callback','fMRI_GUI_export(''sliderTime_Callback'',gcbo,[],guidata(gcbo))',...
    'Max',1000,...
    'Min',1,...
    'Position',[0.963414634146341 0.15 0.0121951219512195 0.527891156462585],...
    'String',{  'Slider' },...
    'Style','slider',...
    'SliderStep',[0.01 0.1],...
    'Value',1,...
    'Visible','on',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''sliderTime_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','sliderTime');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'editTime';

h29 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''editTime_Callback'',gcbo,[],guidata(gcbo))',...
    'Enable','inactive',...
    'Position',[0.92-0.12-0.33 0.05+0.62 0.0634146341463415 0.04],...
    'String','----',...
    'Style','edit',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''editTime_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','editTime');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textTime';

h30 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.925-0.12-0.33 0.01+0.63 0.0512195121951219 0.02],...
    'String','Time interval',...
    'Style','text',...
    'Tag','textTime',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...




appdata = [];
appdata.lastValidTag = 'uipanelSegment';

h36 = uipanel(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.01 0.195 0.13 0.45],...
    'Title','Threshold settings',...
    'Tag','uipanelSegment',...
    'Clipping','on',...
    'Visible','off',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuipanelBehavior'),...

%h36 = uipanel(...
%    'Parent',h1,...
%    'Units','characters',...
%    'Position',[2.9 17 30 19],...
%    'Title','Threshold settings',...
%    'Tag','uipanelSegment',...
%    'Behavior',get(0,'defaultuipanelBehavior'),...
%    'Clipping','on',...
%    'Visible','off',...
%    'CreateFcn', {@local_CreateFcn, '', appdata} );


appdata = [];
appdata.lastValidTag = 'radiobuttonManualTh';

h37 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radiobuttonManualTh_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.67 0.700854700854701 0.130434782608696],...
    'String','Manual',...
    'Style','radiobutton',...
    'TooltipString','Threshold map manually',...
    'Tag','radiobuttonManualTh',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'radiobuttonAtlasTh';

h38 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radiobuttonAtlasTh_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.58 0.880341880341881 0.130434782608696],...
    'String','Atlas-based',...
    'Style','radiobutton',...
    'TooltipString','Segment map using brain atlas',...
    'Tag','radiobuttonAtlasTh',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'editThreshold';

h39 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''editThreshold_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.42 0.418803418803419 0.09],...
    'String','------',...
    'Style','edit',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''editThreshold_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','editThreshold');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textThreshold';

h1100 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Position',[0.08 0.53 0.700854700854701 0.05],...
    'String','threshold',...
    'Style','text',...
    'Tag','textThreshold',...
    'HorizontalAlignment','left',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'radiobuttonAutomaticTh';

h40 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radiobuttonAutomaticTh_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.76 0.700854700854701 0.12],...
    'String','Automatic',...
    'Style','radiobutton',...
    'Tag','radiobuttonAutomaticTh',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'uipanelSimMeasure';

h45 = uipanel(...
    'Parent',h1,...
    'Title','Time Settings',...%'Units','characters',...
    'Units','normalized',...%'Position',[2.9 37 30 5.5],...
    'Position',[0.42 0.76 0.17 0.24],...
    'Tag','uipanelTemporalSettings',...
    'Clipping','on',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuipanelBehavior'),...

appdata = [];
appdata.lastValidTag = 'uipanelMapType';

h1011 = uipanel(...
    'Parent',h1,...
    'Units','normalized',...
    'Title','Map settings',...
    'Tag','uipanelMapType',...
    'Clipping','on',...
    'Position',[0.01 0.67 0.17 0.33],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuipanelBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuSession';

h47 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuSession_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.8 0.4 0.08],...
    'String','------------',...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuSession_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuSession');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'popupmenuSessionComp';

h470 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuSessionComp_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.55 0.8 0.4 0.08],...
    'String','------------',...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuSessionComp_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuSessionComp');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'checkboxSessionCompOn';

h1005 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxSessionCompOn_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.55 0.9 0.4 0.08],...
    'String','greater than',...
    'Style','checkbox',...
    'Tag','checkboxSessionCompOn',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'checkboxGroupComparisonType';

h1005x = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxGroupComparisonType_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.55 0.675 0.4 0.08],...
    'String','non-param. z',...
    'Style','checkbox',...
    'Value',1,...
    'Enable','off',...
    'Tag','checkboxGroupComparisonType',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'text21';

appdata = [];
appdata.lastValidTag = 'text18';

h48 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Position',[0.08 0.89 0.364864864864865 0.09],...
    'String','Session',...
    'Style','text',...
    'HorizontalAlignment','left',...
    'Tag','text18',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'checkboxTimeWindow';

h50 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxTimeWindow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0472972972972973 0.8 0.936486486486487 0.2],...
    'String','Show temporal maps',...
    'Style','checkbox',...
    'Tag','checkboxTimeWindow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'radionButtonPhaseSynch';

h2000 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radionButtonPhaseSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0472972972972973 0.72 0.936486486486487 0.13],...
    'String','Phase synchronization',...
    'Style','radiobutton',...
    'Tag','radionButtonPhaseSynch',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'radionButtonSynch';

h2001 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radionButtonSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0472972972972973 0.61 0.936486486486487 0.13],...
    'String','Time window ISC',...
    'Style','radiobutton',...
    'Tag','radionButtonSynch',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'textROI';

h2002 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Position',[0.0472972972972973 0.5 0.936486486486487 0.1],...
    'String','ROI analysis',...
    'Style','text',...
    'horizontalAlignment','left',...
    'Tag','textROI',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonPlotSynch';

h2003 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonPlotSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'CData',[],...
    'Position',[0.0440540540540541 0.37 0.3 0.14],...
    'String','Plot',...
    'Tag','pushbuttonPlotSynch',...
    'UserData',[],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonExportSynch';

h2004 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonExportSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'CData',[],...
    'Position',[0.36 0.37 0.3 0.14],...
    'String','Excel sheet',...
    'Tag','pushbuttonExportSynch',...
    'UserData',[],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonAnalysisSynch';

h2007 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAnalysisSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'CData',[],...
    'Position',[0.68 0.37 0.3 0.14],...
    'String','Analyze',...
    'Tag','pushbuttonAnalysisSynch',...
    'Visible','off',...
    'UserData',[],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'radionButtonSynchMean';

h2005 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radionButtonSynchMean_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0473 0.23 0.28 0.13],...
    'String','Mean',...
    'Style','radiobutton',...
    'Tag','radionButtonSynchMean',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'radionButtonSynchMedian';

h2006 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radionButtonSynchMedian_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.36 0.23 0.28 0.13],...
    'String','Median',...
    'Style','radiobutton',...
    'Tag','radionButtonSynchMedian',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'radionButtonSynchThres';

h2007 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''radionButtonSynchThres_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.7 0.23 0.28 0.13],...
    'String','Voxels',...
    'Style','radiobutton',...
    'Tag','radionButtonSynchThres',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'checkboxNormalSynch';

h2008 = uicontrol(...
    'Parent',h45,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxNormalSynch_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0472972972972973 0.1 0.4 0.13],...
    'String','Normalize',...
    'Style','checkbox',...
    'Tag','checkboxNormalSynch',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

% appdata = [];
% appdata.lastValidTag = 'pushbuttonAnalysisSynch';
%
% h51 = uicontrol(...
% 'Parent',h45,...
% 'Units','normalized',...
% 'Callback','fMRI_GUI_export(''pushbuttonAnalysisSynch_Callback'',gcbo,[],guidata(gcbo))',...
% 'CData',[],...
% 'Position',[0.0440540540540541 0.03 0.91513513513514 0.18],...
% 'String','Spatio-temporal analysis',...
% 'TooltipString','Launch temporal analysis tool',...
% 'Tag','pushbuttonAnalysisSynch',...
% 'UserData',[],...
% 'Behavior',get(0,'defaultuicontrolBehavior'),...
% 'CreateFcn', {@local_CreateFcn, '', appdata} );

% appdata = [];
% appdata.lastValidTag = 'uipanelButtons';

% h52 = uipanel(...
% 'Parent',h1,...
% 'Title','',...
% 'Tag','uipanelButtons',...
% 'Behavior',get(0,'defaultuipanelBehavior'),...
% 'Clipping','on',...
% 'Position',[0.867479674796748 0.80231292517007 0.116260162601626 0.11360544217687],...
% 'Visible','off',...
% 'CreateFcn', {@local_CreateFcn, '', appdata} );
%
%appdata = [];
%appdata.lastValidTag = 'pushbuttonInspectRegion';

% h53 = uicontrol(...
% 'Parent',h52,...
% 'Units','normalized',...
% 'Callback','fMRI_GUI_export(''pushbuttonInspectRegion_Callback'',gcbo,[],guidata(gcbo))',...
% 'Position',[0.0935251798561151 0.410958904109589 0.784172661870504 0.26027397260274],...
% 'String','Inspect Region',...
% 'Tag','pushbuttonInspectRegion',...
% 'Behavior',get(0,'defaultuicontrolBehavior'),...
% 'CreateFcn', {@local_CreateFcn, '', appdata} );

appdata = [];
appdata.lastValidTag = 'pushbuttonNewFigure';

h54 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonNewFigure_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.92 0.94 0.072 0.03],...
    'String','Plot image series',...
    'Tag','pushbuttonNewFigure',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'uipanelAxes';

h55 = uipanel(...
    'Parent',h1,...
    'Title','',...
    'Tag','uipanelAxes',...
    'Clipping','on','Visible','on',...
    'Position',[0.154471544715447 0.145578231292517 0.780487804878049 0.487074829931973],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuipanelBehavior'),...
appdata = [];
appdata.lastValidTag = 'axesSagittal';

%  'Position',[0.0135983263598326 0.154494382022472 0.309623430962343
%  0.808988764044944],...
h56 = axes(...
    'Parent',h55,...
    'Position',[0.0135983263598326 0.154494382022472 0.309623430962343 0.808988764044944],...
    'CameraPosition',[0.5 0.5 9.16025403784439],...
    'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
    'Color',get(0,'defaultaxesColor'),...
    'ColorOrder',get(0,'defaultaxesColorOrder'),...
    'LooseInset',[0.488990825688074 0.434677419354839 0.357339449541285 0.296370967741936],...
    'XColor',get(0,'defaultaxesXColor'),...
    'YColor',get(0,'defaultaxesYColor'),...
    'ZColor',get(0,'defaultaxesZColor'),...
    'Tag','axesSagittal',...
    'UserData',[],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultaxesBehavior'),...
h57 = get(h56,'title');

set(h57,...
    'Parent',h56,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498310810810811 1.02256944444444 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h58 = get(h56,'xlabel');

set(h58,...
    'Parent',h56,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.498310810810811 -0.0815972222222225 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','cap',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h59 = get(h56,'ylabel');

set(h59,...
    'Parent',h56,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.0962837837837839 0.494791666666667 1.00005459937205],...
    'Rotation',90,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h60 = get(h56,'zlabel');

set(h60,...
    'Parent',h56,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','right',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.694256756756757 1.97743055555556 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','middle',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','off',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.lastValidTag = 'axesCoronal';

h61 = axes(...
    'Parent',h55,...
    'Position',[0.341004184100418 0.154494382022472 0.31694560669456 0.811797752808989],...
    'CameraPosition',[0.5 0.5 9.16025403784439],...
    'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
    'Color',get(0,'defaultaxesColor'),...
    'ColorOrder',get(0,'defaultaxesColorOrder'),...
    'LooseInset',[0.488990825688074 0.434677419354839 0.357339449541284 0.296370967741936],...
    'XColor',get(0,'defaultaxesXColor'),...
    'YColor',get(0,'defaultaxesYColor'),...
    'ZColor',get(0,'defaultaxesZColor'),...
    'Tag','axesCoronal',...
    'Behavior',get(0,'defaultaxesBehavior'),...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

h62 = get(h61,'title');

set(h62,...
    'Parent',h61,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.5 1.02249134948097 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h63 = get(h61,'xlabel');

set(h63,...
    'Parent',h61,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.496699669966997 -0.0813148788927334 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','cap',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h64 = get(h61,'ylabel');

set(h64,...
    'Parent',h61,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.0940594059405944 0.496539792387543 1.00005459937205],...
    'Rotation',90,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h65 = get(h61,'zlabel');

set(h65,...
    'Parent',h61,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','right',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-1.71122112211221 1.97058823529412 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','middle',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','off',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.lastValidTag = 'axesAxial';

% 'Position',[0.673640167364016 0.160112359550562 0.312761506276151
% 0.811797752808989],...
%'LooseInset',[0.488990825688073 0.434677419354839 0.357339449541284 0.296370967741936],...
h66 = axes(...
    'Parent',h55,...
    'Position',[0.673640167364016 0.16011235955 0.31276 0.81179],...
    'CameraPosition',[0.5 0.5 9.16025403784439],...
    'CameraPositionMode',get(0,'defaultaxesCameraPositionMode'),...
    'Color',get(0,'defaultaxesColor'),...
    'ColorOrder',get(0,'defaultaxesColorOrder'),...
    'XColor',get(0,'defaultaxesXColor'),...
    'YColor',get(0,'defaultaxesYColor'),...
    'ZColor',get(0,'defaultaxesZColor'),...
    'Tag','axesAxial',...
    'Behavior',get(0,'defaultaxesBehavior'),...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

h67 = get(h66,'title');

set(h67,...
    'Parent',h66,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.5 1.02249134948097 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h68 = get(h66,'xlabel');

set(h68,...
    'Parent',h66,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[0.496655518394649 -0.0813148788927334 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','cap',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h69 = get(h66,'ylabel');

set(h69,...
    'Parent',h66,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','center',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-0.0953177257525084 0.496539792387544 1.00005459937205],...
    'Rotation',90,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','bottom',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','on',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

h70 = get(h66,'zlabel');

set(h70,...
    'Parent',h66,...
    'Units','data',...
    'FontUnits','points',...
    'BackgroundColor','none',...
    'Color',[0 0 0],...
    'EdgeColor','none',...
    'DVIMode','auto',...
    'FontAngle','normal',...
    'FontName','Helvetica',...
    'FontSize',10,...
    'FontWeight','normal',...
    'HorizontalAlignment','right',...
    'LineStyle','-',...
    'LineWidth',0.5,...
    'Margin',2,...
    'Position',[-2.79765886287625 1.9636678200692 1.00005459937205],...
    'Rotation',0,...
    'String','',...
    'Interpreter','tex',...
    'VerticalAlignment','middle',...
    'ButtonDownFcn',[],...
    'CreateFcn', {@local_CreateFcn, [], ''} ,...
    'DeleteFcn',[],...
    'BusyAction','queue',...
    'HandleVisibility','off',...
    'HelpTopicKey','',...
    'HitTest','on',...
    'Interruptible','on',...
    'SelectionHighlight','on',...
    'Serializable','on',...
    'Tag','',...
    'UserData',[],...
    'Behavior',struct(),...
    'Visible','off',...
    'XLimInclude','on',...
    'YLimInclude','on',...
    'ZLimInclude','on',...
    'CLimInclude','on',...
    'ALimInclude','on',...
    'Clipping','off');

appdata = [];
appdata.lastValidTag = 'sliderSagittal';

h71 = uicontrol(...
    'Parent',h55,...
    'Units','normalized',...
    'BackgroundColor',[0.9 0.9 0.9],...
    'Callback','fMRI_GUI_export(''sliderSagittal_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.0146443514644351 0.0758426966292135 0.311715481171548 0.0365168539325843],...
    'String',{  'Slider' },...
    'Style','slider',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''sliderSagittal_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','sliderSagittal');%,...
%'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'sliderCoronal';

h72 = uicontrol(...
    'Parent',h55,...
    'Units','normalized',...
    'BackgroundColor',[0.9 0.9 0.9],...
    'Callback','fMRI_GUI_export(''sliderCoronal_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.342050209205021 0.0758426966292135 0.317991631799163 0.0365168539325843],...
    'String',{  'Slider' },...
    'Style','slider',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''sliderCoronal_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','sliderCoronal');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'sliderAxial';

h73 = uicontrol(...
    'Parent',h55,...
    'Units','normalized',...
    'BackgroundColor',[0.9 0.9 0.9],...
    'Callback','fMRI_GUI_export(''sliderAxial_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.674686192468619 0.0786516853932584 0.311715481171548 0.0365168539325843],...
    'String',{  'Slider' },...
    'Style','slider',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''sliderAxial_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','sliderAxial');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));


appdata = [];
appdata.lastValidTag = 'pushbuttonAxialLeftSlow';

h301 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAxialLeftSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.77 0.18 0.02 0.03],...
    'String','<',...
    'Tag','pushbuttonAxialLeftSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonAxialLeftFast';

h302 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAxialLeftFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.74 0.18 0.02 0.03],...
    'String','<<',...
    'Tag','pushbuttonAxialLeftFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonAxialRightSlow';

h303 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAxialRightSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.80 0.18 0.02 0.03],...
    'String','>',...
    'Tag','pushbuttonAxialRightSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonAxialRightFast';

h304 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonAxialRightFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.83 0.18 0.02 0.03],...
    'String','>>',...
    'Tag','pushbuttonAxialRightFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonSagittalLeftSlow';

h305 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonSagittalLeftSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.77-0.25-0.25 0.18 0.02 0.03],...
    'String','<',...
    'Tag','pushbuttonSagittalLeftSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonSagittalLeftFast';

h306 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonSagittalLeftFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.74-0.25-0.25 0.18 0.02 0.03],...
    'String','<<',...
    'Tag','pushbuttonSagittalLeftFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonSagittalRightSlow';

h307 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonSagittalRightSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.80-0.25-0.25 0.18 0.02 0.03],...
    'String','>',...
    'Tag','pushbuttonSagittalRightSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonSagittalRightFast';

h308 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonSagittalRightFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.83-0.25-0.25 0.18 0.02 0.03],...
    'String','>>',...
    'Tag','pushbuttonSagittalRightFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...
appdata = [];
appdata.lastValidTag = 'pushbuttonSagittalLeftSlow';

h309 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonCoronalLeftSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.77-0.25 0.18 0.02 0.03],...
    'String','<',...
    'Tag','pushbuttonCoronalLeftSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonCoronalLeftFast';

h310 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonCoronalLeftFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.74-0.25 0.18 0.02 0.03],...
    'String','<<',...
    'Tag','pushbuttonCoronalLeftFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonCoronalRightSlow';

h311 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonCoronalRightSlow_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.80-0.25 0.18 0.02 0.03],...
    'String','>',...
    'Tag','pushbuttonCoronalRightSlow',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'pushbuttonCoronalRightFast';

h312 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonCoronalRightFast_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.83-0.25 0.18 0.02 0.03],...
    'String','>>',...
    'Tag','pushbuttonCoronalRightFast',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...



appdata = [];
appdata.lastValidTag = 'textSagittalMatlab';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h76 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.043 0.08 0.03],...
    'String',{  'Static Text' },...
    'Visible','on',...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textSagittalMatlab',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textCoronalMatlab';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h76 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.023 0.12 0.03],...
    'String',{  'Static Text' },...
    'Visible','on',...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textCoronalMatlab',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );

%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'textSagittal';

h74 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.15 0.14 0.03],...
    'String','MNI','HorizontalAlignment','left',...
    'Style','text',...
    'Tag','textSagittal',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'textCoronal';

%    'Position',[0.342050209205021 0.0337078651685393 0.0564853556485355
%    0.0337078651685393],...

h75 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.12 0.15 0.03],...
    'String',{  'Static Text' },'HorizontalAlignment','left',...
    'Style','text',...
    'Tag','textCoronal',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );


appdata = [];
appdata.lastValidTag = 'textAxial';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h76 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.09 0.15 0.03],...
    'String',{  'Static Text' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textAxial',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...





appdata = [];
appdata.lastValidTag = 'textMNIsagittalMinus';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.25-0.25-0.05 0.18 0.045 0.03],...
    'String',{ 'neg (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIsagittalMinus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIcoronalMinus';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.25-0.05 0.18 0.045 0.03],...
    'String',{ 'neg (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIcoronalMinus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIaxialMinus';

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.05 0.18 0.045 0.03],...
    'String',{ 'neg (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIaxialMinus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIaxialLeft';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.035 0.25 0.015 0.03],...
    'String',{ 'L' },...
    'FontSize',10,...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIaxialLeft',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIaxialRight';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74+0.15 0.25 0.015 0.03],...
    'String',{ 'R' },...
    'FontSize',10,...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIaxialRight',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'textMNIcoronalLeft';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.25-0.06 0.25 0.015 0.03],...
    'String',{ 'L' },...
    'FontSize',10,...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIcoronalLeft',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIcoronalRight';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.09 0.25 0.015 0.03],...
    'String',{ 'R' },...
    'FontSize',10,...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIcoronalRight',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'textMNIsagittalPlus';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.25-0.25-0.05+0.17 0.18 0.045 0.03],...
    'String',{ 'pos (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIsagittalPlus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIcoronalPlus';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.25-0.05+0.17 0.18 0.045 0.03],...
    'String',{ 'pos (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIcoronalPlus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'textMNIaxialPlus';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

% XXXX
h1X = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.74-0.05+0.17 0.18 0.045 0.03],...
    'String',{ 'pos (MNI)' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textMNIaxialPlus',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'textAxialMatlab';
%'Position',[0.673640167364016 0.0365168539325843 0.3 0.0337078651685393],...

h76 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Position',[0.02 0.003 0.12 0.03],...
    'String',{  'Static Text' },...
    'Style','text','HorizontalAlignment','left',...
    'Tag','textAxialMatlab',...
    'Visible','on',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'checkboxPixVal1';

h77 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxPixVal1_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.283739837398374 0.0258503401360544 0.0926829268292683 0.0204081632653061],...
    'String','Show Pixel Values',...
    'Style','checkbox',...
    'Tag','checkboxPixVal1',...
    'Visible','off',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...




hsingleton = h1;

%%%%LATEST ADDITIONS:

h200 = uicontrol('Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxSwapBytes_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.92 0.02 0.08 0.03],...
    'String','Swap bytes',...
    'Style','checkbox',...
    'Tag','checkboxSwapBytes',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% LATEST ADDITIONS

appdata = [];
appdata.lastValidTag = 'uipanelFrequencySettings';

%h1002 = uipanel(...
%    'Parent',h1,...
%    'Units','characters',...
%    'Title','Frequency settings',...
%    'Tag','uipanelFrequencySettings',...
%    'Behavior',get(0,'defaultuipanelBehavior'),...
%    'Clipping','on',...
%    'Position',[37 44 50.2 10.1],...
%    'CreateFcn', {@local_CreateFcn, '', appdata} );

h1002 = uipanel(...
    'Parent',h1,...
    'Units','normalized',...
    'Title','Frequency settings',...
    'Tag','uipanelFrequencySettings',...
    'Clipping','on',...
    'Position',[0.19 0.75 0.22 0.25],...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuipanelBehavior'),...


appdata = [];
appdata.lastValidTag = 'popupmenuFreqBand';

h1003 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Callback','fMRI_GUI_export(''popupmenuFreqBand_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[3.4 5.5 19.8 1.69230769230769],...
    'String',{  'Pop-up Menu' },...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuFreqBand_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuFreqBand');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'popupmenuFreqBandComp';

h1004 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Callback','fMRI_GUI_export(''popupmenuFreqBandComp_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[25.4 5.5 19.8 1.69230769230769],...
    'String',{  'Pop-up Menu' },...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuFreqBandComp_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuFreqBandComp');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'checkboxAllFrequencies';

h1021 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Callback','fMRI_GUI_export(''checkboxAllFrequencies_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[3.4 1.7 19.8 1.69230769230769],...
    'String','Show all bands',...
    'Style','checkbox','Value',0,...
    'Tag','checkboxAllFrequencies',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'radiobuttonFreqCompOn';

h1005 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Callback','fMRI_GUI_export(''radiobuttonFreqCompOn_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[25.4 7.2 22.4 1.30769230769231],...
    'String','greater than',...
    'Style','checkbox',...
    'Tag','radiobuttonFreqCompOn',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuZPF';

h1006 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Callback','fMRI_GUI_export(''popupmenuZPF_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[25.4 1.538461 19.8 1.69230769230769],... %    'String',{  'pairwise ZPF'; 'sum ZPF' },...
    'String',{  'sum ZPF' },...
    'Style','popupmenu',...
    'Visible','off',...
    'Value',1,'Enable','off',...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuZPF_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuZPF');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'text4';

h1008 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Position',[1.4 7.2 17.2 1.15384615384615],...
    'String','current band',...
    'Style','text',...
    'Tag','text4',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'text8';

h1010 = uicontrol(...
    'Parent',h1002,...
    'Units','characters',...
    'Position',[24.2 3.38461538461539 10.6 1.15384615384615],...
    'String','statistic',...
    'Style','text',...
    'Visible','off',...
    'Tag','text8',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuMapType';

h1012 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''popupmenuMapType_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.24 0.700854700854701 0.130434782608696],...
    'String',{  'mean'; 't-stats'; 'standard deviation'; 'lower quartile'; 'median'; 'upper quartile';  },...
    'Style','popupmenu','Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuMapType_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuMapType');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'text1';

h1013 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Position',[0.08 0.37 0.70 0.08],...
    'String','ISC map type',...
    'Style','text',...
    'HorizontalAlignment','left',...
    'Tag','text1',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'popupmenuSign';

h10120 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''popupmenuSign_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.02 0.700 0.1304],...
    'String',{  'positive'; 'negative'; 'both' },...
    'Style','popupmenu','Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuSign_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuSign');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'text1';

h10130 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Position',[0.08 0.15 0.700854700854701 0.1],...
    'String','Sign',...
    'Style','text',...
    'HorizontalAlignment','left',...
    'Tag','text1',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'popupmenuAlphaMap';

h1014 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuAlphaMap_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.03 0.700854700854701 0.1],...
    'String',{ '0.05'; '0.01';'0.001' },...
    'Style','popupmenu',...
    'Value',3,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuAlphaMap_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuAlphaMap');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textAlphaLevel';

h1015 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Position',[0.08 0.15 0.700854700854701 0.05],...
    'String','alpha level',...
    'HorizontalAlignment','left',...
    'Style','text',...
    'Tag','textAlphaLevel',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuCorrectionMap';
correctionMethods = {  'none'; 'FDR (indep/dep)'; 'FDR (no assump.)'; 'bonferroni' };
h1016 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuCorrectionMap_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.2 0.700854700854701 0.130434782608696],...
    'String',correctionMethods,...
    'Style','popupmenu',...
    'Value',2,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuCorrectionMap_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuCorrectionMap');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'textCorrectionMethod';

h1017 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Position',[0.08 0.35 0.700854700854701 0.05],...
    'String','correction method',...
    'Style','text',...
    'Tag','textCorrectionMethod',...
    'HorizontalAlignment','left',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...

appdata = [];
appdata.lastValidTag = 'popupmenuSimilarityMeasure';

h1018 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'BackgroundColor',[1 1 1],...
    'Callback','fMRI_GUI_export(''popupmenuSimilarityMeasure_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.5 0.8 0.1],...
    'String',{  'Pop-up Menu' },...
    'Style','popupmenu',...
    'Value',1,...
    'CreateFcn', {@local_CreateFcn, 'fMRI_GUI_export(''popupmenuSimilarityMeasure_CreateFcn'',gcbo,[],guidata(gcbo))', appdata} ,...
    'Tag','popupmenuSimilarityMeasure');%,...
%    'Behavior',get(0,'defaultuicontrolBehavior'));

appdata = [];
appdata.lastValidTag = 'text7';

h1019 = uicontrol(...
    'Parent',h1011,...
    'Units','normalized',...
    'Position',[0.08 0.6 0.47 0.08],...
    'String','Similarity measure',...
    'HorizontalAlignment','left',...
    'Style','text',...
    'Tag','text7',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'checkboxTh';

h1020 = uicontrol(...
    'Parent',h36,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''checkboxTh_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.08 0.85 0.8 0.144230769230769],...
    'String','Use thresholds',...
    'Style','checkbox',...
    'Tag','checkboxTh',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...


appdata = [];
appdata.lastValidTag = 'pushbuttonResetGUI';

h1040 = uicontrol(...
    'Parent',h1,...
    'Units','normalized',...
    'Callback','fMRI_GUI_export(''pushbuttonResetGUI_Callback'',gcbo,[],guidata(gcbo))',...
    'Position',[0.92 0.06 0.06 0.03],'Visible','on',...
    'String','Reset',...
    'Tag','pushbuttonResetGUI',...
    'CreateFcn', {@local_CreateFcn, '', appdata} );
%    'Behavior',get(0,'defaultuicontrolBehavior'),...






% --- Executes on selection change in popupmenuFreqBandComp.
function popupmenuFreqBandComp_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBandComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuFreqBandComp contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuFreqBandComp

handles.freqBand2 = get(hObject,'Value');
if handles.freqBand <= handles.freqBand2
    handles.freqComp = handles.freqBandCompTable(handles.freqBand,handles.freqBand2);
else
    handles.freqComp = handles.freqBandCompTable(handles.freqBand2,handles.freqBand);
end

handles.changeInCurrentAxes = 1;
%handles = update_params(handles);
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuFreqBandComp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuFreqBandComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in radiobuttonFreqCompOn.
function radiobuttonFreqCompOn_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonFreqCompOn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% frequency band comparison on/off (Pearson-Filon test):
handles.freqCompOn = get(hObject,'Value');

% Hint: get(hObject,'Value') returns toggle state of radiobuttonFreqCompOn
if get(hObject,'Value')
    
    set(handles.popupmenuSessionComp,'Enable','off')
    set(handles.checkboxSessionCompOn,'Value',0)
    handles.sessionCompOn = 0;
    
    set(handles.checkboxAllFrequencies,'Value',0)
    handles.allFreq = 0;
    
    if handles.freqBand <= handles.freqBand2
        handles.freqComp = handles.freqBandCompTable(handles.freqBand,handles.freqBand2);
    else
        handles.freqComp = handles.freqBandCompTable(handles.freqBand2,handles.freqBand);
    end
    
    
    set(handles.popupmenuFreqBandComp,'Enable','on')
    set(handles.radiobuttonAutomaticTh,'Visible','on')
    set(handles.popupmenuZPF,'Enable','on')
    set(handles.popupmenuMapType,'Enable','off')
    %set(handles.checkboxAllFrequencies,'Enable','off')
    set(handles.popupmenuAlphaMap,'Enable','on')
    set(handles.popupmenuSimilarityMeasure,'Enable','off')
    handles.ZPFtest = get(handles.popupmenuZPF,'Value');
    set(handles.popupmenuCorrectionMap,'Enable','off')
    if handles.ZPFtest == 1
        set(handles.popupmenuCorrectionMap,'Value',1,'String',handles.correctionMethods{2})
    else
        set(handles.popupmenuCorrectionMap,'Value',1,'String',handles.correctionMethods{3})
    end
    %    set(handles.popupmenuAlphaMap,'Enable','off')
    if handles.Pub.winOn == 1
        disp('Frequency comparison not valid for time window ISC --> setting off temporal view')
        handles = setTemporalSettings(handles,'off');
        set(handles.checkboxTimeWindow,'Value',0)
        handles.win = 0;
        
    end    
else
    %  set(gcf,'Colormap',handles.colMap);
    set(handles.checkboxAllFrequencies,'Enable','on')
    if handles.Pub.winOn || handles.Pub.calcPhase
        set(handles.checkboxTimeWindow,'Enable','on')
    end
    set(handles.popupmenuFreqBandComp,'Enable','off')
    set(handles.popupmenuZPF,'Enable','off')
    set(handles.popupmenuCorrectionMap,'Value',1,'String',handles.correctionMethods{1})
    set(handles.popupmenuCorrectionMap,'Value',handles.correction)
    %   set(handles.popupmenuAlphaZPF,'Enable','off')
    if handles.Pub.calcStats
        set(handles.popupmenuMapType,'Enable','on')
    else
        set(handles.popupmenuMapType,'Enable','off')
    end
    set(handles.popupmenuSimilarityMeasure,'Enable','on')
    if handles.mapType <= 2
        set(handles.popupmenuCorrectionMap,'Enable','on')
        set(handles.popupmenuAlphaMap,'Enable','on')
    else
        set(handles.popupmenuCorrectionMap,'Enable','off')
        set(handles.popupmenuAlphaMap,'Enable','off')
        handles = setThresholdView(handles);
    end
    
end

%if isnan(handles.freqComp)
%    guidata(hObject, handles);
%else
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);
%end


% --- Executes on button press in radiobuttonFreqCompOn.
function checkboxGroupComparisonType_Callback(hObject, eventdata, handles)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% session comparison on/off:
handles.groupComparisonType = get(hObject,'Value');
%handles.alpha = 1;
if handles.correction > 2
    handles.correction = 2; % set default correction method to FDR (indep/dep)    
end

if get(hObject,'Value') % group comparison type set to "non-parametric z"
    % set default alpha-level and correction type for group/session contrasts:
    set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{5})
else    
    if handles.Pub.clusterThreshold > 0 % cluster based thresholding computed
        set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{4})
    else % voxel-based thresholding computed only
        set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{3})
    end
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes on button press in radiobuttonFreqCompOn.
function checkboxSessionCompOn_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonFreqCompOn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% session comparison on/off:
handles.sessionCompOn = get(hObject,'Value');

if get(hObject,'Value') % session comparison maps selected
    % set default alpha-level and correction type for group/session contrasts:
    handles.alpha = 1;
    
    set(handles.popupmenuAlphaMap,'String',[{'0.05','0.025','0.01','0.001'}],'Value',handles.alpha)
    set(handles.popupmenuFreqBandComp,'Enable','off')
    set(handles.radiobuttonFreqCompOn,'Value',0)
    handles.freqCompOn = 0;
    set(handles.checkboxAllFrequencies,'Value',0)
    handles.allFreq = 0;
    set(handles.popupmenuFreqBandComp,'Enable','off')
    
    if handles.dataset <= handles.dataset2
        handles.sessionComp = handles.sessionCompTable(handles.dataset,handles.dataset2);
    else
        handles.sessionComp = handles.sessionCompTable(handles.dataset2,handles.dataset);
    end
    
    set(handles.popupmenuSessionComp,'Enable','on')
    set(handles.radiobuttonAutomaticTh,'Visible','on')
    set(handles.popupmenuMapType,'Enable','off')
    set(handles.popupmenuAlphaMap,'Enable','on')
    set(handles.popupmenuSimilarityMeasure,'Enable','off')
    
    if handles.Pub.pairedSessionComp % session contrast map
        handles.correction = 1; % set default correction method to FWE
        set(handles.popupmenuCorrectionMap,'Enable','off')
        set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{2})
        
        set(handles.checkboxGroupComparisonType,'Enable','off')
    else % group contrast map selected
        handles.alpha = 1;
        handles.correction = 2; % set default correction method to FDR (indep/dep)
        set(handles.checkboxGroupComparisonType,'Enable','on')
        
        if handles.groupComparisonType == 1 % non-parametric z correction type selected
            set(handles.popupmenuCorrectionMap,'Enable','on')
            set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{5})
        else
            
            if handles.Pub.clusterThreshold > 0 % cluster based thresholding computed
                set(handles.popupmenuCorrectionMap,'Enable','on')
                set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{4})
            else % voxel-based thresholding computed only
                set(handles.popupmenuCorrectionMap,'Enable','on')
                set(handles.popupmenuCorrectionMap,'Value',handles.correction,'String',handles.correctionMethods{3})
            end
            
        end
        
    end
    %    set(handles.popupmenuAlphaMap,'Enable','off')
    if handles.Pub.winOn || handles.Pub.calcPhase
        disp('Session comparison not valid for temporal ISC --> setting off temporal view')
        handles = setTemporalSettings(handles,'off');
        set(handles.checkboxTimeWindow,'Value',0)
        handles.win = 0;
    end
else
    % set default alpha-level and correction type for basic ISC maps:
    handles.alpha = 3;
    handles.correction = 2;
    set(handles.popupmenuAlphaMap,'String',[{'0.05','0.01','0.001'}],'Value',handles.alpha)
    if handles.Pub.winOn || handles.Pub.calcPhase
        set(handles.checkboxTimeWindow,'Enable','on')
    end
    set(handles.popupmenuSessionComp,'Enable','off')
    set(handles.popupmenuCorrectionMap,'Value',1,'String',handles.correctionMethods{1})
    set(handles.popupmenuCorrectionMap,'Value',handles.correction)
    set(handles.checkboxGroupComparisonType,'Enable','off')
    %   set(handles.popupmenuAlphaZPF,'Enable','off')
    if handles.Pub.calcStats
        set(handles.popupmenuMapType,'Enable','on')
    else
        set(handles.popupmenuMapType,'Enable','off')
    end
    set(handles.popupmenuSimilarityMeasure,'Enable','on')
    if handles.mapType <= 2
        set(handles.popupmenuCorrectionMap,'Enable','on')
        set(handles.popupmenuAlphaMap,'Enable','on')
    else
        set(handles.popupmenuCorrectionMap,'Enable','off')
        set(handles.popupmenuAlphaMap,'Enable','off')
        handles = setThresholdView(handles);
    end
end

%if isnan(handles.sessionComp)
%    guidata(hObject, handles);
%else
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);
%end

% --- Executes on selection change in popupmenuMapType.
function popupmenuMapType_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuMapType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.mapType = get(hObject,'Value');
handles = setThresholdView(handles);

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuMapType_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuMapType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in popupmenuMapType.
function popupmenuSign_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuMapType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Val = get(hObject,'Value');
switch Val
    case 1
        handles.direction = 1; % pos
    case 2
        handles.direction = -1; % neg
    case 3
        handles.direction = 0; % both
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuSign_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuMapType (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuAlphaMap.
function popupmenuAlphaMap_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuAlphaMap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuAlphaMap contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuAlphaMap
handles.alpha = get(hObject,'Value');

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuAlphaMap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuAlphaMap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenuCorrectionMap.
function popupmenuCorrectionMap_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuCorrectionMap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.correction = get(hObject,'Value');

if handles.Pub.clusterThreshold > 0 && handles.correction == 2 
%    set(handles.)
end

handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function popupmenuCorrectionMap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuCorrectionMap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in popupmenuZPF.
function popupmenuZPF_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenuZPF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenuZPF contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenuZPF
handles.ZPFtest = get(hObject,'Value');
if handles.ZPFtest == 1
    set(handles.popupmenuCorrectionMap,'String',handles.correctionMethods{2})
else
    set(handles.popupmenuCorrectionMap,'String',handles.correctionMethods{3})
end
handles = updateThreshold(handles);
%handles.ScaleMax1 = 2*handles.Threshold;
handles.changeInCurrentAxes = 1;
handles = update_figs(handles);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function popupmenuZPF_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenuZPF (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Set application data first then calling the CreateFcn.
function local_CreateFcn(hObject, eventdata, createfcn, appdata)

if ~isempty(appdata)
    names = fieldnames(appdata);
    for i=1:length(names)
        name = char(names(i));
        setappdata(hObject, name, getfield(appdata,name));
    end
end

if ~isempty(createfcn)
    eval(createfcn);
end


% --- Handles default GUIDE GUI creation and callback dispatch
function varargout = gui_mainfcn(gui_State, varargin)


%   GUI_MAINFCN provides these command line APIs for dealing with GUIs
%
%      FMRI_GUI_EXPORT, by itself, creates a new FMRI_GUI_EXPORT or raises the existing
%      singleton*.
%
%      H = FMRI_GUI_EXPORT returns the handle to a new FMRI_GUI_EXPORT or the handle to
%      the existing singleton*.
%
%      FMRI_GUI_EXPORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FMRI_GUI_EXPORT.M with the given input arguments.
%
%      FMRI_GUI_EXPORT('Property','Value',...) creates a new FMRI_GUI_EXPORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before untitled_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to untitled_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".

%   Copyright 1984-2004 The MathWorks, Inc.
%   $Revision: 1.4.6.10.2.1 $ $Date: 2005/01/14 21:54:21 $

gui_StateFields =  {'gui_Name'
    'gui_Singleton'
    'gui_OpeningFcn'
    'gui_OutputFcn'
    'gui_LayoutFcn'
    'gui_Callback'};
gui_Mfile = '';
for i=1:length(gui_StateFields)
    if ~isfield(gui_State, gui_StateFields{i})
        error('Could not find field %s in the gui_State struct in GUI M-file %s', gui_StateFields{i}, gui_Mfile);
    elseif isequal(gui_StateFields{i}, 'gui_Name')
        gui_Mfile = [gui_State.(gui_StateFields{i}), '.m'];
    end
end

numargin = length(varargin);

if numargin == 0
    % FMRI_GUI_EXPORT
    % create the GUI
    gui_Create = 1;
elseif isequal(ishandle(varargin{1}), 1) && ispc && iscom(varargin{1}) && isequal(varargin{1},gcbo)
    % FMRI_GUI_EXPORT(ACTIVEX,...)
    vin{1} = gui_State.gui_Name;
    vin{2} = [get(varargin{1}.Peer, 'Tag'), '_', varargin{end}];
    vin{3} = varargin{1};
    vin{4} = varargin{end-1};
    vin{5} = guidata(varargin{1}.Peer);
    feval(vin{:});
    return;
elseif ischar(varargin{1}) && numargin>1 && isequal(ishandle(varargin{2}), 1)
    % FMRI_GUI_EXPORT('CALLBACK',hObject,eventData,handles,...)
    gui_Create = 0;
else
    % FMRI_GUI_EXPORT(...)
    % create the GUI and hand varargin to the openingfcn
    gui_Create = 1;
end

if gui_Create == 0
    varargin{1} = gui_State.gui_Callback;
    if nargout
        [varargout{1:nargout}] = feval(varargin{:});
    else
        feval(varargin{:});
    end
else
    if gui_State.gui_Singleton
        gui_SingletonOpt = 'reuse';
    else
        gui_SingletonOpt = 'new';
    end
    
    % Open fig file with stored settings.  Note: This executes all component
    % specific CreateFunctions with an empty HANDLES structure.
    
    % Do feval on layout code in m-file if it exists
    if ~isempty(gui_State.gui_LayoutFcn)
        gui_hFigure = feval(gui_State.gui_LayoutFcn, gui_SingletonOpt);
        % openfig (called by local_openfig below) does this for guis without
        % the LayoutFcn. Be sure to do it here so guis show up on screen.
        movegui(gui_hFigure,'onscreen')
    else
        gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);
        % If the figure has InGUIInitialization it was not completely created
        % on the last pass.  Delete this handle and try again.
        if isappdata(gui_hFigure, 'InGUIInitialization')
            delete(gui_hFigure);
            gui_hFigure = local_openfig(gui_State.gui_Name, gui_SingletonOpt);
        end
    end
    
    % Set flag to indicate starting GUI initialization
    setappdata(gui_hFigure,'InGUIInitialization',1);
    
    % Fetch GUIDE Application options
    gui_Options = getappdata(gui_hFigure,'GUIDEOptions');
    
    if ~isappdata(gui_hFigure,'GUIOnScreen')
        % Adjust background color
        if gui_Options.syscolorfig
            set(gui_hFigure,'Color', get(0,'DefaultUicontrolBackgroundColor'));
        end
        
        % Generate HANDLES structure and store with GUIDATA. If there is
        % user set GUI data already, keep that also.
        data = guidata(gui_hFigure);
        handles = guihandles(gui_hFigure);
        if ~isempty(handles)
            if isempty(data)
                data = handles;
            else
                names = fieldnames(handles);
                for k=1:length(names)
                    data.(char(names(k)))=handles.(char(names(k)));
                end
            end
        end
        guidata(gui_hFigure, data);
    end
    
    % If user specified 'Visible','off' in p/v pairs, don't make the figure
    % visible.
    gui_MakeVisible = 1;
    for ind=1:2:length(varargin)
        if length(varargin) == ind
            break;
        end
        len1 = min(length('visible'),length(varargin{ind}));
        len2 = min(length('off'),length(varargin{ind+1}));
        if ischar(varargin{ind}) && ischar(varargin{ind+1}) && ...
                strncmpi(varargin{ind},'visible',len1) && len2 > 1
            if strncmpi(varargin{ind+1},'off',len2)
                gui_MakeVisible = 0;
            elseif strncmpi(varargin{ind+1},'on',len2)
                gui_MakeVisible = 1;
            end
        end
    end
    
    % Check for figure param value pairs
    for index=1:2:length(varargin)
        if length(varargin) == index || ~ischar(varargin{index})
            break;
        end
        try set(gui_hFigure, varargin{index}, varargin{index+1}), catch break, end
    end
    
    % If handle visibility is set to 'callback', turn it on until finished
    % with OpeningFcn
    gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
    if strcmp(gui_HandleVisibility, 'callback')
        set(gui_hFigure,'HandleVisibility', 'on');
    end
    
    feval(gui_State.gui_OpeningFcn, gui_hFigure, [], guidata(gui_hFigure), varargin{:});
    
    if ishandle(gui_hFigure)
        % Update handle visibility
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
        
        % Make figure visible
        if gui_MakeVisible
            set(gui_hFigure, 'Visible', 'on')
            if gui_Options.singleton
                setappdata(gui_hFigure,'GUIOnScreen', 1);
            end
        end
        
        % Done with GUI initialization
        rmappdata(gui_hFigure,'InGUIInitialization');
    end
    
    % If handle visibility is set to 'callback', turn it on until finished with
    % OutputFcn
    if ishandle(gui_hFigure)
        gui_HandleVisibility = get(gui_hFigure,'HandleVisibility');
        if strcmp(gui_HandleVisibility, 'callback')
            set(gui_hFigure,'HandleVisibility', 'on');
        end
        gui_Handles = guidata(gui_hFigure);
    else
        gui_Handles = [];
    end
    
    if nargout
        [varargout{1:nargout}] = feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    else
        feval(gui_State.gui_OutputFcn, gui_hFigure, [], gui_Handles);
    end
    
    if ishandle(gui_hFigure)
        set(gui_hFigure,'HandleVisibility', gui_HandleVisibility);
    end
end

function gui_hFigure = local_openfig(name, singleton)

% this application data is used to indicate the running mode of a GUIDE
% GUI to distinguish it from the design mode of the GUI in GUIDE.
setappdata(0,'OpenGuiWhenRunning',1);

% openfig with three arguments was new from R13. Try to call that first, if
% failed, try the old openfig.
try
    gui_hFigure = openfig(name, singleton, 'auto');
catch
    % OPENFIG did not accept 3rd input argument until R13,
    % toggle default figure visible to prevent the figure
    % from showing up too soon.
    gui_OldDefaultVisible = get(0,'defaultFigureVisible');
    set(0,'defaultFigureVisible','off');
    gui_hFigure = openfig(name, singleton);
    set(0,'defaultFigureVisible',gui_OldDefaultVisible);
end
rmappdata(0,'OpenGuiWhenRunning');

function pushbuttonResetGUI_Callback(hObject, eventdata, handles)

Params.PublicParams = handles.Pub;
Params.PrivateParams = handles.Priv;
if isfield(Params,'PublicParams')
    Pub = Params.PublicParams;
    if ( isfield(Pub,'dataDestination') && ...
            isfield(Pub,'dataDescription') )
        handles.paramFile = [Pub.dataDestination Pub.dataDescription '_params'];
        handles.ParamStructInput = Params;
        [handles,errFlag] = getParams(handles);
        if errFlag
            delete(handles.figure1)
            return
        end
        guidata(hObject, handles);
        handles = enablePanels(handles);
        %use the following command to clear workspace
        %memory pointers automatically:
        assignin('base','memMaps',[])
        guidata(hObject, handles);
    end
end