function densestPoint = findDensestPoints(clustInd,k,featureSet,brain_voxels,resultPath)

% This function finds spatial locations of the "densest" data points within each spatially disjoint cluster.
%
% Inputs:
%
% clustInds -- matrix of cell-arrays containing indices for each cluster
%
% k -- neighborhood size
%
% featureSet -- integer between 1-4:
% 1=return results computed based on the whole feature set (both mean and variance features)
% 2=return results computed based on the whole feature set, but variance features weighted
% 3=return results for mean ISC features only
% 4=return results for variance features only
%
% brain_voxels -- list of brain voxel indices.
%
% resutlPath -- pathname to a folder where k-NN graph was saved (see help clusterISC for more details)
%
% Outputs:
%
% densetPoint -- indices of the densest points for each subcluster.
%
% See also:
% CLUSTERISC, POSTPROCESSCLUSTERS
%
% Jukka-Pekka Kauppi
% University of Helsinki, Department of Computer Science
% 31.10.2014


disp(['Feature set = ' num2str(featureSet)])
disp(['Neighborhood size k = ' num2str(k)])

% load stored k-NN graph:

if k > 200 && k <= 300
   kk = 300;
elseif k > 300 && k <= 500
   kk = 500;
elseif k > 100 && k <= 200
   kk = 200;
elseif k < 100
    kk = 100;
else
   kk = k;
end

if strcmp(resultPath(end),'/') || strcmp(resultPath(end),'\')
   resultPath(end) = [];
end

fn = ([resultPath '/KNNG_k' num2str(kk) '_featureSet' num2str(featureSet) '.mat']);
if exist(fn) == 2
   load(fn,'KNN')
else
   error(['KNN graph not found in folder ' resultPath ' !!'])
end

clear densestPoint
for m = 1:size(clustInd,1)
    for n = 1:size(clustInd,2)
        if ~isempty(clustInd{m,n})
            [~,i1] = intersect(brain_voxels,clustInd{m,n});
            dis = KNN.nearestNeighborDists(i1,k);
            [~,mii] = min(dis);
            voxInd = i1(mii);
            densestPoint(m,n) = brain_voxels(voxInd);
        end
    end
end
