function X = returnFeatures(X,featureSet)

% This function returns different ISC feature sets.
% In the input data X, features should be organized so that 
% features 1,3,5,7...,end-1 correspond to ISC variability features 
% and features 2,4,6,8,...,end correspond to mean ISC features.

% Select feature set:
switch featureSet
  case 1 % return all features
  case 2 % return both mean ISC and weighted variability features
    d = X(:,1:2:end);
    d = d*10;
    X(:,1:2:end) = d;
  case 3 % return mean ISC features only
    X = X(:,2:2:end);
  case 4 % return variability features only
    X = X(:,1:2:end);
   otherwise
	error('Unknown option')
end

