#!/bin/tcsh

# this is a universal ICBM processing script
# source ~petr/fsl5.sh

#export PATH=$PATH:/data/brutus_data0/freeware/afni
set path = ($path /data/brutus_data0/freeware/afni)
echo $path

mkdir /data/.../FC_reho_SB_DR/ReHoAnaly/

foreach subj (s001 s002)

#foreach subj (002 ... n00)

mkdir /data/.../FC_reho_SB_DR/ReHoAnaly/${subj}
set outdir = /data/.../FC_reho_SB_DR/ReHoAnaly/${subj}
set rsdir = /data/.../FC_reho_SB_DR/rsfMRIStudy/${subj}/${subj}.results
cd /data/.../FC_reho_SB_DR/rsfMRIStudy/${subj}/${subj}.results

#===--copy processed data (replacing censored TR with avg signal) and subjects' brainmask ----

3dcopy $rsdir/errts.${subj}.fanaticor+tlrc. ap_data.nii
3dcopy $rsdir/mask_anat.${subj}+tlrc. brainMask.nii
#-------one can use ENIGMA EPI template mask too--------
$FSLDIR/bin/fslmaths ap_data.nii -mas brainMask.nii BgRem.nii
$FSLDIR/bin/fslmaths BgRem.nii.gz -Tmean Avg_Vol
$FSLDIR/bin/fslmaths BgRem.nii -add Avg_Vol.nii ProcData.nii

gunzip -k ProcData.nii.gz

cp $rsdir/ProcData.nii  $outdir/ProcData.nii
cp $rsdir/brainMask.nii  $outdir/brainMask.nii

rm ProcData.nii.gz ap_data.nii BgRem.nii.gz Avg_Vol.nii.gz

end




