#!/bin/tcsh
set path = ($path /data/brutus_data0/freeware/afni)
echo $path

mkdir /data/.../FC_reho_SB_DR_FC/DR_rsFC/RSN/Data_subj/

foreach subj (s001 s002)

#foreach subj (002 ... n00)


mkdir /data/.../FC/DR_rsFC/RSN/Data_subj/${subj}/

cd /data/.../FC/DR_rsFC/RSN/Rois/
cp *tlrc* ../Data_subj/${subj}/

echo '***************' ${subj} '*************** '

cd /data/.../FC/DR_rsFC/RSN/Data_subj/${subj}/
set rsdir = /data/.../FC/rsfMRIStudy/${subj}/${subj}.results

foreach roi (a1 a2)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Ad_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Ad_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (f1 f2 p1 p2)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/At_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/At_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (d1 d2 d3)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Dm_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Dm_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (e1 e2)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Ec_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Ec_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (f3 f4 p3 p4)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Fp_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Fp_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (m1 m2 m3)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Sm_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Sm_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (s1 s2 s3)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Sl_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Sl_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end

foreach roi (v1 v2 v3)
    3dmaskave -quiet -mask ${roi}+tlrc $rsdir/Vs_errts.${subj}+tlrc. > ${roi}_ts.1D
    3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/Vs_errts.${subj}+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
    3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z
end
end
