fclose all
close all
clear all
warning off
clc
% sim_data: the time series 
load sim_data
y_final=sim_data;


%parameters
% node: the number of signals
node=size(y_final,1);
% max_embed: maximum embedding dimention
max_embed=50;
% init_rule: minimum number of rules
init_rule=5;
% MAX_rule: maximum number of rules
MAX_rule=30;
PValue=0.05;
% surrogation_number: number of surrogate data
surrogation_number=100;


if size(y_final,1)<4

 %determining embedding dimention   
[sigma embdim]=embdsymplec((y_final(:,4:end))',max_embed);
embdim1=repmat(embdim,1,node);

me=[];
for i=1:size(y_final,1)
    for j=1:embdim1(i)
me=[me size(y_final(i,j:end-j),2)];
    end
end
size_data=min(me);



X=[];
for i=1:size(y_final,1)
    for k=1:embdim1(i)
X=[X (y_final(i,embdim1(i)-k+1:embdim1(i)-k+size_data))'];
    end
end


T=[];
for i=1:size(y_final,1)
T=[T (y_final(i,embdim1(i)+1:embdim1(i)+size_data))'];
end

n_tr=round(75/100*size(X,1));
n_te=size(X,1)-n_tr;
node=size(T,2);
mse_trn=[];
mse_test=[];
out_trn_estimated_1=[];
out_test_estimated_1=[];
error_trnData_1=[];
error_testData_1=[];
% obtain mse of model 1
for m=1:size(T,2)
trnData = [X(1:n_tr,:) T(1:n_tr,m)];
testData = [X(n_tr+1:size(X,1),:) T(n_tr+1:size(X,1),m)];
[ out_fis,opt_rule_step1(m) ] = trainFIS_with_genfis3( trnData(:,1:size(trnData,2)-1),trnData(:,size(trnData,2)),testData,init_rule,MAX_rule );
out_trn_estimated=evalfis(trnData(:,1:size(trnData,2)-1),out_fis);
out_trn_estimated_1=[out_trn_estimated_1; out_trn_estimated];
error_trnData=out_trn_estimated-trnData(:,size(trnData,2));
error_trnData_1=[error_trnData_1; error_trnData];
mse_trn=[mse_trn 1/n_tr*sum(error_trnData.^2)];
out_test_estimated=evalfis(testData(:,1:size(testData,2)-1),out_fis);
out_test_estimated_1=[out_test_estimated_1; out_test_estimated];
error_testData=out_test_estimated-testData(:,size(trnData,2));
error_testData_1=[error_testData_1; error_testData];
mse_test=[mse_test 1/n_te*sum(error_testData.^2)];
out_fis=[],error1=[],ss=[],fismat2=[],error2=[];
end

trnData=[];
testData=[];
 % obtain mse of model 2
for i=1:size(T,2)
mse_trn_1=[];
mse_test_1=[];
out_trn_estimated_1=[];
out_test_estimated_1=[];
error_trnData_1=[];
error_testData_1=[];
    for j=1:size(T,2)
trnData=[];
testData=[];
trnData = [X(1:n_tr,:) T(1:n_tr,i)];
testData = [X(n_tr+1:size(X,1),:) T(n_tr+1:size(X,1),i)];

A1=sum(embdim1(1:j-1));
trnData(:,A1+1:A1+embdim1(j))=[];
testData(:,A1+1:A1+embdim1(j))=[];
[ out_fis,opt_rule_step2(i,j) ] = trainFIS_with_genfis3( trnData(:,1:size(trnData,2)-1),trnData(:,size(trnData,2)),testData,init_rule,MAX_rule );
out_trn_estimated=evalfis(trnData(:,1:size(trnData,2)-1),out_fis);
out_trn_estimated_1=[out_trn_estimated_1; out_trn_estimated];
error_trnData=out_trn_estimated-trnData(:,size(trnData,2));
error_trnData_1=[error_trnData_1; error_trnData];
mse_trn_1=[mse_trn_1 1/n_tr*sum(error_trnData.^2)];
out_test_estimated=evalfis(testData(:,1:size(testData,2)-1),out_fis);
out_test_estimated_1=[out_test_estimated_1; out_test_estimated];
error_testData=out_test_estimated-testData(:,size(trnData,2));
error_testData_1=[error_testData_1; error_testData];
mse_test_1=[mse_test_1 1/n_te*sum(error_testData.^2)];
out_fis=[],error1=[],ss=[],fismat2=[],error2=[];
    end
%ANFISGC=ln(mse_model2/mse_model1)
 ANFISGC(i,:)=log(mse_trn_1./mse_trn); 
end

for i=1:size(T,2)
    ANFISGC(i,i)=-inf;
end



shift1=floor(0.05*n_tr):floor(0.95*n_tr);
rand_perm=randperm(length(floor(0.05*n_tr):floor(0.95*n_tr)));
shift1_=floor(0.05*n_te):floor(0.95*n_te);
rand_perm_=randperm(length(floor(0.05*n_te):floor(0.95*n_te)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%generating surrogate data

for s=1:surrogation_number

for cnt=1:size(T,2) 
    
X_mo=y_final(:,1:n_tr);
selected_myx=X_mo(cnt,:);
shift=shift1(rand_perm(cnt));
out=[selected_myx(shift:end) selected_myx(1:shift-1)];
X_mo(cnt,:)=out;
mt=[];



for i=1:size(X_mo,1)
    for j=1:embdim1(i)
mt=[mt size(X_mo(i,j:end-j),2)];
    end
end
size_data1=min(mt);



myx1=[];
for i=1:size(X_mo,1)
    for k=1:embdim1(i)
myx1=[myx1 (X_mo(i,embdim1(i)-k+1:embdim1(i)-k+size_data1))'];
    end
end


X_mo1=y_final(:,n_tr+1:end);
selected_myx1=X_mo1(cnt,:);
shift_=shift1_(rand_perm_(cnt));
out1=[selected_myx1(shift_:end) selected_myx1(1:shift_-1)];
X_mo1(cnt,:)=out1;
mt1=[];


for i=1:size(X_mo1,1)
    for j=1:embdim1(i)
mt1=[mt1 size(X_mo1(i,j:end-j),2)];
    end
end
size_data2=min(mt1);

myx2=[];
for i=1:size(X_mo1,1)
    for k=1:embdim1(i)
myx2=[myx2 (X_mo1(i,embdim1(i)-k+1:embdim1(i)-k+size_data2))'];
    end
end



 X_1{cnt}=[myx1;myx2]; 
 myx2=[];
 myx1=[];
end


[ANFISGC_surro_final1]=MYsurro_ANFISGC(X_1,T,embdim1,opt_rule_step1,opt_rule_step2);
ANFISGC_Surrogate(:,:,s)=ANFISGC_surro_final1;

end

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Significancy estimation

cnt=1;
for i=1:size(ANFISGC,1)
    for j=1:size(ANFISGC,2)

        if i~=j
                    subplot(node,node,cnt)
        hist(squeeze(ANFISGC_Surrogate(i,j,:)))
        hold on
        plot(ANFISGC(i,j),0,'r*')
   ANFISGC_Surrogate_sort=squeeze(sort(ANFISGC_Surrogate(i,j,:)));
            hold on
            ok=0;
            for k=1:length(ANFISGC_Surrogate_sort)
                if ANFISGC_Surrogate_sort(k)>0
                    ok=1;
                    break;
                end
            end
         if ok==1
        plot(repmat(ANFISGC_Surrogate_sort(round((1-PValue)*surrogation_number)),1,35),1:35,'-g')
            else
             plot(repmat(0,1,35),1:35,'-g')

            end
        title([num2str(j),'-->',num2str(i)'])
       legend('ANFISGC of surrogate dataset','ANFISGC of original dataset','threshold')
        end
        cnt=cnt+1;
    end
end



%estimating the connectivity matrix
ANFISGC_connectivity_matrix=zeros(node,node);
for i=1:node
    for j=setdiff(1:node,i)
        ANFISGC_Surrogate_sort=squeeze(sort(ANFISGC_Surrogate(i,j,:)));
        if ANFISGC(i,j)>0 & ANFISGC(i,j)>ANFISGC_Surrogate_sort(round((1-PValue)*surrogation_number))
            ANFISGC_connectivity_matrix(i,j)=1;
        end
    end
end           
                    
ANFISGC_connectivity_matrix

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55

y_final1=y_final;

if size(y_final1,1)>3
y_final=[];    
[sigma embdim]=embdsymplec((y_final1(:,4:end))',max_embed);
node=3;
embdim1=repmat(embdim,1,node);

[ ind_timeseries ind_time_series_conn  ind_time_series_conn_1]=seperate_3times_series(size(y_final1,1));
for mon=1:size(ind_timeseries,1)

    
y_final=y_final1(ind_timeseries(mon,:),:);


me=[];
for i=1:size(y_final,1)
    for j=1:embdim1(i)
me=[me size(y_final(i,j:end-j),2)];
    end
end
size_data=min(me);



X=[];
for i=1:size(y_final,1)
    for k=1:embdim1(i)
X=[X (y_final(i,embdim1(i)-k+1:embdim1(i)-k+size_data))'];
    end
end


T=[];
for i=1:size(y_final,1)
T=[T (y_final(i,embdim1(i)+1:embdim1(i)+size_data))'];
end

n_tr=round(75/100*size(X,1));
n_te=size(X,1)-n_tr;
node=size(T,2);
mse_trn=[];
mse_test=[];
out_trn_estimated_1=[];
out_test_estimated_1=[];
error_trnData_1=[];
error_testData_1=[];
for m=1:size(T,2)
trnData = [X(1:n_tr,:) T(1:n_tr,m)];
testData = [X(n_tr+1:size(X,1),:) T(n_tr+1:size(X,1),m)];

[ out_fis,opt_rule_step1(m) ] = trainFIS_with_genfis3( trnData(:,1:size(trnData,2)-1),trnData(:,size(trnData,2)),testData,init_rule,MAX_rule );

out_trn_estimated=evalfis(trnData(:,1:size(trnData,2)-1),out_fis);
out_trn_estimated_1=[out_trn_estimated_1; out_trn_estimated];
error_trnData=out_trn_estimated-trnData(:,size(trnData,2));
error_trnData_1=[error_trnData_1; error_trnData];
mse_trn=[mse_trn 1/n_tr*sum(error_trnData.^2)];
out_test_estimated=evalfis(testData(:,1:size(testData,2)-1),out_fis);
out_test_estimated_1=[out_test_estimated_1; out_test_estimated];
error_testData=out_test_estimated-testData(:,size(trnData,2));
error_testData_1=[error_testData_1; error_testData];
mse_test=[mse_test 1/n_te*sum(error_testData.^2)];
out_fis=[],error1=[],ss=[],fismat2=[],error2=[];
end

trnData=[];
testData=[];

for i=1:size(T,2)
mse_trn_1=[];
mse_test_1=[];
out_trn_estimated_1=[];
out_test_estimated_1=[];
error_trnData_1=[];
error_testData_1=[];
    for j=1:size(T,2)
trnData=[];
testData=[];
trnData = [X(1:n_tr,:) T(1:n_tr,i)];
testData = [X(n_tr+1:size(X,1),:) T(n_tr+1:size(X,1),i)];

A1=sum(embdim1(1:j-1));
trnData(:,A1+1:A1+embdim1(j))=[];
testData(:,A1+1:A1+embdim1(j))=[];

[ out_fis,opt_rule_step2(i,j) ] = trainFIS_with_genfis3( trnData(:,1:size(trnData,2)-1),trnData(:,size(trnData,2)),testData,init_rule,MAX_rule );

out_trn_estimated=evalfis(trnData(:,1:size(trnData,2)-1),out_fis);
out_trn_estimated_1=[out_trn_estimated_1; out_trn_estimated];
error_trnData=out_trn_estimated-trnData(:,size(trnData,2));
error_trnData_1=[error_trnData_1; error_trnData];
mse_trn_1=[mse_trn_1 1/n_tr*sum(error_trnData.^2)];
out_test_estimated=evalfis(testData(:,1:size(testData,2)-1),out_fis);
out_test_estimated_1=[out_test_estimated_1; out_test_estimated];
error_testData=out_test_estimated-testData(:,size(trnData,2));
error_testData_1=[error_testData_1; error_testData];
mse_test_1=[mse_test_1 1/n_te*sum(error_testData.^2)];
out_fis=[],error1=[],ss=[],fismat2=[],error2=[];
    end
 ANFISGC(i,:)=log(mse_trn_1./mse_trn); 
end

for i=1:size(T,2)
    ANFISGC(i,i)=-inf;
end
ANFISGC_cond{mon}= ANFISGC;


shift1=floor(0.05*n_tr):floor(0.95*n_tr);
rand_perm=randperm(length(floor(0.05*n_tr):floor(0.95*n_tr)));
shift1_=floor(0.05*n_te):floor(0.95*n_te);
rand_perm_=randperm(length(floor(0.05*n_te):floor(0.95*n_te)));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%generating surrogate data
 
for s=1:surrogation_number

for cnt=1:size(T,2) 
    
X_mo=y_final(:,1:n_tr);
selected_myx=X_mo(cnt,:);
shift=shift1(rand_perm(cnt));
out=[selected_myx(shift:end) selected_myx(1:shift-1)];
X_mo(cnt,:)=out;
mt=[];

for i=1:size(X_mo,1)
    for j=1:embdim1(i)
mt=[mt size(X_mo(i,j:end-j),2)];
    end
end
size_data1=min(mt);

myx1=[];
for i=1:size(X_mo,1)
    for k=1:embdim1(i)
myx1=[myx1 (X_mo(i,embdim1(i)-k+1:embdim1(i)-k+size_data1))'];
    end
end


X_mo1=y_final(:,n_tr+1:end);
selected_myx1=X_mo1(cnt,:);
shift_=shift1_(rand_perm_(cnt));
out1=[selected_myx1(shift_:end) selected_myx1(1:shift_-1)];
X_mo1(cnt,:)=out1;
mt1=[];

for i=1:size(X_mo1,1)
    for j=1:embdim1(i)
mt1=[mt1 size(X_mo1(i,j:end-j),2)];
    end
end
size_data2=min(mt1);

myx2=[];
for i=1:size(X_mo1,1)
    for k=1:embdim1(i)
myx2=[myx2 (X_mo1(i,embdim1(i)-k+1:embdim1(i)-k+size_data2))'];
    end
end

X_1{cnt}=[myx1;myx2];
 myx2=[];
 myx1=[];
end


[ANFISGC_surro_final1]=MYsurro_ANFISGC(X_1,T,embdim1,opt_rule_step1,opt_rule_step2);
ANFISGC_Surrogate(:,:,s)=ANFISGC_surro_final1;

end
ANFISGC_Surrogate_cond{mon}=ANFISGC_Surrogate;
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Significancy estimation


figure
node=3;
cnt=1;
for i=1:size(ANFISGC,1)
    for j=1:size(ANFISGC,2)

        if i~=j
                    subplot(node,node,cnt)
        hist(squeeze(ANFISGC_Surrogate(i,j,:)))
        hold on
        plot(ANFISGC(i,j),0,'r*')
   ANFISGC_Surrogate_sort=squeeze(sort(ANFISGC_Surrogate(i,j,:)));
            hold on
            ok=0;
            for k=1:length(ANFISGC_Surrogate_sort)
                if ANFISGC_Surrogate_sort(k)>0
                    ok=1;
                    break;
                end
            end
         if ok==1
        plot(repmat(ANFISGC_Surrogate_sort(round((1-PValue)*surrogation_number)),1,35),1:35,'-g')
            else
             plot(repmat(0,1,35),1:35,'-g')

         end
    A1=ind_timeseries(mon,:);
    A2=[A1(j) A1(i)];
    MYC= ismember(A1,A2); 
    CONDITIONAL_ELEMENT=A1(find(MYC==0));
         
        title([num2str(A1(j)),'-->',num2str(A1(i)),'|',num2str(CONDITIONAL_ELEMENT)])
       legend('ANFISGC of surrogate dataset','ANFISGC of original dataset','threshold')
        end
        cnt=cnt+1;
    end
end



%estimating the connectivity matrix
ANFISGC_connectivity_matrix=zeros(node,node);
for i=1:node
    for j=setdiff(1:node,i)
        ANFISGC_Surrogate_sort=squeeze(sort(ANFISGC_Surrogate(i,j,:)));
        if ANFISGC(i,j)>0 & ANFISGC(i,j)>ANFISGC_Surrogate_sort(round((1-PValue)*surrogation_number))
            ANFISGC_connectivity_matrix(i,j)=1;
        end
     
    end
end           
                    
ANFISGC_connectivity_matrix_cond{mon}=ANFISGC_connectivity_matrix;

ANFISGC_Surrogate_sort=[];
ANFISGC_Surrogate=[];
ANFISGC=[];
end

A=[];
B=[];
D=[];
for i=1:length(ind_time_series_conn_1)
A=[A ind_time_series_conn_1{i}];
B=[B  ANFISGC_connectivity_matrix_cond{i}];
D=[D ANFISGC_cond{i}];
end

for i=1:size(A,1)
    for j=1:size(A,2)
        C(i,j)=str2num(A{i,j});
    end
end

ANFISGC_connectivity_matrix_final=zeros(size(y_final1,1),size(y_final1,1));
for i=1:size(y_final1,1)
ANFISGC_connectivity_matrix_final(i,i)=inf;
end

for i=1:size(y_final1,1)
    for j=1:size(y_final1,1)
        mymat(i,j)=str2num(strcat(num2str(j),num2str(i)));
        [RO_1 CO_1]=find(C==mymat(i,j));
        if length(RO_1)~=0
        for d=1:length(RO_1)
            myl(d)=B(RO_1(d),CO_1(d));
        end
        ANFISGC_connectivity_matrix_final(i,j)=mymultiply(myl);
        myl=[];
        RO_1=[];
        CO_1=[];
        end
    end
end
ANFISGC_connectivity_matrix_final

end


