function [ out_fis_opt,opt_rule ] = trainFIS_with_genfis3( A,B,C,init,MAX_rule )
%A:input data train 
%B:output data train
%C: data test
%init:minimum number of rules
%MAX_rule: maximum number of rules
%out_fis_opt: ANFIS with the least MSE on the testing set (The winner ANFIS)
%opt_rule: optimal number of rules

for num_rule=init:MAX_rule
out_fis1= genfis3(A,B,'sugeno',num_rule);
[out_fis{num_rule-init+1},error1(:,num_rule-init+1),ss(:,num_rule-init+1),fismat2{num_rule-init+1},error2(:,num_rule-init+1)] = anfis([A,B],out_fis1,[],[],C);
end

[val ind]=min(min(error2));

opt_rule=ind+init-1;
out_fis_opt=out_fis{ind};
end

