##This script pulls the iterated SOLAR results and plots them. This script must be run after the simulation data script and AFTER the command solar > mztwin_solar.txt runs all of the SOLAR calculations.

################Libraries required########################
require(reshape2)#need for reshaping data between SOLAR and Openmx
require(ggplot2)#need for plotting
require(gplots)#need for plotting
#require(psych)
require(MASS)#need for multivariate normal function in R (mvrnorm)

####Specify directory and dataset folder and file names#########
##if not running R in same location that SOLAR will be run, need to have R and SOLAR directories. The SOLAR directories are named _linux here##

mainDir <- "/data/Solar_MEK/" 
mainDir_linux <- "/data/Solar_MEK/" #when running on linux change A to /labs/twells and change back when running on comput
subDir_linux<-paste(mainDir_linux,'LiveDemo/',sep="")
subDirmz_linux<-paste(subDir_linux,'twins4/',sep="")
subDir<-paste(mainDir,'LiveDemo/',sep="")
subDirmz<-paste(subDir,'twins4/',sep="")

## Make directories that were specified above if they don't exist already ##

if (!file.exists(subDir)){
    dir.create(file.path(subDir))
   }
if (!file.exists(subDirmz)){
    dir.create(file.path(subDirmz))
   }

#############Set iterations, number of pairs, A and C###########
max=60 #max number of pairs
number=c(20,max) #number of pairs
set.seed=number #this sets the seed for the mvnorm functions
iterations=10 #number of phenotype files created for each simulation
a2_percent=c(10,50) #this is standardized standard deviation attributable to additive genetics (A/(A+C+E))
c2_percent=0 #this is standardized standard deviation attributable to common environment (set to 0 here)(A/(A+C+E)

############ Set up results matrices for average heritability estimates, bias, and variance that are the size of the A simulated and the number of pairs simulated##############

h2r_averagematrix<-matrix(0,length(a2_percent),length(number))
rownames(h2r_averagematrix)<-a2_percent
colnames(h2r_averagematrix)<-number

h2r_bias<-matrix(0,length(a2_percent),length(number))
rownames(h2r_bias)<-a2_percent
colnames(h2r_bias)<-number

h2r_var<-matrix(0,length(a2_percent),length(number))
rownames(h2r_var)<-a2_percent
colnames(h2r_var)<-number

####Specify directory and dataset folder and file names for result file locations#########

pairs=number

solar_average_results<-paste(subDirmz,'/results_twins_average.csv',sep="")
if (!file.exists(solar_average_results)){
    	file.create(file.path(solar_average_results))
   	}

solar_bias_results<-paste(subDirmz,'/results_twins_bias.csv',sep="")
if (!file.exists(solar_bias_results)){
    	file.create(file.path(solar_bias_results))
   	}

solar_var_results<-paste(subDirmz,'/results_twins_var.csv',sep="")
if (!file.exists(solar_var_results)){
    	file.create(file.path(solar_var_results))
   	}

for (num2 in 1:length(number)){
#looping through pair numbers 
	num=number[num2]
	subDirmzpair=paste(subDirmz,'pair',num,sep="")

	for (A2 in 1:length(a2_percent)){
#looping through simulated additive genetics standardized variances
		A<-a2_percent[A2]
		subDirmzA<-paste(subDirmzpair,'/A_',A,sep="")

		for (C2 in 1:length(c2_percent)){
#looping through simulated common environment standardized variances
			C<-c2_percent[C2]
			subDirmzAC<-paste(subDirmzA,'/A_',A,'_C_',C,sep="")
			solarMZresults<-paste(subDirmzAC,'/results_twins.csv',sep="")

			if (!file.exists(solarMZresults)){
    				file.create(file.path(solarMZresults))
   				}
			h2r_results=c()
			
			for (iter in 1:iterations){
#iterating through every SOLAR analysis run 		
				outdirMZ<-paste(subDirmzAC,'/gen',iter,"out/polygenic.residuals",sep="")

#pulling SOLAR results from the log file 		
				resultforce=as.matrix(read.table(paste(subDirmzAC,'/gen',iter,'out/polygenic.logs.out',sep=""),sep = "", fill=TRUE))
				if (nrow(resultforce)>2 & ncol(resultforce)>6){
    				h2r_results=as.matrix(c(h2r_results,resultforce[3,7]))
   					}
				}
			}

#Writing results pulled from SOLAR iterations for each combination of A and C
			write.table(h2r_results, solarMZresults, col.names=FALSE, row.names=FALSE, quote=FALSE, sep=",")

#Calculating Average, Bias, and Variance for openMX results
			h2r_averagematrix[A2,num2]=mean(as.numeric(h2r_results))
			h2r_bias[A2,num2]=mean(as.numeric(h2r_results))-A/100
			h2r_var[A2,num2]=var(as.numeric(h2r_results))

		}
	}
}

####################Writing Results Tables######################

write.table(h2r_averagematrix, solar_average_results, col.names=TRUE, row.names=TRUE, quote=FALSE, sep=",")
write.table(h2r_bias, solar_bias_results, col.names=TRUE, row.names=TRUE, quote=FALSE, sep=",")
write.table(h2r_var, solar_var_results, col.names=TRUE, row.names=TRUE, quote=FALSE, sep=",")

####################Plotting Results to PDFS ###############
h2r_avemelt<-melt(h2r_averagematrix)
colnames(h2r_avemelt)<-c('A','Pairs','Heritability')
colnames(h2r_averagematrix)<-4*number
colnames(h2r_bias)<-4*number
colnames(h2r_var)<-4*number

setwd(subDir)
pdf("twins_solar_heatmap2.pdf")
palette.breaks <- seq(0, 1, 0.01)
my_palette <- colorRampPalette(c("red", "orange", "yellow"))(length(palette.breaks) - 1)
ave<-heatmap.2(h2r_averagematrix, breaks = palette.breaks,xlab="Number of individuals", ylab="Heritability",keysize = 2,main= "Twins Heritabilities",Rowv=F, Colv=F, col = my_palette, scale="none",margin=c(5,10), key=TRUE, symkey=FALSE,density.info="none",trace="none")
dev.off()
pdf("twins_solar_bias2.pdf")
palette.breaks <- seq(-.4, .4, .005)
my_palette <- colorRampPalette(c("red", "black", "blue"))(length(palette.breaks) - 1)
bias<-heatmap.2(h2r_bias,breaks = palette.breaks,xlab="Number of individuals",symbreaks=T, ylab="Heritability", keysize = 2,main= "Twins Bias", Rowv=F, Colv=F, col = my_palette, scale="none",margin=c(5,10), key=TRUE, symkey=TRUE,density.info="none",trace="none")
dev.off()
pdf("twins_solar_var2.pdf")
palette.breaks <- seq(0, .2, .005)
my_palette <- colorRampPalette(c("black","red"))(length(palette.breaks) - 1)
var<-heatmap.2(h2r_var, breaks = palette.breaks,xlab="Number of individuals", ylab="Heritability",keysize = 2,main= "Twins Variance",Rowv=F, Colv=F, col = my_palette, scale="none",margin=c(5,10), key=TRUE, symkey=FALSE,density.info="none",trace="none")
dev.off()

