function updated_struct = find_and_replace_recurse(struct, needle, replace)
    % check if struct is a string
    updated_struct = struct;
    if ischar(struct)
        % find and replace
        disp('found a string!')
        updated_struct = strrep(struct, needle, replace);
        disp([struct, ' -> ', updated_struct])
    elseif isstruct(struct)
        % loop through all elements in struct
        for row = 1:length(struct) % all rows
            disp(['working on row: ', num2str(row)])
            fnames=fieldnames(struct);
            for i = 1:numel(fnames) % all fields
                % recurse structure
                disp(['working on struct:', fnames{i}])
                updated_struct(row).(fnames{i}) = find_and_replace_recurse(struct(row).(fnames{i}), needle, replace);
            end
        end
    elseif  iscell(struct)
        % loop through all elements in cell (array)
        for i = 1:length(struct)
            % recurse cell array
            disp(strcat('working on cell:', num2str(i)))
            updated_struct{i} = find_and_replace_recurse(struct{i}, needle, replace);
        end
    end
end
