% Generating simulated data
% snr=0db
% number of data samples: 4000;
% c=0.5;
%x1 (n)=3.4 x1(n-1)(1-x1^2(n-1))e^(-x1^2(n-1))+e1(n)
%x2 (n)=3.4 x2(n-1)(1-x2^2(n-1))e^(-x2^2(n-1))+cx2(n-2)x1(n-1)+e2(n)
%x3 (n)=3.4 x3(n-1)(1-x3^2(n-1))e^(-x3^2(n-1))+0.3x2(n-1)+0.5x1^2(n-1)+e3(n)

fclose all
clear all
clc
len=4000;
c=0.5;
x1(1)=0.1;
x2(1)=0.2;
x3(1)=0.3;
for i=2:len
    x1(i)=3.4*x1(i-1)*(1-(x1(i-1))^2)*exp(-(x1(i-1))^2);
    x2(i)=3.4*x2(i-1)*(1-(x2(i-1))^2)*exp(-(x2(i-1))^2)+c*x1(i-1)*x2(i-1);
    x3(i)=3.4*x3(i-1)*(1-(x3(i-1))^2)*exp(-(x3(i-1))^2)+0.3*x2(i-1)+0.5*((x1(i-1))^2);
end
level=1;
x1=x1+randn(1,len)*level*std(x1);
x2=x2+randn(1,len)*level*std(x2);
x3=x3+randn(1,len)*level*std(x3);
sim_data=[x1;x2;x3];

