% 2 x 3 x 2 factorial design:
%   within-subject factor <location> with 2 levels (arm/fingers)
%   within-subject factor <texture> with 3 levels (soft/medium/coarse)
%   between-subject factor <drink> with 2 levels (balanced/tryptophan-depleting)
% 14 subjects balanced drink and 16 subjects tryptophan-depleting drink

Y = spm_load('fmriDataLong.csv'); % # datapoints = 2*3*(14+16)
Y = Y.x0x22voxData0x22; % "voxData": L1T1D1 L2T1D1 L1T2D1 L2T2D1 L1T3D1 L2T3D1 ...

Effects = {'Intercept';'Drink';'Location';'Location x Drink';'Texture';'Texture x Drink';'Location x Texture';'Location x Texture x Drink'};
PartitionedFStat = zeros(8,1);
PartitionedDF = zeros(8,1);
TwoLevelFStat = zeros(8,1);
TwoLevelDF = zeros(8,1);
SPSSFStat = [0.481; 0.193; 0.038; 0.150; 0.685; 1.634; 11.238; 1.167];
SPSSDF = [1.28; 1.28; 1.28; 1.28; 2.56; 2.56; 2.56; 2.56];

%==========================================================================
% PARTITIONED ERRORS
%==========================================================================

%--------------------------------------------------------------------------
% Error = Subject
% Tests = Intercept and Main Effect of Drink
%--------------------------------------------------------------------------
Y1 = kron(eye(30),[1 1 1 1 1 1]/6) * Y; 
X1 = blkdiag(ones(14,1),ones(16,1));

[t1, df1] = spm_ancova(X1,eye(30),Y1,[1 1]');
[t2, df2] = spm_ancova(X1,eye(30),Y1,[1 -1]');

PartitionedFStat(1) = t1^2; PartitionedDF(1) = df1(1) + df1(2)/100;
PartitionedFStat(2) = t2^2; PartitionedDF(2) = df2(1) + df2(2)/100;

%--------------------------------------------------------------------------
% Error = Subject x Location
% Tests = Main Effect of Location and Location x Drink
%--------------------------------------------------------------------------
Y2 = kron(eye(30),[1 -1 1 -1 1 -1]/3) * Y;
X2 = blkdiag(ones(14,1),ones(16,1));

[t3, df3] = spm_ancova(X2,eye(30),Y2,[1 1]');
[t4, df4] = spm_ancova(X2,eye(30),Y2,[1 -1]');

PartitionedFStat(3) = t3^2; PartitionedDF(3) = df3(1) + df3(2)/100;
PartitionedFStat(4) = t4^2; PartitionedDF(4) = df4(1) + df4(2)/100;

%--------------------------------------------------------------------------
% Error = Subject x Texture
% Tests = Main Effect of Texture and Texture x Drink
%--------------------------------------------------------------------------

Y3 = kron(eye(30),[1 1 0 0 0 0; 0 0 1 1 0 0;0 0 0 0 1 1]/2) * Y;
X3 = [kron(blkdiag(ones(14,1),ones(16,1)),eye(3)) kron(eye(30),ones(3,1))];

[t5, df5] = spm_ancova(X3,eye(90),Y3,[1 -1 0 1 -1 0 zeros(1,30);0 1 -1 0 1 -1 zeros(1,30)]');
[t6, df6] = spm_ancova(X3,eye(90),Y3,[1 -1 0 -1 1 0 zeros(1,30);0 1 -1 0 -1 1 zeros(1,30)]');

PartitionedFStat(5) = t5; PartitionedDF(5) = df5(1) + df5(2)/100;
PartitionedFStat(6) = t6; PartitionedDF(6) = df6(1) + df6(2)/100;

%--------------------------------------------------------------------------
% Error = Subject x Location x Texture
% Tests = Location x Texture and Location x Texture x Drink
%--------------------------------------------------------------------------
Y4 = kron(eye(30),[1 -1 0 0 0 0;0 0 1 -1 0 0;0 0 0 0 1 -1]) * Y;
X4 = [kron(blkdiag(ones(14,1),ones(16,1)),eye(3)) kron(eye(30),ones(3,1))];

[t7, df7] = spm_ancova(X4,eye(90),Y4,[1 -1 0 1 -1 0 zeros(1,30);0 1 -1 0 1 -1 zeros(1,30)]'); 
[t8, df8] = spm_ancova(X4,eye(90),Y4,[1 -1 0 -1 1 0 zeros(1,30);0 1 -1 0 -1 1 zeros(1,30)]');

PartitionedFStat(7) = t7; PartitionedDF(7) = df7(1) + df7(2)/100;
PartitionedFStat(8) = t8; PartitionedDF(8) = df8(1) + df8(2)/100;


%==========================================================================
% TWO-LEVEL APPROACH FROM EXAMPLE 2 BY WILL PENNY: 
% https://en.wikibooks.org/wiki/SPM/Group_Analysis
%==========================================================================

%--------------------------------------------------------------------------
% Intercept
%--------------------------------------------------------------------------
Y1 = kron(eye(30),[1 1 1 1 1 1]) * Y;
X1 = ones(30,1);

[t1, df1] = spm_ancova(X1,eye(30),Y1,1);

TwoLevelFStat(1) = t1^2; TwoLevelDF(1) = df1(1) + df1(2)/100;

%--------------------------------------------------------------------------
% Main Effect of Drink
%--------------------------------------------------------------------------
Y2 = kron(eye(30),[1 1 1 1 1 1]) * Y;
X2 = blkdiag(ones(14,1),ones(16,1));

[t2, df2] = spm_ancova(X2,eye(30),Y2,[1 -1]');

TwoLevelFStat(2) = t2^2; TwoLevelDF(2) = df2(1) + df2(2)/100;

%--------------------------------------------------------------------------
% Main Effect of Location
%--------------------------------------------------------------------------
Y3 = kron(eye(30),[1 -1 1 -1 1 -1]) * Y; % arm-finger
X3 = ones(30,1); % one-sample t-test

[t3, df3] = spm_ancova(X3,eye(30),Y3,1);

TwoLevelFStat(3) = t3^2; TwoLevelDF(3) = df3(1) + df3(2)/100;

%--------------------------------------------------------------------------
% Location x Drink
%--------------------------------------------------------------------------
Y4 = kron(eye(30),[1 -1 1 -1 1 -1]) * Y; % arm-finger
X4 = blkdiag(ones(14,1),ones(16,1));

[t4, df4] = spm_ancova(X4,eye(30),Y4,[1 -1]');

TwoLevelFStat(4) = t4^2; TwoLevelDF(4) = df4(1) + df4(2)/100;

%--------------------------------------------------------------------------
% Main Effect of Texture
%--------------------------------------------------------------------------
Y5 = kron(eye(30),[1 1 -1 -1 0 0; 0 0 1 1 -1 -1]) * Y;
X5 = blkdiag(ones(28,1),ones(32,1));

[t5, df5] = spm_ancova(X5,eye(60),Y5,eye(2));

TwoLevelFStat(5) = t5; TwoLevelDF(5) = df5(1) + df5(2)/100;




Y5 = kron(eye(30),[1 1 -1 -1 0 0; 0 0 1 1 -1 -1; 1 1 0 0 -1 -1]) * Y;
X5 = blkdiag(ones(42,1),ones(48,1));

[t5, df5] = spm_ancova(X5,eye(90),Y5,eye(2));


%--------------------------------------------------------------------------
% Texture x Drink
%--------------------------------------------------------------------------
Y6 = kron(eye(30),[1 1 -1 -1 0 0; 0 0 1 1 -1 -1]) * Y;
X6 = blkdiag(ones(14,1), ones(14,1), ones(16,1), ones(16,1));

[t6, df6] = spm_ancova(X6,eye(60),Y6,[1 0 -1 0; 0 1 0 -1]');

TwoLevelFStat(6) = t6; TwoLevelDF(6) = df6(1) + df6(2)/100;

%--------------------------------------------------------------------------
% Location x Texture
%--------------------------------------------------------------------------
Y7 = kron(eye(30),[1 -1 -1 1 0 0; 0 0 1 -1 -1 1]) * Y;
X7 = blkdiag(ones(28,1),ones(32,1));

[t7, df7] = spm_ancova(X7,eye(60),Y7,eye(2));

TwoLevelFStat(7) = t7; TwoLevelDF(7) = df7(1) + df7(2)/100;

%--------------------------------------------------------------------------
% Location x Texture x Drink
%--------------------------------------------------------------------------
Y8 = kron(eye(30),[1 -1 -1 1 0 0; 0 0 1 -1 -1 1]) * Y;
X8 = blkdiag(ones(14,1), ones(14,1), ones(16,1), ones(16,1));

[t8, df8] = spm_ancova(X8,eye(60),Y8,[1 0 -1 0; 0 1 0 -1]');

TwoLevelFStat(8) = t8; TwoLevelDF(8) = df8(1) + df8(2)/100;


% Comparison table
T = table(Effects, PartitionedFStat, PartitionedDF, TwoLevelFStat, TwoLevelDF, SPSSFStat, SPSSDF);
T

