clear

DOPARALLEL=false;   % set to true/false to run in parallel or locally
PARALLELPROFILE=[];
DODISPLAY=true;     % set to false to skip loading/displaying conn project after finishing
TARGETpath=pwd;     % target folder for conn project (default current folder)
NSUBJECTS=[];       % number of subjects to include in your project (leave empty for all subjects)
NJOBS=[];           % number of parallel jobs to submit (leave empty for one job per subject)
COPYFILES=false;    % true/false: set to true if you do not have write-permissions into connectome data folders
                    %   This will create a local copy (in same folder as your conn project) of the structural/functional data
                    %   where any post-processed files will also be stored.
OVERWRITE=false;    % overwrites files if they exist in target folder (unzipped files and/or files in local-copy folder)
                    %   Set to false if you have already unzipped / copied-to-local-folder your data and would like to skip this step
%%
%% CONN-SPECIFIC SECTION: RUNS PREPROCESSING/SETUP/DENOISING/ANALYSIS STEPS
%% Prepares batch structure
clear batch;
batch.filename=fullfile(pwd,'conn_ECT2023.mat');            % New .mat experiment name
if DOPARALLEL 
    batch.parallel.N=NSUBJECTS; 
    if ~isempty(PARALLELPROFILE), batch.parallel.profile=PARALLELPROFILE; end
end
%%
%% Analysis step
load roi_test.mat

batch.Resuls.done = 0                                               %: 1/0: 0 defines fields only; 1 runs processing steps [0]
batch.Resuls.overwrite = 1                                          %: (for done=1) 1/0: overwrites target files if they exist [1] 
batch.Resuls.name ='SBC_01'                                         %: analysis name (identifying each set of first-level independent analysis)
                                                                    %(alternatively sequential index identifying each set of first-level independent analyses [1])
batch.Resuls.display = 0                                            %: 1/0 display results [1]
%batch.Resuls.saveas                                                %: (optional) name to save between-subjects/between_conditions contrast
%batch.Resuls.foldername                                            %: (optional) alternative folder name to store the results
batch.Resuls.between_subjects.effect_names = {'AllSubjects'}        %: cell array of second-level effect names
batch.Resuls.between_subjects.contrast = [1]                        % : contrast vector (same size as effect_names)
batch.Resuls.between_conditions.effect_names ={'01_rest','02_rest'} %: cell array of condition names (as in Setup.conditions.names)
batch.Resuls.between_conditions.contrast = [1 -1]                   %: contrast vector (same size as effect_names)
batch.Resuls.between_sources.effect_names = roi_names               % cell array of source names (as in Analysis.regressors, typically appended with _1_1; generally 
                                                                    % they are appended with _N_M -where N is an index ranging from 1 to 1+derivative order, and M 
                                                                    % is an index ranging from 1 to the number of dimensions specified for each ROI; for example 
                                                                    % ROINAME_2_3 corresponds to the first derivative of the third PCA component extracted from the 
                                                                    % roi ROINAME) 
batch.Resuls.between_sources.contrast = roi_contrasts               %: contrast vector (same size as effect_names)
%%
conn_batch(batch)