import os
import sys
import ctypes
from  ctypes import CFUNCTYPE, c_int,c_char,c_char_p
import numpy
class AlgorithmWrapper():
    def __init__(self):
        try:
          self.libraryName = "AlgorithmCore.dll"
          if os.name is not 'nt':
                if getattr(sys, 'frozen', False):
                    application_path = os.path.dirname(sys.executable)
                elif __file__:
                    application_path = os.path.dirname(__file__)
                soFileFullPath = os.path.join(application_path, "libAlgorithmCore.so")
                self.libraryName =str(soFileFullPath)
          self.CoreModule = ctypes.cdll.LoadLibrary(self.libraryName)
          self.listner= None
          self.txtCallback_ref = None
        except:
            self.CoreModule= None
            print("Failed to load:"+  self.libraryName )
    def registerCppCallback(self):
        if self.CoreModule is None:
            return

        TXT_CALLBACK =CFUNCTYPE(c_int, c_char_p)
        self.CoreModule.registerCallback.restype = None
        self.CoreModule.registerCallback.argtypes = [TXT_CALLBACK]
        self.txtCallback_ref = TXT_CALLBACK(self.pyTxtCallbackFunc)
        self.CoreModule.registerCallback(self.txtCallback_ref)
        self.listner = None
    def pyTxtCallbackFunc(self,txt):
        if self.CoreModule is None:
            return
        if txt is not None and self.listner is not None:
            self.listner("CORE:"+ str(txt))
        else:
            print("CORE:"+ str(txt))
        return 0
    def setListner(self, listner):
        if self.CoreModule is None:
            return
        self.listner= listner
        self.listner("Listening to core")

    def setValue(self,varName, varString, varType):
        if self.CoreModule is None:
            return
        self.CoreModule.setValue.restype = c_int
        self.CoreModule.setValue.argtypes = [c_char_p,c_char_p,c_int ]
        res = self.CoreModule.setValue(c_char_p(varName),c_char_p(varString),varType)

    #runAlgorithm
    def runAlgorithm(self,param):
        if self.CoreModule is None:
            return
        self.CoreModule.setValue.restype = c_int
        self.CoreModule.setValue.argtypes = [c_int ]
        res = self.CoreModule.runAlgorithm(c_int(param))
        return res
    def getValue(self,varName):
        if self.CoreModule is None:
            return
        self.CoreModule.getValue.restype = c_char_p
        self.CoreModule.getValue.argtypes = [c_char_p]
        res = self.CoreModule.getValue(c_char_p(varName))
        return res
    def testCallback(self,srcStr):
        if self.CoreModule is None:
            return
        self.CoreModule.testGetcallback.restype = c_int
        self.CoreModule.testGetcallback.argtypes = [c_char_p]
        res = self.CoreModule.testGetcallback(c_char_p(srcStr))
        return res
    def setParams(self,array):
        if self.CoreModule is None:
            return
        array= numpy.array(array)
        array = array.astype(numpy.float64)
        self.CoreModule.setParams.restype = c_int
        self.CoreModule.setParams.argtypes = [POINTER(c_double), c_int]
        return self.CoreModule.setParams(array.ctypes.data_as(POINTER(c_double)), len(array))
    def getParameters(self, count):
        if self.CoreModule is None:
            return
        array = [0.0]*count
        array= numpy.array(array)
        array = array.astype(numpy.float64)
        self.CoreModule.setParams.restype = c_int
        self.CoreModule.setParams.argtypes = [POINTER(c_double), c_int]
        self.CoreModule.getParameters(array.ctypes.data_as(POINTER(c_double)), len(array))
        return array.tolist()


def testRun():
    api = AlgorithmWrapper()
    api.registerCppCallback()
    res =api.runAlgorithm(2)
    print "Result of running algorithm with param 2 is " +str(res) 
if __name__ == '__main__':
    print os.getcwd()
    # A qucick copy command on windows This step is not necessary if you manually copy the file 
    from shutil import copyfile
    copyfile("../bin/Release/AlgorithmCore.dll", "AlgorithmCore.dll")

    testRun()
    raw_input("Press Enter to continue...")
