cimport cython
cdef extern from "algorithm_math.h":
     double myFunction (double x)
     double MY_PI

def algorithmStep1(n):
    """Return nth the Fibonacci series number"""
    a, b = 0, 1
    while b < n:
        a, b = b, a + b
    return b
def algorithmStep2(n):
    """Return Simple math op result """
    return MY_PI*myFunction(n) 
def primes(int kmax):
    cdef int n, k, i
    cdef int p[1000]
    result = []
    if kmax > 1000:
        kmax = 1000
    k = 0
    n = 2
    while k < kmax:
        i = 0
        while i < k and n % p[i] != 0:
            i = i + 1
        if i == k:
            p[k] = n
            k = k + 1
            result.append(n)
        n = n + 1
    return result