#include "opencv2/core.hpp"

#include "cbicaCmdParser.h"
#include "cbicaUtilities.h"

#include"TextureFeatures.h"
#include "itkDOMNodeXMLReader.h"
#include "itkDOMNodeXMLWriter.h"
#include <iostream>
#include "itkMacro.h"
#include "itkDOMNode.h".

int main(int argc, char **argv)
{
  auto parser = cbica::CmdParser(argc, argv);

  parser.addRequiredParameter("e", "Extract Features", cbica::Parameter::BOOLEAN, "bool", "for extracting or reding switch");
 
  parser.addRequiredParameter("f", "featureFile", cbica::Parameter::FILE, ".xml or .yml", "Input file containing the feature panel output");
  parser.addOptionalParameter("i", "image", cbica::Parameter::FILE, "0-max range of featureFile", "Image for which features are to be displayed", "Defaults to image '0'");
  parser.addOptionalParameter("m", "mask", cbica::Parameter::FILE, "maski image","feature region","fullpath");
  parser.addOptionalParameter("s", "selectedFeatures", cbica::Parameter::STRING, "see feature panel for available features", "Select the features to display separated by ','", "Defaults to 'min_int,max_int,std,volume,Elongation'");

  if (parser.isPresent("u") || (argc < 2))
  {
    parser.echoUsage();
    return EXIT_SUCCESS;
  }

  if (parser.isPresent("h"))
  {
    parser.echoHelp();
    return EXIT_SUCCESS;
  }

  if (parser.isPresent("v"))
  {
    parser.echoVersion();
    return EXIT_SUCCESS;
  }

  std::string featureFile, image ,mask, selectedFeatures = "min_int,max_int,std,volume,Elongation";
  bool type;

  parser.getParameterValue("f", featureFile);

  if (parser.isPresent("i"))
  {
    parser.getParameterValue("i", image);
  }
  if (parser.isPresent("m"))
  {
    parser.getParameterValue("m", mask);
  }

  if (parser.isPresent("s"))
  {
    parser.getParameterValue("s", selectedFeatures);
  }

  if (parser.isPresent("e"))
  {
    parser.getParameterValue("e", type);
  }

  if (type)
  {
    ImageTypeFloat3D::Pointer imgin = cbica::ReadImage(image);
    ImageTypeFloat3D::Pointer maskin = cbica::ReadImage(mask);
   // extract features from image and mask
    TextureFeatures txF;
    std::vector< std::tuple<std::string, std::string, float>>featurevec;
    typedef itk::VectorContainer< unsigned char, OffsetType > OffsetVector;
    typedef OffsetVector::Pointer  OffsetVectorPointer;
    OffsetType offset;
    typedef itk::Neighborhood< float, 3 > NeighborhoodType;
    NeighborhoodType neighborhood;
    neighborhood.SetRadius(1);
    unsigned int centerIndex = neighborhood.GetCenterNeighborhoodIndex();
    OffsetVectorPointer offsets = OffsetVector::New();
    for (unsigned int d = 0; d < centerIndex; d++)
    {
      offset = neighborhood.GetOffset(d);
      offsets->push_back(offset);
    }

      txF.Intensity_features<ImageTypeFloat3D>(imgin, maskin, &featurevec);

      int tempInterval = std::max(1, static_cast<int>(std::floor((std::get<2>(featurevec.at(1)) - std::get<2>(featurevec.at(0)) / 10))));
     
        txF.HistogramFeatures(txF.nonzero_pix, std::get<2>(featurevec.at(0)), tempInterval, std::get<2>(featurevec.at(1)), &featurevec);
 
        txF.calculateTextureFeatures<ImageTypeFloat3D, OffsetVector>(txF.nonzero_pix, imgin, maskin, std::get<2>(featurevec.at(0)), std::get<2>(featurevec.at(1)), offsets,&featurevec);
    
        txF.calculateRunLength<ImageTypeFloat3D, OffsetVector>(txF.nonzero_pix, imgin, maskin, std::get<2>(featurevec.at(0)), std::get<2>(featurevec.at(1)), offsets, &featurevec);
  
        txF.ShapeFeatures(maskin, &featurevec);

       // txF.CalculateGrayLevelNeighbourhoodGreyLevelDifferenceFeatures<ImageTypeFloat3D>(imgin, maskin, &featurevec);
  
      //  txF.CalculateGrayLevelSizeZoneFeatures<ImageTypeFloat3D>(imgin, maskin, &featurevec);
        itk::DOMNode::Pointer outputdom;
       std:: string t = std::get<0>(featurevec.at(0))
        for (int i=0; i < featurevec.size(); i++){
          itk::DOMNode::Pointer nodelb;
          nodelb->SetName(std::get<0>(featurevec.at(i)));
          nodelb->SetAttribute("attribute",std::get<1>(featurevec.at(i)));
          nodelb->SetAttribute("value",std::to_string(std::get<2>(featurevec.at(0))));
          outputdom->AddChild(nodelb);
        }
        
        itk::DOMNodeXMLWriter::Pointer writer = itk::DOMNodeXMLWriter::New();
        writer->SetInput(outputdom);
        writer->SetFileName(featureFile);
        writer->Update();
    }
   
  }

  

  