/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkTensorReorientImageFilterTest.cxx,v $
  Language:  C++
  Date:      $Date: 2007/01/29 14:42:11 $
  Version:   $Revision: 1.10 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include <iostream>

#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkIndex.h"
#include "itkImage.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkVectorImageWarpFilter.h"
#include "itkVectorCastImageFilter.h"
#include "itkStreamingImageFilter.h"
#include "itkVariableLengthVector.h"
#include "itkCommand.h"
#include "vnl/vnl_math.h"


int main(int, char* [] )
{
  enum { ImageDimension = 2 };
  
  typedef itk::VectorImage<double, ImageDimension> ImageType;

  typedef itk::Vector<float,ImageDimension> VectorType;
  typedef itk::Image<VectorType,ImageDimension> FieldType;

  bool testPassed = true;


  //=============================================================
 std::cout << "Create the Input Tensor Image." << std::endl;
 
  ImageType::SpacingType spacing;
  spacing.Fill( 1.0 );

  ImageType::PointType origin;
  origin.Fill( 0.0 );

  ImageType::RegionType     region;
  ImageType::SizeType       size;
  ImageType::IndexType      start;

  size[0] = 4;
  size[1] = 4;
  

  start[0] = 0;
  start[1] = 0;
  

  region.SetSize( size );
  region.SetIndex( start );
  std::cout<< " Vector Image size: " << size << std::endl;
  ImageType::Pointer image = ImageType::New();

  image->SetOrigin( origin );
  image->SetSpacing( spacing );
  image->SetBufferedRegion( region );
  image->SetLargestPossibleRegion(region);
  image->SetVectorLength(ImageDimension);
  image->Allocate();
   
  
  typedef itk::VariableLengthVector<double> PixelType;
  
 
  PixelType pixelValue(ImageDimension);

  typedef itk::ImageRegionIteratorWithIndex< ImageType > Iterator;
  Iterator it( image, region );
 

 
  it.GoToBegin();
  
  while( !it.IsAtEnd() )
    {
    ImageType::IndexType index = it.GetIndex();
	pixelValue[0] =  2;
	pixelValue[1] =  0;
	

    it.Set( pixelValue );
    ++it;
    }
 

  //=============================================================

  std::cout << "Create the input deformation field." << std::endl;

  unsigned int factors[ImageDimension] = { 1, 1};

  FieldType::RegionType fieldRegion;
  FieldType::SizeType fieldSize;
 
    fieldSize[0] = 3;
    fieldSize[1] = 3;
   
  
  fieldRegion.SetSize( fieldSize );

  FieldType::Pointer field = FieldType::New();
  field->SetLargestPossibleRegion( fieldRegion );
  field->SetBufferedRegion( fieldRegion );
  field->Allocate(); 
 

  typedef itk::ImageRegionIteratorWithIndex<FieldType> FieldIterator;
  FieldIterator fieldIter( field, fieldRegion );

  for( ; !fieldIter.IsAtEnd(); ++fieldIter )
    {
    FieldType::IndexType index = fieldIter.GetIndex();
	VectorType displacement;
	for (int i =0 ; i<2; i++)
	{
	displacement[i] = 0.5*index[i] ;
	}
	
    fieldIter.Set( displacement );
	}



  //=============================================================

  std::cout << "Run VectorImageWarpFilter in standalone mode with progress.";
  std::cout << std::endl;
  
  
  typedef itk::VectorImageWarpFilter<ImageType,ImageType,FieldType> WarpType;  
  
  WarpType::Pointer warper = WarpType::New();
  
  PixelType padValue(ImageDimension); 
  padValue[0] = 0;
  padValue[1] = 0;
  
  
  double spac[3];
  spac[0] = 1; 
  spac[1] = 1;
  
  
  warper->SetInput( image );
  warper->SetDeformationField( field );
  warper->SetOutputSpacing( spac);
  warper->SetOutputOrigin( field->GetOrigin());
  warper->SetEdgePaddingValue( padValue );
  warper->SetVectorLength(image->GetVectorLength());
 
 
  // Update the filter
  try
  {
    warper->Update();
    //warper->UpdateLargestPossibleRegion();
  }
   catch (itk::ExceptionObject & ee)
  {
   std::cerr << "Filter Exception thrown " << std::endl;
   std::cerr << ee << std::endl;
     }
     
     ImageType::Pointer out = warper->GetOutput();
     
     std::cout << out << std::endl;

  //=============================================================


  //=============================================================

 return EXIT_SUCCESS;

}
