#!/bin/bash
ana_id=$1 
dir=(SET the path to subject folder here)

template=(Set path to template folder)
outdir=(output directory where tensors will be saved)

echo $dir
echo $template
bin=(executables directory)

Strip=$bin/MaskDWIFilter
echo "----------"
echo "----------"
echo " Skull strip the nrrd DWI images."
$Strip --inputVolume $dir/DWI_coreg.nhdr --maskVolume $dir/B0_mask.nii --outputVolume $dir/DWI_skull_strip.nhdr

rigid=$bin/DTIRigidRegistration
echo " Starting Rigid Registration"
$rigid --fixedVolume $dir/T1_Resampled_RAS.nrrd --movingVolume $dir/DWI_skull_strip.nhdr --outputVolume $dir/Rigid_Resampled.nrrd --outputTransform $dir/Rigid_Transform.xfm 

def=$bin/itkTransformToDeformation
echo "----------"
echo "----------"
echo " Transform to Deformation field conversion ..."
$def --inputTransform $dir/Rigid_Transform.xfm --fixedVolume $dir/T1_Resampled_RAS.nrrd --outputDeformationField $dir/Rigid_Deformation.mhd


reorient=$bin/itkGradientRotate
echo "----------" 
echo "----------"
echo " Reorient using FS gradient rotate. ..."
$reorient --inputVolume $dir/DWI_skull_strip.nhdr --inputDeformationField $dir/Rigid_Deformation.mhd --outputVolume $dir/Rigid_Rotated_Tensor.nrrd

FA=$bin/itkComputeFA
echo "----------"
echo "----------"
echo " Compute FA......"
$FA --inputVolume $dir/Rigid_Rotated_Tensor.nrrd --outputVolume $dir/Rigid_Rotated_FA.nrrd


affine=$bin/GeneralAffineRegistration
echo "----------"
echo "----------"
echo " Initial Intersubject Registration between T1-weighted data.... "
$affine --fixedVolume $template/T1_Resampled_RAS.nrrd --movingVolume $dir/T1_Resampled_RAS.nrrd --outputTransform $dir/Initial_affine.xfm --outputVolume $dir/T1_Affine_resampled.nrrd


echo "----------"
echo "----------"
echo " Computing deformation fron the affine transform.... "
#$def --inputTransform $dir/Initial_affine.xfm --fixedVolume $template/T1_Resampled_RAS.nrrd --outputDeformationField $dir/Initial_Affine_Deformation.mhd

echo "----------"
echo "----------"
echo " Normalize the T1 image... "
scale=$bin/ScalarImageNormalizationFilter
$scale --inputVolume $dir/T1_Resampled_RAS.nrrd --outputVolume $dir/Normalized_T1.nrrd

echo "----------"
echo "----------"
echo " Normalize the Tensor image... "
tenNorm=$bin/itkTensorNormalizeFilter
$tenNorm --inputVolume $dir/Rigid_Rotated_Tensor.nrrd --outputVolume $dir/Normalized_Tensor.nrrd

histo=$bin/HistogramMatch
echo "----------"
echo "----------"
echo " Histogram Matching between T1-weighted data.... "
$histo --movingVolume $dir/Normalized_T1.nrrd --fixedVolume $template/Normalized_T1.nrrd  --outputVolume $dir/Histogram_T1.nrrd

echo "----------"
echo "----------"
echo " Histogram Matching between FA images... "
$histo --movingVolume $dir/Rigid_Rotated_FA.nrrd --fixedVolume $template/Rigid_Rotated_FA.nrrd --outputVolume $dir/Histogram_FA.nrrd


create=$bin/CreateTensorVectorImage
echo "----------"
echo "----------"
echo " Create Vector Image"
$create --inputVolume $dir/Histogram_T1.nrrd,$dir/Histogram_FA.nrrd  --inputTensorVolume $dir/Normalized_Tensor.nrrd --outputVolume $dir/VectorImage_8para.nrrd

dem=$bin/Tensor_Weighted_Multichannel
dem1=$bin/DemonsRegistration
echo "----------"
echo "----------"
echo "Vector Image Multichannel Registration...."
$dem1 --fixedVolume $template/T1_Resampled_RAS.nrrd --movingVolume $dir/T1_Resampled_RAS.nrrd --inputTransform $dir/Initial_affine.xfm --outputVolume $dir/T1_demons_output.nrrd --outputDeformationField $dir/Middle_Deformation.mhd --iterations 100,50,5 
$dem --fixedVolume $template/VectorImage_8para.nrrd --movingVolume $dir/VectorImage_8para.nrrd --inputDeformationField $dir/Middle_Deformation.mhd --outputVolume $dir/Vector_output_8para.nrrd --outputDeformationField $dir/Final_Deformation.mhd --iterations 10 


conc=$bin/ConcatenateDeformationFields

echo "----------"
echo "----------"
echo "Concatenate Rigid and Demons deformations...."
$conc --inputDeformationField1 $dir/Rigid_Deformation.mhd --inputDeformationField2 $dir/Final_Deformation.mhd --outputDeformationField $dir/Total_Deformation.mhd



echo "----------"
echo "----------"
echo "gradient Reorient using total deformation ....."
$reorient --inputVolume $dir/DWI_skull_strip.nhdr --inputDeformationField $dir/Total_Deformation.mhd --outputVolume $outdir/${ana_id}_Tensor.nrrd





