#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include <iostream>
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include "itkHistogramMatchingImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkDiffusionTensor3D.h"
#include "itkFlipImageFilter.h"
#include "itkImageRegionIterator.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkJoinSeriesImageFilter.h"
#include "ConvertToAnalyzeCLP.h"



int main( int argc, char* argv[] )
{

PARSE_ARGS;
 
  
  std::cout << " Input Tensor Volume (nrrd)" << InputVolume <<std::endl;   
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume1 <<std::endl;
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume2<<std::endl;
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume3 <<std::endl;
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume4 <<std::endl;
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume5 <<std::endl;
  std::cout << " Output Tensor Volume (analyze)" << OutputVolume6<<std::endl;
  
    
  

  typedef float PixelType;
  typedef itk::Vector< float ,6>  TensorPixelType;
  const unsigned int dimension = 3;
  typedef itk::Image<PixelType,3>			SingleImageType;
  typedef itk::Image<TensorPixelType, dimension>        TensorImageType;
  typedef itk::ImageFileReader<TensorImageType>         ReaderType;   
  typedef itk::ImageFileWriter<SingleImageType> 		WriterType;
  
  typedef TensorImageType::IndexType   IndexType;
  
  ReaderType::Pointer reader = ReaderType::New();
  WriterType::Pointer writer = WriterType::New();
  
  reader->SetFileName( InputVolume );
		  
  try
  {
    reader->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  }
  
  TensorImageType::Pointer tensor = reader->GetOutput();
  std::cout << tensor <<std::endl; 
  
  typedef itk::FlipImageFilter< TensorImageType  >  FlipImageFilterType;
  FlipImageFilterType::Pointer flipImageFilter = FlipImageFilterType::New();
  flipImageFilter->SetInput( tensor );
  flipImageFilter->FlipAboutOriginOff();
  FlipImageFilterType::FlipAxesArrayType flipArray;
  flipArray[0] = 0; flipArray[1] =1; flipArray[2] = 1;
  flipImageFilter->SetFlipAxes( flipArray );
  flipImageFilter->Update();
  
  TensorImageType::Pointer flipTens =  flipImageFilter->GetOutput();
  std::cout << flipTens << std::endl;
  
  //ONLY WHEN USING MATLAB
  
 typedef itk::VectorIndexSelectionCastImageFilter< TensorImageType, SingleImageType > SelectFilterType;
  SelectFilterType::Pointer selectFilter = SelectFilterType::New();  
  selectFilter->SetInput(flipTens);
  SingleImageType::Pointer image = SingleImageType::New();
  
  selectFilter->SetIndex(0);
  selectFilter->Update();
  WriterType::Pointer writer0 = WriterType::New();
  writer0->SetFileName( OutputVolume1);
  image = selectFilter->GetOutput();
  writer0->SetInput(image);
  writer0->Update();
  image->DisconnectPipeline();
  
  selectFilter->SetIndex(1);
  selectFilter->Update();
  WriterType::Pointer writer1 = WriterType::New();
  writer1->SetFileName( OutputVolume2);
  image = selectFilter->GetOutput();
  writer1->SetInput(image);
  writer1->Update();
  image->DisconnectPipeline();
  
  selectFilter->SetIndex(2);
  selectFilter->Update();
  WriterType::Pointer writer2 = WriterType::New();
  writer2->SetFileName( OutputVolume3);
  image = selectFilter->GetOutput();
  writer2->SetInput(image);
  writer2->Update();
  image->DisconnectPipeline();
  
  selectFilter->SetIndex(3);
  selectFilter->Update();
  WriterType::Pointer writer3 = WriterType::New();
  writer3->SetFileName( OutputVolume4);
  image = selectFilter->GetOutput();
  writer3->SetInput(image);
  writer3->Update();
  image->DisconnectPipeline();
  
  selectFilter->SetIndex(4);
  selectFilter->Update();
  WriterType::Pointer writer4 = WriterType::New();
  writer4->SetFileName( OutputVolume5);
  writer4->SetInput(selectFilter->GetOutput());
  writer4->Update();
  image->DisconnectPipeline();
  
  selectFilter->SetIndex(5);
  selectFilter->Update();
  WriterType::Pointer writer5 = WriterType::New();
  writer5->SetFileName( OutputVolume6);
  writer5->SetInput(selectFilter->GetOutput());
  writer5->Update();
  image->DisconnectPipeline();
  
  
 
   
  //ONLY WHEN USING ITK FOR CONVERSION
 /* SingleImageType::Pointer single = SingleImageType::New();
  SingleImageType::RegionType region;
  SingleImageType::SizeType size; 
  size[0] = 128*6;
  size[1] = 128;
  size[2] = 128;
  region.SetSize(size);
 
  single->SetSpacing( flipTens->GetSpacing()); 
  single->SetBufferedRegion(region);  
  single->SetOrigin(flipTens->GetOrigin());
  single->SetLargestPossibleRegion(region);
  single->SetDirection(flipTens->GetDirection());
  single->Allocate();
  
 
  typedef itk::ImageRegionIteratorWithIndex<SingleImageType> OutputIteratorType;
  OutputIteratorType outputIt( single, region );
  
  typedef itk::ImageRegionIteratorWithIndex< TensorImageType > IteratorType;
  IteratorType It( flipTens, flipTens->GetRequestedRegion() );
  It.GoToBegin();     
  
  while(! outputIt.IsAtEnd ())
  
  {
  
  for (unsigned int i=0; i<6; i++)
  {
  
  const IndexType index = It.GetIndex();
  PixelType inputPixel = 1000 * It.Get().GetElement(i);
  
  outputIt.Set( inputPixel );
  
  ++outputIt;
  }
  
  ++It;
  }
  
 
  
  writer->SetFileName(OutputVolume);
  writer->SetInput(single);
  std::cout << single << std::endl;
  
  writer->Update();*/
  
  return 0; 
  }
