/******************************************************************

Program: Resample Anatomical Image ( to half the size)
Date: 11/13/07
Author: Madhura A Ingalhalikar

******************************************************************/


#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkResampleImageFilter.h"
#include "itkAffineTransform.h"
#include "itkNearestNeighborInterpolateImageFunction.h"
#include "itkOrientImageFilter.h"
#include "itkSpatialOrientationAdapter.h"
#include "ResampleT1FilterCLP.h"


int main( int argc, char * argv[] )
{
  PARSE_ARGS;
  
  std::cout << "Input Image: " <<  InputImageFilename << std::endl; 
  std::cout << "Output Image: " <<  OutputImageFilename << std::endl; 
 

  const     unsigned int   Dimension = 3;
  typedef   unsigned short  PixelType;

  typedef itk::Image< PixelType,  Dimension >   ImageType;
  typedef itk::Image< PixelType,  Dimension >   OutputImageType;
 
 
  typedef itk::ImageFileReader< ImageType  >  ReaderType;
  typedef itk::ImageFileWriter< OutputImageType >  WriterType;

  ReaderType::Pointer reader = ReaderType::New();
 

  reader->SetFileName( InputImageFilename );
  
  reader->Update();
  
  ImageType::Pointer img = reader->GetOutput();
  std::cout <<img <<std::endl;
  ImageType::SpacingType spac = img->GetSpacing();
  ImageType::PointType origin = img->GetOrigin();
  ImageType::SizeType sz = img->GetRequestedRegion().GetSize();
  
  
 typedef itk::ResampleImageFilter<ImageType,ImageType> FilterType;
  FilterType::Pointer filter = FilterType::New();
   
 //Set Identity transform.
 
  typedef itk::AffineTransform< double, Dimension >  TransformType;
 
  TransformType::Pointer transform = TransformType::New();
  transform->SetIdentity();
  filter->SetTransform( transform );

  typedef itk::NearestNeighborInterpolateImageFunction< 
                       ImageType, double >  InterpolatorType;
 
  InterpolatorType::Pointer interpolator = InterpolatorType::New();
  filter->SetInterpolator( interpolator );
  
  filter->SetDefaultPixelValue( 0 );
 
  double spacing[ Dimension ];
  spacing[0] = spac[0]*2; 
  spacing[1] = spac[1]*2; 
  spacing[2] = spac[2]*2;

  filter->SetOutputSpacing( spacing );
  
  filter->SetOutputOrigin( origin );
  filter->SetOutputDirection(img->GetDirection());
  

  
  ImageType::SizeType   size;

  size[0] = sz[0]/2;  
  size[1] = sz[1]/2;
  size[2] = sz[2]/2;  

  filter->SetSize( size );
 

  filter->SetInput( img );
  
   
   try
    {
    filter->Update();
    }
  catch( itk::ExceptionObject & errr ) 
    { 
    std::cerr << "ExceptionObject caught !" << std::endl; 
    std::cerr << errr << std::endl; 
    throw;
    } 
 
	ImageType::Pointer image = filter->GetOutput();
	 std::cout <<image <<std::endl;

  WriterType::Pointer writer = WriterType::New();	 
  writer->SetFileName( OutputImageFilename );
  writer->SetInput(image );
  
   
   try
    {
    writer->Update();
    }
  catch( itk::ExceptionObject & erro) 
    { 
    std::cerr << "Exception Object caught !" << std::endl; 
    std::cerr << erro << std::endl; 
    throw;
    } 

  
 
 
  

  return EXIT_SUCCESS;
}
