#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include <iostream>
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include "itkShiftScaleImageFilter.h"
#include "itkMinimumMaximumImageFilter.h"
#include "itkImageToVectorImageFilter.h"
#include "itkHistogramMatchingImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkImageToVectorImageFilter.h"
#include "itkImageRegionIterator.h" 
#include "itkImageRegionIteratorWithIndex.h"
#include "itkDiffusionTensor3D.h"
#include "itkTensorNormalizeFilterCLP.h"

int main( int argc, char* argv[] )
{

PARSE_ARGS;
 
  
  std::cout << "Input Tensor Volume " << InputVolume <<std::endl; 
  std::cout << "Output Tensor Volume " << OutputVolume <<std::endl;
  
  typedef itk::DiffusionTensor3D<float>  PixelType;
  typedef itk::Image<PixelType,3>		TensorImageType;
  
   
   typedef itk::VectorImage<float,3>		ImageType;
   typedef itk::Image<float,3>		SingleType;
   typedef itk::ImageFileReader<ImageType>    	ReaderType;
   typedef itk::ImageFileWriter<TensorImageType> 	WriterType;
   
   ReaderType::Pointer reader = ReaderType::New();    
   WriterType::Pointer writer = WriterType::New();
 
 reader->SetFileName( InputVolume);
		  
  try
  {
    reader->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  }
   
  
   ImageType::Pointer image = reader->GetOutput();
  
   typedef itk::VectorIndexSelectionCastImageFilter<ImageType, SingleType> SelectFilterType;
   SelectFilterType::Pointer select = SelectFilterType::New();
   select->SetInput(image);
  
   typedef itk::MinimumMaximumImageFilter<SingleType> MinMaxType;
   MinMaxType::Pointer minmax = MinMaxType::New();
   //std::vector<float> maximum;
  // std::vector<float> minimum;
  float maximum, minimum;
  float max, min;
  
   SingleType::Pointer img;
  
  for (int i=0; i<6; i++)
  {
  
  select->SetIndex(i); 
  select->Update();
 
  minmax->SetInput(select->GetOutput());
  minmax->Update();
  maximum = minmax->GetMaximum();
  minimum = minmax->GetMinimum();
  
  if (i==0)
  {
  max = maximum;
  min = minimum;
  }
 
    if (maximum >= max)
    { 
     max = maximum;
    }
     if (minimum <= min)
    { 
     min = minimum;
    }
 
  
  //maximum.pushback( minmax->GetMaximum());
 // minimum.pushback( minmax->GetMinimum());
  
  img=minmax->GetOutput();
  img->DisconnectPipeline();
  
  }
  
  std::cout << " Max. value is : " << max << std::endl;
  std::cout << " Min. value is : " << min << std::endl;
  
  
 TensorImageType::Pointer tensor = TensorImageType::New();
 TensorImageType::RegionType region;
 region.SetSize(reader->GetOutput()->GetRequestedRegion().GetSize());
 tensor->SetSpacing( reader->GetOutput()->GetSpacing()); 
 tensor->SetBufferedRegion(region);  
 tensor->SetOrigin(reader->GetOutput()->GetOrigin());
 tensor->SetLargestPossibleRegion(region);
 tensor->SetDirection(reader->GetOutput()->GetDirection());
 tensor->Allocate();
 
 typedef itk::ImageRegionIterator< ImageType > IteratorType;
  IteratorType It1( reader->GetOutput(), reader->GetOutput()->GetRequestedRegion() );
 typedef itk::ImageRegionIteratorWithIndex< TensorImageType > OutIteratorType;
  OutIteratorType Ot( tensor, region );
  
  PixelType outTens;
  typedef itk::VariableLengthVector<float> pixType;
  pixType tens(6);
  
    
  for ( It1.GoToBegin(),Ot.GoToBegin(); !Ot.IsAtEnd(); ++Ot, ++It1)
  {
     tens = It1.Get();
     for (int i=0;i<6; i++)
     { 
     outTens[i] = tens[i]/(max-min);
     }
     Ot.Set(outTens);
  }
  
  
  
  std::cout << tensor<< std::endl;
  
  writer->SetFileName(OutputVolume);
  writer->SetInput(tensor );
  writer->Update();
  
  return 0; 
  }
  
  
