/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkCentralDifferenceImageFunctionTest.cxx,v $
  Language:  C++
  Date:      $Date: 2003/09/10 14:30:08 $
  Version:   $Revision: 1.4 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include "itkVectorImageCentralDifferenceFunction.h"
#include "itkVectorImage.h"
#include "itkImageRegionIteratorWithIndex.h"   
#include "itkVariableLengthVector.h"

int main(int, char* [] )
{
   enum { ImageDimension = 2 };
  
  typedef itk::VectorImage<double, ImageDimension> ImageType;
  std::cout << "Create the Input VectorImage." << std::endl;
 
  ImageType::SpacingType spacing;
  spacing.Fill( 1.0 );

  ImageType::PointType origin;
  origin.Fill( 0.0 );

  ImageType::RegionType     region;
  ImageType::SizeType       size;
  ImageType::IndexType      start;

  size[0] = 16;
  size[1] = 16;
  

  start[0] = 0;
  start[1] = 0;
  

  region.SetSize( size );
  region.SetIndex( start );
  std::cout<< " Vector Image size: " << size << std::endl;
  ImageType::Pointer image = ImageType::New();

  image->SetOrigin( origin );
  image->SetSpacing( spacing );
  image->SetBufferedRegion( region );
  image->SetLargestPossibleRegion(region);
  image->SetVectorLength(ImageDimension);
  image->Allocate();
   
  
  typedef itk::VariableLengthVector<double> PixelType;
  
 
  PixelType pixelValue(ImageDimension);

  typedef itk::ImageRegionIteratorWithIndex< ImageType > Iterator;
  Iterator it( image, region );
 
  unsigned int counter = 0;
 
  it.GoToBegin();
  
  while( !it.IsAtEnd() )
    {
    ImageType::IndexType index = it.GetIndex();
	pixelValue[0] =  counter++;
	pixelValue[1] =  counter;
	

    it.Set( pixelValue );
    ++it;
    }
 

  // set up central difference calculator
  typedef float CoordRepType;
  typedef itk::VectorImageCentralDifferenceFunction<ImageType,CoordRepType> FunctionType;
  FunctionType::Pointer function = FunctionType::New();

  function->SetInputImage( image );
  function->SetVectorLength(ImageDimension);

  ImageType::IndexType index;

  // pick an index inside the image
  index.Fill( 8 );
  std::cout << "Index: " << index << " Derivative: ";
  std::cout << function->EvaluateAtIndex( index ) << std::endl;

  if ( function->IsInsideBuffer( index ) )
    {
    std::cout << "Index: " << index << " is inside the BufferedRegion." << std::endl;
    }

  FunctionType::ContinuousIndexType cindex;
  cindex.Fill( 8.0 );
  std::cout << "ContinuousIndex: " << cindex << " Derivative: ";
  std::cout << function->EvaluateAtContinuousIndex( cindex ) << std::endl;
  
  FunctionType::PointType point;
  point.Fill( 8.0 );
  std::cout << "Point: " << cindex << " Derivative: ";
  std::cout << function->Evaluate( point ) << std::endl;
  
 

  // pick an index on the image edge
  index.Fill( 8 );
  index[0] = 15;
  std::cout << "Index: " << index << " Derivative: ";
  std::cout << function->EvaluateAtIndex( index ) << std::endl;

  if ( function->IsInsideBuffer( index ) )
    {
    std::cout << "Index: " << index << " is inside the BufferedRegion." << std::endl;
    }

  cindex.Fill( 8.0 );
  cindex[0] = 15.0;
  std::cout << "ContinuousIndex: " << cindex << " Derivative: ";
  std::cout << function->EvaluateAtContinuousIndex( cindex ) << std::endl;
  
  point.Fill( 8.0 );
  point[0] = 15.0;
  std::cout << "Point: " << cindex << " Derivative: ";
  std::cout << function->Evaluate( point ) << std::endl;


  std::cout << "Test passed." << std::endl;
  return EXIT_SUCCESS;

}
