#ifndef __itkVectorImageLinearInterpolateFunction_h
#define __itkVectorImageLinearInterpolateFunction_h

#include "itkVectorImageInterpolateFunction.h"

namespace itk
{


template <class TInputImage, class TCoordRep = float>
class ITK_EXPORT VectorImageLinearInterpolateFunction : 
  public VectorImageInterpolateFunction<TInputImage,TCoordRep> 
{
public:
  /** Standard class typedefs. */
  typedef VectorImageLinearInterpolateFunction Self;
  typedef VectorImageInterpolateFunction<TInputImage,TCoordRep> Superclass;
  typedef SmartPointer<Self> Pointer;
  typedef SmartPointer<const Self>  ConstPointer;
  
  /** Method for creation through the object factory. */
  itkNewMacro(Self);  

  /** Run-time type information (and related methods). */
  itkTypeMacro(VectorImageLinearInterpolateFunction, 
    VectorImageInterpolateFunction);

  /** InputImageType typedef support. */
  typedef typename Superclass::InputImageType InputImageType;
  typedef typename Superclass::PixelType      PixelType;
  typedef typename Superclass::ValueType      ValueType;
  typedef typename Superclass::RealType       RealType;
    
  /** Grab the vector dimension from the superclass. */
/*  itkStaticConstMacro(Dimension, unsigned int,
                       Superclass::Dimension);*/

  /** Dimension underlying input image. */
  itkStaticConstMacro(ImageDimension, unsigned int,Superclass::ImageDimension);

  /** Index typedef support. */
  typedef typename Superclass::IndexType IndexType;

  /** ContinuousIndex typedef support. */
  typedef typename Superclass::ContinuousIndexType ContinuousIndexType;

  /** Output type is VariableLengthVector<double> */
  typedef typename Superclass::OutputType OutputType;

  /** Evaluate the function at a ContinuousIndex position
   *
   * Returns the linearly interpolated image intensity at a 
   * specified point position. No bounds checking is done.
   * The point is assume to lie within the image buffer.
   *
   * ImageFunction::IsInsideBuffer() can be used to check bounds before
   * calling the method. */
  virtual OutputType EvaluateAtContinuousIndex( 
    const ContinuousIndexType & index ) const;

protected:
  VectorImageLinearInterpolateFunction();
  ~VectorImageLinearInterpolateFunction(){};
  void PrintSelf(std::ostream& os, Indent indent) const;

private:
  VectorImageLinearInterpolateFunction(const Self&); //purposely not implemented
  void operator=(const Self&); //purposely not implemented

  /** Number of neighbors used in the interpolation */
  static const unsigned long  m_Neighbors;  

};

} // end namespace itk

// Define instantiation macro for this template.
#define ITK_TEMPLATE_VectorImageLinearInterpolateFunction(_, EXPORT, x, y) namespace itk { \
  _(2(class EXPORT VectorImageLinearInterpolateFunction< ITK_TEMPLATE_2 x >)) \
  namespace Templates { typedef VectorImageLinearInterpolateFunction< ITK_TEMPLATE_2 x > \
                                                  VectorImageLinearInterpolateFunction##y; } \
  }

#if ITK_TEMPLATE_EXPLICIT
# include "Templates/itkVectorImageLinearInterpolateFunction+-.h"
#endif

#if ITK_TEMPLATE_TXX
# include "itkVectorImageLinearInterpolateFunction.txx"
#endif

#endif
