#include "itkImage.h"
#include "itkVector.h"
#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkVectorLinearInterpolateImageFunction.h"
#include "itkVectorInterpolateImageFunction.h"
#include "itkImageRegionIterator.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkPoint.h"
#include "itkFlipImageFilter.h"
#include "ConcatenateDeformationFieldsCLP.h"



int main( int argc, char *argv[] )
{
  PARSE_ARGS;
  
  std::cout << "DeformationField-1: " <<  DeformationField1Filename << std::endl; 
  std::cout << "DeformationField-2: " <<  DeformationField2Filename << std::endl;
  std::cout << "OutputDeformationField: " <<  DeformationFilename << std::endl;
    
      
  const unsigned int Dimension = 3;
  typedef   double VectorComponentType;
  typedef   itk::Vector< VectorComponentType, Dimension > VectorPixelType;
  typedef   itk::Image< VectorPixelType,  Dimension >   DeformationFieldType;   
  typedef   itk::ImageFileReader< DeformationFieldType >  FieldReaderType;
  typedef   itk::Image<unsigned short, Dimension > ImageType;
  typedef   itk::ImageFileReader< ImageType > ReaderType;
  
   //Read first deformation field
   
  FieldReaderType::Pointer fieldReader1 = FieldReaderType::New();
  fieldReader1->SetFileName(DeformationField1Filename );
   
  try 
    {
     std::cout << " Read field 1 ..." << std::endl;
     fieldReader1->Update();
    
    }
  catch(itk::ExceptionObject & fe)
    {
     std::cout << "Field Exception caught ! " << fe << std::endl;
    }
  
    DeformationFieldType::Pointer deformationField1= fieldReader1->GetOutput();
  
  //Read second deformation field
    
  FieldReaderType::Pointer fieldReader2 = FieldReaderType::New();
  fieldReader2->SetFileName(DeformationField2Filename );
   
  try 
    {
     std::cout << " Read field 2 ... " << std::endl;
     fieldReader2->Update();       
    }
    catch(itk::ExceptionObject & fe)
    {
      std::cout << "Field Exception caught ! " << fe << std::endl;
    }
  
    

  
  DeformationFieldType::Pointer deformationField2 = fieldReader2->GetOutput();
  
  
 //Define Interpolator 
 
typedef double CoordRepType;
typedef itk::VectorLinearInterpolateImageFunction<DeformationFieldType,CoordRepType> InterpolatorType;
InterpolatorType::Pointer interp = InterpolatorType::New();
interp->SetInputImage( deformationField1 );  


 // Define output deformation field
 
 
  DeformationFieldType::Pointer def = DeformationFieldType::New();
  DeformationFieldType::RegionType region;
  region.SetSize(deformationField2->GetRequestedRegion().GetSize());
  
 
  def->SetSpacing(deformationField2->GetSpacing()); 
  def->SetBufferedRegion(region);  
  def->SetOrigin(deformationField2->GetOrigin());
  def->SetLargestPossibleRegion(region);
  def->SetDirection(deformationField2->GetDirection());
  def->Allocate();
 
  //iterator over output image
 
  typedef itk::ImageRegionIteratorWithIndex<DeformationFieldType> OutputIteratorType;
  OutputIteratorType outputIt( def, region );
  
  // iterator over the second deformation field
 
  typedef itk::ImageRegionIterator<DeformationFieldType> FieldIteratorType;
  FieldIteratorType fieldIt(deformationField2, region);
  
  VectorPixelType displacement2;
  DeformationFieldType::IndexType index; 
  typedef itk::Point<double,3> PointType;
  PointType point;
  
   while ( ! outputIt.IsAtEnd() )
   {
     
   index = outputIt.GetIndex();  
    
 
   def->TransformIndexToPhysicalPoint( index, point );
   displacement2 = fieldIt.Get();
   for(int i=0;i<3;i++)
   {
    point[i] += displacement2[i];   
   }
  
       
    if( interp->IsInsideBuffer( point ) )
     {
    
      typedef  InterpolatorType::OutputType OutputType;
      const OutputType displacement1 = interp->Evaluate(point);
       
      VectorPixelType value;
      
      for (int k=0;k<3; k++)
         {
             value[k] = displacement1[k] + displacement2[k];            
         }
	  
      outputIt.Set(value);
     }
     else 
     {
     outputIt.Set(displacement2);
     }
   ++fieldIt;
   ++outputIt;
  }
  
  typedef itk::ImageFileWriter< DeformationFieldType> WriterType;
  WriterType::Pointer writer = WriterType::New();
  writer->SetFileName( DeformationFilename);
  writer->SetInput(def);
  std::cout << " Writing output field ... " << std::endl;
  
  writer->Update();
  
  return 0;
}
 
  
  
  
  
  
  
