#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include <iostream>
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include "itkShiftScaleImageFilter.h"
#include "itkMinimumMaximumImageFilter.h"
#include "itkImageToVectorImageFilter.h"
#include "itkHistogramMatchingImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkDiffusionTensor3D.h"
#include "ScalarImageNormalizationFilterCLP.h"

int main( int argc, char* argv[] )
{

PARSE_ARGS;
 
   std::cout << "Output Volume (nifti/nrrd) " << OutputVolume << std::endl;
   std::cout << "Input Moving Volume " << InputVolume <<std::endl;
  
  typedef float PixelType;
  
   typedef itk::Image<PixelType,3>		ImageType;
   typedef itk::ImageFileReader<ImageType>    	ReaderType;
   typedef itk::ImageFileWriter<ImageType> 	WriterType;
   
   ReaderType::Pointer reader = ReaderType::New();  
   WriterType::Pointer writer = WriterType::New();
 
 reader->SetFileName( InputVolume);
		  
  try
  {
    reader->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  } 
       
  ImageType::Pointer image = reader->GetOutput();
  
  typedef itk::MinimumMaximumImageFilter<ImageType> MinMaxType;
  MinMaxType::Pointer minmax = MinMaxType::New();
  minmax->SetInput(image);
  minmax->Update();
  float max = minmax->GetMaximum();
  float min = minmax->GetMinimum();
 
  float shift = 0.0 - min; 
  float scale = 1/(max-min);

  
  typedef itk::ShiftScaleImageFilter<ImageType, ImageType> FilterType;
  FilterType::Pointer filter = FilterType::New();
  filter->SetInput(image);
  filter->SetShift(shift);
  filter->SetScale(scale);
  filter->Update();
  ImageType::Pointer norm = filter->GetOutput();
     
   
  std::cout << norm << std::endl;
  writer->SetFileName(OutputVolume);  
  writer->SetInput(norm);
  writer->Update();
  
  return 0; 
  }
  
  
