/*==================================================================

Program: Reorient Tensor using D.F
Language: C++
Date: 11/13/2007
Author: Madhura A Ingalhalikar

==================================================================*/

#include <iostream>
#include "itkVector.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkTensorReorientImageFilter.h"
#include "itkTensorLinearInterpolateImageFunction.h"
#include "itkDiffusionTensor3D.h"
#include "itkSymmetricSecondRankTensor.h"
#include "itkFixedArray.h"
#include "itkNumericTraits.h"
#include "TensorReorientCLP.h"


int main( int argc , char *argv[] )
{

  
  PARSE_ARGS;
  
  std::cout << "Input Tensor Image: " <<  InputImageFilename << std::endl; 
  std::cout << "Input Deformation Field: " << DeformationFilename << std::endl;
  std::cout << "Output Tensor Image: " <<  OutputImageFilename << std::endl;
  
  
 
  const     unsigned int   Dimension = 3;

  typedef   float VectorComponentType;
  typedef   itk::Vector< VectorComponentType, Dimension > VectorPixelType;
  typedef   itk::Image< VectorPixelType,  Dimension >   DeformationFieldType;
  
  typedef itk::DiffusionTensor3D<double> PixelType;
  typedef itk::Image<PixelType,Dimension> ImageType;
  
   
  
  typedef   itk::ImageFileReader< ImageType >  ReaderType;
  typedef   itk::ImageFileWriter< ImageType >  WriterType;
  
  
  typedef   itk::ImageFileReader< DeformationFieldType >  FieldReaderType;
  

  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName( InputImageFilename  );
  
  try 
  {
  reader->Update();
  }
  catch(itk::ExceptionObject & e)
  {
    std::cout << "Reader Exception caught ! " << e << std::endl;
  }
  
  FieldReaderType::Pointer fieldReader = FieldReaderType::New();
  fieldReader->SetFileName(DeformationFilename );
   
  try 
  {
   fieldReader->Update();
  }
  catch(itk::ExceptionObject & fe)
  {
    std::cout << "Field Exception caught ! " << fe << std::endl;
  }
  
 
  DeformationFieldType::ConstPointer deformationField = fieldReader->GetOutput();
  

  
 typedef itk::TensorReorientImageFilter< ImageType, 
                                ImageType, 
                                DeformationFieldType  >  FilterType;

  FilterType::Pointer filter = FilterType::New();
 
  typedef itk::TensorLinearInterpolateImageFunction< 
                       ImageType, double >  InterpolatorType;

  InterpolatorType::Pointer interpolator = InterpolatorType::New();
  

  filter->SetInterpolator( interpolator );
  
  double edge[6];
  edge[0] = 0;
  edge[1] = 0;
  edge[2] = 0;
  edge[3] = 0;
  edge[4] = 0;
  edge[5] = 0;
  filter->SetOutputSpacing( deformationField->GetSpacing() );
  filter->SetEdgePaddingValue(edge); 
  filter->SetSize(deformationField->GetRequestedRegion().GetSize());
  filter->SetOutputOrigin(  deformationField->GetOrigin() );
  filter->SetDeformationField( deformationField );   
  filter->SetInput( reader->GetOutput());

  
 
 
  try
  {
  
  std::cout << " Rotating tensors ...."<< std::endl;
  filter->Update();
  
  }
  catch (itk::ExceptionObject & ee)
  {
   std::cerr << "Filter Exception thrown " << std::endl;
   std::cerr << ee << std::endl;
  }

  WriterType::Pointer writer = WriterType::New();
  writer->SetFileName( OutputImageFilename );
  writer->SetInput( filter->GetOutput() );

  
  try
    {
   
    writer->Update();
    }
  catch( itk::ExceptionObject & excp )
    {
    std::cerr << "Writer Exception thrown " << std::endl;
    std::cerr << excp << std::endl;
    }

  return EXIT_SUCCESS;

}
