/*=========================================================================

Program:   Flip the axis of the image. ( Right now flips y. Add options for x and z)
Language:  C++
Author:    Madhura A. Ingalhalikar
Date:      2007/07/11 15:24:18 

=========================================================================*/

#include <iostream>
#include <fstream>

#include <itkImage.h>
#include <metaCommand.h>
#include <itkFlipImageFilter.h>
#include <itkImageFileReader.h>
#include <itkImageFileWriter.h>
#include <itkCommand.h>
#include "itkDiffusionTensor3D.h"
#include "flipImageCLP.h"


int main( int argc, char *argv[] )
{
  
  PARSE_ARGS;
  
  std::cout << "Input Image: " <<  inputImageFilename << std::endl; 
  std::cout << "Output Image: " <<  outputImageFilename << std::endl; 
  std::cout << "Choose Flip axis: " <<  SetImageDir << std::endl; 

  //Instantiate required classes
  
  const    unsigned int    dimension = 3;
  typedef float PixelType; 
 
  typedef itk::Image<PixelType,dimension>             ImageType; 
  
  
  
  // Read Input Image
  
  typedef itk::ImageFileReader< ImageType  > ImageReaderType;
  
  ImageReaderType::Pointer  imageReader  = ImageReaderType::New();
  imageReader->SetFileName(  inputImageFilename );
  imageReader->Update();
  ImageType::Pointer image = imageReader->GetOutput();
  std::cout << image << std::endl;  
  
   
  typedef itk::FlipImageFilter< ImageType  >  FlipImageFilterType;
  FlipImageFilterType::Pointer flipImageFilter = FlipImageFilterType::New();
  flipImageFilter->SetInput( imageReader->GetOutput() );
  flipImageFilter->FlipAboutOriginOff();
  FlipImageFilterType::FlipAxesArrayType flipArray;
  
  flipArray.Fill(0);
  if (SetImageDir == 1) /// flip x
  {
  flipArray[0] = 1;
  flipImageFilter->SetFlipAxes( flipArray );
  flipImageFilter->Update();
  }
  else if (SetImageDir == 2) ////flip y
  {
  flipArray[1] = 1;
  flipImageFilter->SetFlipAxes( flipArray );
  flipImageFilter->Update(); 
  }
  else if ( SetImageDir == 3) ///flip z
  {
  flipArray[2] = 1;
  flipImageFilter->SetFlipAxes( flipArray );
  flipImageFilter->Update();
  }
  //Write flip Image                
  typedef itk::ImageFileWriter< ImageType >  WriterType;
  WriterType::Pointer      writer =  WriterType::New();
  writer->SetFileName( outputImageFilename );
  writer->SetInput( flipImageFilter->GetOutput()   );
  ImageType::Pointer outputImage = flipImageFilter->GetOutput();
  std::cout << outputImage <<std::endl;
  writer->Update();

return 0;
}
