#include "itkNrrdImageIO.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkTensorFractionalAnisotropyImageFilter.h"
#include "itkImageFileWriter.h"
#include "itkDiffusionTensor3D.h"
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include <iostream>
#include "itkVector.h"
#include "itkComputeFACLP.h"


int main( int argc, char *argv[] )
{
   
  PARSE_ARGS;
  
  std::cout << "Input Image: " <<  InputImageFilename << std::endl; 
  std::cout << "Output Image: " <<  OutputImageFilename << std::endl; 
 
  
   const unsigned int Dimension = 3;
   typedef itk::DiffusionTensor3D<double> TensorPixelType;
   typedef itk::Image<TensorPixelType,Dimension> TensorImageType;
   typedef itk::ImageFileReader< TensorImageType >  ReaderType;
   typedef itk::Vector<double,3> EigenValuesType;
   
  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName(  InputImageFilename );
  
  try 
  {
  reader->Update();
  }
  catch(itk::ExceptionObject & e)
  {
    std::cout << "Reader Exception caught ! " << e << std::endl;
  }  
  
  TensorImageType::Pointer tensor = reader->GetOutput();
  
 
  //typedef TensorPixelType::RealValueType                       RealValueType;
  typedef itk::Image< float, Dimension >                 FAImageType;
  
  FAImageType::Pointer output = FAImageType::New();  
  
  output->SetRegions( tensor->GetLargestPossibleRegion() );
  output->SetSpacing( tensor->GetSpacing() );
  output->SetOrigin( tensor->GetOrigin() );
  output->SetDirection( tensor->GetDirection() );
  output->Allocate();
  
  FAImageType::SizeType size = tensor->GetRequestedRegion().GetSize();
  
 // EigenValuesType eig;
  TensorPixelType ten;
  
  //Define Iterator
  typedef itk::ImageRegionIterator< FAImageType > IteratorType;
  typedef itk::ImageRegionConstIterator< TensorImageType > ConstIteratorType;
  ConstIteratorType it( tensor,tensor->GetRequestedRegion() );
  
  IteratorType ot( output, output->GetRequestedRegion() );
//  double sum = 0.0;
//  int count = 0;
  
  for (ot.GoToBegin(),it.GoToBegin(); !ot.IsAtEnd(); ++ot, ++it)
      {
       ten= it.Get( );
       double xx = ten[0];
       double xy = ten[1];
       double xz = ten[2];
       double yy = ten[3];
       double yz = ten[4];
       double zz = ten[5];
       double result;
       
       float isp = ( xx*xx + yy*yy + zz*zz + 2.0*(xy*xy + xz*xz + yz*yz) );
         if (isp > 0.0)
          {
           float I2 = (xx*yy + yy*zz + zz*xx -(xy*xy + xz*xz + yz*yz));
	   result = sqrt(1-(I2/isp));
	  }
	 else 
	  {
	   result = 0.0;
	  }
                  
     /*  ten.ComputeEigenValues( eig );
       double mean=(eig[0]+eig[1]+eig[2])/3;
       double up = sqrt( pow(eig[0]-mean, 2) + pow(eig[1]-mean,2) + pow(eig[2]-mean,2) );
       double bottom = sqrt( pow(eig[0],2) + pow(eig[1],2) + pow(eig[2],2) );	
       double result = sqrt(1.5)*up/bottom;*/	
       if (result > 1.0) result = 1.0;
       //else  if (result <= 0.2) result = 0.0;
     //  else if (result > 0.2) count++;
      // sum += result;
       ot.Set(result);
      }
	
//   std::cout << "Total ="<< sum <<std::endl;   
 //   std::cout << "Count = "<< count<<std::endl;   
//  double average = ( sum/count);
//  std::cout << " Average FA: " << average << std::endl;
   

  // Write the FA image
  //
  typedef itk::ImageFileWriter< FAImageType >  FAWriterType;
  FAWriterType::Pointer faWriter = FAWriterType::New();
  faWriter->SetInput( output );
  faWriter->SetFileName( OutputImageFilename );
  faWriter->Update();
  
  

  
  return 0;
 }
   
