#!/bin/bash

###### Give the path to DTI (dicom dir), T1 ( skull stripped - RPI) , T1 - template (skull stripped - RPI) and a process directory for saving the results. ################

DTI=(Give the path to DTI dicom)
echo $DTI

T1=(Give the path to T1)
echo $T1

### template should be the same for a group study. Choose one of the subjects to be the template ###

template=(Path to template T1 image)
echo $template

Process_Dir=(Path to where the results should be stored)
echo $Process_Dir

Bin= (PAth to executable directory)

###### Start processing DTI data by converting to nrrd and removing motion and eddy current artifacts #######

echo " DTI data convert to nrrd" 
Convert2nrrd=$Bin/DicomToNrrdConverter
$Convert2nrrd --inputDicomDirectory $DTI --outputVolume $ProcessDTI/DTI.nhdr

echo " Co-Reg B Values - DTI " 
coreg=$Bin/gtractCoregBvalues
$coreg --movingVolume $Process_Dir/DTI.nhdr --fixedVolume $Process_Dir/DTI.nhdr --outputVolume $Process_Dir/DTI_CoReg.nhdr

######## At this point check if the orientation and direction cosines of DTI and T1 and T1 template match. If they dont use flipImage on T1 and template #####

##### Registration Steps -  DTI -> rigid -> T1 -> (rigid +Bspline) -> template (T1)##########

echo "Rigid Registration between DTI- b0 and T1 image "
DTIRigid=$Bin/DTIRigidRegistration
$DTIRigid --fixedVolume $T1 --movingVolume $Process_Dir/DTI_CoReg.nhdr --outputTransform $Process_Dir/DTI_T1_rigid.xfm --outputVolume $Process_Dir/DTI_T1_resample_rigid.nrrd

echo " Compute Rigid Deformation Field between DTI and T1" 
TransformToDF=$Bin/TransformToDeformation
$TransformToDF --inputTransform $Process_Dir/DTI_T1_rigid.xfm --fixedVolume $T1 --outputDeformationField $Process_Dir/DTI_T1_rigid_deformation.mhd

echo "Affine Registration between T1 and Template "
DTIRigid=$Bin/GeneralAffineRegistration
$DTIRigid --fixedVolume $template --movingVolume $T1 --outputTransform $Process_Dir/T1_template_affine.xfm --outputVolume $Process_Dir/T1_template_resample_affine.nrrd

echo "Diffeomprohic Demons Registration between T1 and Template "
DTIRigid=$Bin/TensorTransformation/DemonsRegistration
$DTIRigid --fixedVolume $template --movingVolume $T1 --outputTransform $Process_Dir/T1_template_diffeomorphic.xfm --inputTransform $Process_Dir/T1_template_affine.xfm --outputDeformationField $Process_Dir/T1_template_diffeomorphic_deformation.mhd --outputVolume $Process_Dir/T1_template_resample_Bspline.nii

echo " Concatenate deformation between DTI- T1 and T1-template"
conc=$Bin/ConcatenateDeformationFields
$conc --inputDeformationField1 $Process_Dir/DTI_T1_rigid_deformation.mhd --inputDeformationField2 $Process_Dir/T1_template_Bspline_deformation.mhd --outputDeformationField $Process_Dir/Total_rigid_bspline_deformation.mhd

################## Tensor Computation ############

echo " Gaussian Smoothing for DTI - to be comparable to the rotated tensors" 
smooth=~Bin/GaussianDTISmoothing
$smooth --inputVolume $Process_Dir/DTI_CoReg.nhdr --outputVolume $Process_Dir/DTI_Smooth.nhdr --sigma 1.0

echo " Compute original Tensor from Smoothed DTI"
Tensor=$Bin/computeTensor
$Tensor --inputVolume $Process_Dir/DTI_Smooth.nhdr --outputVolume $Process_Dir/Original_Tensor.nrrd

########## Get the tensors reordered after registration using Gradient Rotation #######

echo "Gradient rotation using final deformation field"
GradRot=$Bin/itkGradientRotate
$GradRot --inputVolume $Process_Dir/DTI_CoReg.nhdr --inputDeformationField $Process_Dir/Total_rigid_diffeomorphic_deformation.mhd --outputVolume $Process_Dir/Gradient_Rotated_Tensor.nrrd

######### OR  ---Get the tensors reoriented using Tensor rotation ##########

echo "Tensor rotation using forward deformation"
TenRot=$Bin/TensorReorient
$TenRot --inputVolume $Process_Dir/Original_Tensor.nrrd --inputDeformationField $Process_Dir/Total_rigid_diffeomorphic_deformation.mhd --outputVolume $Process_Dir/Tensor_Rotated_Tensor.nrrd

########## OR Get the tensors reordered after registration using Gradient Rotation and PPD #######

echo "Gradient rotation using final deformation field"
GradRot=$Bin/itkGradientRotatePPD
$GradRot --inputVolume $Process_Dir/DTI_CoReg.nhdr --inputDeformationField $Process_Dir/Total_rigid_diffeomorphic_deformation.mhd --outputVolume $Process_Dir/Gradient_Rotated_Tensor_PPD.nrrd

########## OR Get the tensors reordered using Tensor PPD #######

echo "Gradient rotation using final deformation field"
GradRot=$Bin/TensorReorientPPD
$GradRot --inputVolume $Process_Dir/Original_Tensor.nrrd --inputDeformationField $Process_Dir/Total_rigid_diffeomorphic_deformation.mhd --outputVolume $Process_Dir/Tensor_Rotated_Tensor_PPD.nrrd


