#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include <iostream>
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include "itkShiftScaleImageFilter.h"
#include "itkMinimumMaximumImageFilter.h"
#include "itkImageToVectorImageFilter.h"
#include "itkHistogramMatchingImageFilter.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkDiffusionTensor3D.h"
#include "HistogramMatchCLP.h"

int main( int argc, char* argv[] )
{

PARSE_ARGS;
 
  std::cout << "Output Volume (nifti/nrrd) " << OutputVolume << std::endl;
  std::cout << "Input Fixed Volume " << Fixed <<std::endl; 
  std::cout << "Input Moving Volume " << Moving <<std::endl;
  
  typedef float PixelType;
  
   typedef itk::Image<PixelType,3>		ImageType;
   typedef itk::ImageFileReader<ImageType>    	ReaderType;
   typedef itk::ImageFileWriter<ImageType> 	WriterType;
   
   ReaderType::Pointer reader = ReaderType::New();
   ReaderType::Pointer reader1 = ReaderType::New();
   
  WriterType::Pointer writer = WriterType::New();
 
 reader->SetFileName( Fixed );
		  
  try
  {
    reader->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  }
 
  reader1->SetFileName( Moving );
		  
  try
  {
    reader1->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  }
  
     
  ImageType::Pointer fixed = reader->GetOutput();
  ImageType::Pointer moving = reader1->GetOutput();    
 
  
  typedef itk::HistogramMatchingImageFilter  <ImageType, ImageType> MatchingFilterType;
  MatchingFilterType::Pointer matcher = MatchingFilterType::New();
  matcher->SetInput(moving);
  matcher->SetReferenceImage(fixed);
  matcher->SetNumberOfHistogramLevels( 1024 );
  matcher->SetNumberOfMatchPoints( 7 );
  matcher->ThresholdAtMeanIntensityOn();
  matcher->Update();   
   
  ImageType::Pointer output = matcher->GetOutput();
  std::cout << output << std::endl;
  writer->SetFileName(OutputVolume);  
  writer->SetInput(output);
  writer->Update();
  
  return 0; 
  }
  
  
