/*=========================================================================
  Program:   Dicom2Nrrd
  Module:    $RCSfile: Dicom2Nrrd.cxx,v $
  Language:  C++
  Date:      $Date: 2008/12/4 04:12:59 $
  Version:   
  Author:    Madhura Ingalhalikar and Vincent A. Magnotta

 

  =========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include <vector>
#include <string>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <iomanip>
#include <metaCommand.h>
#include <itkImage.h>
#include <itkVectorImage.h>
#include <itkImageFileReader.h>
#include <itkGDCMImageIO.h>
#include <itkGDCMSeriesFileNames.h>
#include <itkExceptionObject.h>
#include <itkImageFileWriter.h>
#include "itkDwiToVectorImageFilter.h"
#include "itkMatrix.h"
#include <vnl/vnl_matrix.h>
#include "Nifti2NrrdCLP.h"




int main(int argc, char* argv[])
{
  
 PARSE_ARGS;
 
 std::cout << " Nifti File " << niftiFile << std::endl;
 std::cout << "Parameters File " << Parameters << std::endl;
 std::cout << " output nrrd file" <<  outputNrrd<< std::endl;
 std::cout << " Bvalue" << bvalue << std::endl;
 std::cout << " No of Directions including non weighted" << dir  << std::endl;
    
  typedef signed short PixelType;
  const unsigned int dimension = 3;
  typedef itk::Image<PixelType,4>		ImageType;
  typedef ImageType::Pointer			ImagePointer;
//  ImagePointer Image;  
  typedef vnl_matrix< float > TMatrix;
    
    
  typedef signed short VectorPixelType;    
  typedef itk::VectorImage<VectorPixelType,dimension>	NrrdImageType;
  typedef NrrdImageType::Pointer				        NrrdImagePointer;
  NrrdImagePointer DwiImage;
  //NrrdImagePointer Image;
    

  typedef itk::ImageFileReader< NrrdImageType >     ReaderType;
  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName( niftiFile);
			  
  try
  {
    reader->Update();
  }
  catch (itk::ExceptionObject &ex)
  {
    std::cout << ex << std::endl;
    throw;
  }
  
  
  DwiImage	= reader->GetOutput();
  
  
  std::ifstream fin;
  fin.open( Parameters.c_str());
 
   TMatrix temp(dir,6);
   TMatrix directions;
   
        temp.fill(0.0);	 
	directions=temp;
     if ( !fin )
    {  
    std::cout << " No file exists" << std::endl;      
      
    }
    
    
    for (int i=0;i<dir;i++)
      {
      fin >> directions[i][0] >> directions[i][1] >> directions[i][2];
     
      }
   
    fin.close();

    std::cout << "Done!" << std::endl;
   
  itk::MetaDataDictionary meta;

  std::string NrrdValue;
  NrrdValue = "cell";
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_centerings[0]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_centerings[1]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_centerings[2]",NrrdValue);
  NrrdValue = "none";
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_centerings[3]",NrrdValue);

  NrrdValue = "space";
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_kinds[0]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_kinds[1]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_kinds[2]",NrrdValue);
  NrrdValue = "list";
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_kinds[3]",NrrdValue);

  NrrdValue = "mm";
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_space units[0]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_space units[1]",NrrdValue);
  itk::EncapsulateMetaData<std::string>(meta,"NRRD_space units[2]",NrrdValue);

  double spacing = (DwiImage->GetSpacing())[2];
  itk::EncapsulateMetaData<double>(meta,"NRRD_thicknesses[2]",spacing);


  std::vector<std::vector<double> > msrFrame(3);
  for (unsigned int saxi=0; saxi < 3; saxi++)
    {
    msrFrame[saxi].resize(3);
    for (unsigned int saxj=0; saxj < 3; saxj++)
      {
      msrFrame[saxi][saxj] = 0.0;
      }
    }
  msrFrame[0][0] = 1.0; msrFrame[1][1] = 1.0; msrFrame[2][2] = 1.0;
  itk::EncapsulateMetaData<std::vector<std::vector<double> > >(meta,"NRRD_measurement frame",msrFrame);


  NrrdValue = "DWMRI";
  itk::EncapsulateMetaData<std::string>(meta,"modality",NrrdValue);

  char tmpStr[64];
  sprintf(tmpStr,"%18.15lf", bvalue);
  NrrdValue = tmpStr;
  itk::EncapsulateMetaData<std::string>(meta, "DWMRI_b-value", NrrdValue);

  /* We should apply direction cosines to gradient directions if requested by the user */
  for (int i=0;i<dir;i++)
    {
    NrrdValue.clear( );
    
    vnl_vector<double> curGradientDirection(3);
    for (int k=0;k<3;k++)
      {
      curGradientDirection[k] = directions[i][k];
      }

    for (int k=0;k<3;k++)
      {
      sprintf(tmpStr," %18.15lf", curGradientDirection[k]);
      NrrdValue += tmpStr;
      }
    sprintf(tmpStr,"DWMRI_gradient_%04d", i);
    itk::EncapsulateMetaData<std::string>(meta, tmpStr, NrrdValue);
    }

  DwiImage->SetMetaDataDictionary(meta);
 
  
        
 


  

  
  typedef itk::ImageFileWriter<NrrdImageType> WriterType;
  WriterType::Pointer nrrdWriter = WriterType::New();
  nrrdWriter->UseInputMetaDataDictionaryOn();
  nrrdWriter->SetInput( DwiImage );
  nrrdWriter->SetFileName(outputNrrd );
  try
    {
    nrrdWriter->Update();
    }
  catch (itk::ExceptionObject e)
    {
    std::cout << e << std::endl;
    }

  return 0;
}
