/*=========================================================================
  Program:   Get the 3D image from the specified Index
  Language:  C++
  Date:      $Date: 2005/12/11 20:48:40 $
  Version:   $Revision: 1.3 $
  Author:    Vincent A. Magnotta
  =========================================================================*/


#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include <vector>
#include <string>
#include <algorithm>
#include <iostream>

#include <metaCommand.h>
#include <itkImage.h>
#include <itkVectorImage.h>
#include <itkImageFileWriter.h>
#include <itkImageFileReader.h>
#include <itkVectorIndexSelectionCastImageFilter.h>
#include "itkMetaDataObject.h"
#include "itkIOCommon.h"
#include "extractNrrdVectorIndexCLP.h"



int main(int argc, char* argv[])
{  
  
  PARSE_ARGS;
  
  std::cout << "Input Image: " <<  InputImageFilename << std::endl; 
  std::cout << "Output Image: " <<  OutputImageFilename << std::endl; 
  std::cout << "Vector Index: " <<  vectorIndex << std::endl; 
  std::cout << "Set Image Orientation: " <<  setImageDir << std::endl; 
  
  
  typedef double                     PixelType;
  typedef itk::VectorImage<PixelType,3>	    NrrdImageType;
  
    
  typedef itk::ImageFileReader<NrrdImageType>          FileReaderType;
	FileReaderType::Pointer reader = FileReaderType::New();
	reader->SetFileName( InputImageFilename );
	reader->Update();
  
  if (( vectorIndex < 0 ) ||
     ( vectorIndex >= (reader->GetOutput())->GetVectorLength()))
    {
    std::cerr << "Invalid vector image index (" << vectorIndex <<"), valid indexes are 0-" << reader->GetOutput()->GetVectorLength() << std::endl;
    return 1;
    } 
    
    
  typedef itk::Image<PixelType,3>	 IndexImageType;
  typedef itk::VectorIndexSelectionCastImageFilter<NrrdImageType, IndexImageType> VectorSelectFilterType;
  typedef VectorSelectFilterType::Pointer 	VectorSelectFilterPointer;
  
  VectorSelectFilterPointer SelectIndexImageFilter = VectorSelectFilterType::New();
  SelectIndexImageFilter->SetIndex( vectorIndex );
  SelectIndexImageFilter->SetInput( reader->GetOutput() );
  try
    {
    SelectIndexImageFilter->Update();
    }
  catch (itk::ExceptionObject e)
    {
    std::cout << e << std::endl;
    }
  
  /* Hack Required for Certain Output Image Types */
  itk::MetaDataDictionary meta;
  IndexImageType::Pointer indexImage = SelectIndexImageFilter->GetOutput();  
  IndexImageType::DirectionType fixImageDir = indexImage->GetDirection();
  switch ( setImageDir )
    {
    case 1: /* Axial */
      fixImageDir.Fill(0);
      fixImageDir[0][0] = 1; fixImageDir[1][1] = 1; fixImageDir[2][2] = 1;
      indexImage->SetDirection( fixImageDir );
      itk::EncapsulateMetaData
          <itk::SpatialOrientation::ValidCoordinateOrientationFlags>
          (meta, itk::ITK_CoordinateOrientation, itk::SpatialOrientation::ITK_COORDINATE_ORIENTATION_RPI);
      indexImage->SetMetaDataDictionary(meta);
      break;
    case 2: /* Coronal */
      fixImageDir.Fill(0);
      fixImageDir[0][0] = 1; fixImageDir[1][2] = 1; fixImageDir[2][1] = 1;
      indexImage->SetDirection( fixImageDir );
      itk::EncapsulateMetaData
          <itk::SpatialOrientation::ValidCoordinateOrientationFlags>
          (meta, itk::ITK_CoordinateOrientation, itk::SpatialOrientation::ITK_COORDINATE_ORIENTATION_RIP);
      indexImage->SetMetaDataDictionary(meta);
      break;
    case 3: /* Sagittal */
      fixImageDir.Fill(0);
      fixImageDir[0][2] = 1; fixImageDir[1][1] = 1; fixImageDir[2][0] = 1;
      indexImage->SetDirection( fixImageDir );
      itk::EncapsulateMetaData
          <itk::SpatialOrientation::ValidCoordinateOrientationFlags>
          (meta, itk::ITK_CoordinateOrientation, itk::SpatialOrientation::ITK_COORDINATE_ORIENTATION_PIR);
      indexImage->SetMetaDataDictionary(meta);
      break;
    }
  
          
  typedef itk::ImageFileWriter<IndexImageType > WriterType;
  WriterType::Pointer imageWriter = WriterType::New();
  imageWriter->SetInput( indexImage );
  std::cout << indexImage << std::endl;
  imageWriter->SetFileName( OutputImageFilename );
  
  try
    {
    imageWriter->Update();
    }
  catch (itk::ExceptionObject e)
    {
    std::cout << e << std::endl;
    }

    return 0;
}


