#include "itkNrrdImageIO.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkTensorFractionalAnisotropyImageFilter.h"
#include "itkImageFileWriter.h"
#include "itkDiffusionTensor3D.h"
#include "itkImageRegionConstIterator.h"
#include "itkImageRegionIterator.h"
#include "itkMaskImageFilter.h"
#include <iostream>
#include "itkVector.h"
#include "vnl/vnl_math.h"
#include "vnl/vnl_matrix.h"
#include "itkComputeGACLP.h"


int main( int argc, char *argv[] )
{
   
  PARSE_ARGS;
  
  std::cout << "Input Image: " <<  InputImageFilename << std::endl; 
 // std::cout << "Mask Image: " <<  MaskImageFilename << std::endl; 
  std::cout << "Output Image: " <<  OutputImageFilename << std::endl; 
 
  
   const unsigned int Dimension = 3;
   typedef itk::DiffusionTensor3D<float> TensorPixelType;
   typedef itk::Image<TensorPixelType,Dimension> TensorImageType;
   typedef itk::ImageFileReader< TensorImageType >  ReaderType;
   typedef itk::Vector<float,3> VectorType;
   typedef itk::Matrix<float,3,3>  MatrixType;    
   typedef MatrixType::InternalMatrixType vnlMatrixType;
   
  
  ReaderType::Pointer reader = ReaderType::New();
  reader->SetFileName(  InputImageFilename );
  
  try 
  {
  reader->Update();
  }
  catch(itk::ExceptionObject & e)
  {
    std::cout << "Reader Exception caught ! " << e << std::endl;
  }  
  
  TensorImageType::Pointer tensor = reader->GetOutput();
  std::cout << tensor << std::endl;
  
 
  typedef itk::Image< float, Dimension >                 GAImageType;
  
  GAImageType::Pointer output = GAImageType::New();  
  
  output->SetRegions( tensor->GetLargestPossibleRegion() );
  output->SetSpacing( tensor->GetSpacing() );
  output->SetOrigin( tensor->GetOrigin() );
  output->SetDirection( tensor->GetDirection() );
  output->Allocate();
  
  GAImageType::SizeType size = tensor->GetRequestedRegion().GetSize();
  
  VectorType eig;
  TensorPixelType ten;
  MatrixType iden;
     
  
  //Define Iterator
  typedef itk::ImageRegionIterator< GAImageType > IteratorType;
  typedef itk::ImageRegionConstIterator< TensorImageType > ConstIteratorType;
  ConstIteratorType it( tensor,tensor->GetRequestedRegion() );
  
   IteratorType ot( output, output->GetRequestedRegion() );

   MatrixType D;
   MatrixType logs;
   MatrixType term2;
   MatrixType term, term3;
   TensorPixelType logtens;
      
   float trace, GA;
   typedef  TensorPixelType::RealValueType  RealValueType;
   typedef  TensorPixelType::EigenVectorsMatrixType EigenVectorsType;
   typedef  TensorPixelType::EigenValuesArrayType EigenValuesType;
   EigenVectorsType mat;
   EigenValuesType e;
   EigenVectorsType mat2;
   EigenValuesType e2;
  
  for (ot.GoToBegin(),it.GoToBegin(); !ot.IsAtEnd(); ++ot, ++it)
      {
       ten= it.Get( ); 
       ten.ComputeEigenAnalysis(e,mat);
	
	 for(int i=0;i<3; i++)
	 {
	   if (e[i] > 0)
	   eig[i] = log(e[i]);    
	   else eig[i] =0.00001;
	
	 }
	 
	trace = (eig[0] +eig[1] + eig[2])/3; 
	 
	iden.SetIdentity();	
	 	  
       D(0,0) = eig[0];  D(0,1) = 0.0;  D(0,2) = 0.0;
       D(1,0) = 0.0;  D(1,1) = eig[1];  D(1,2) = 0.0;
       D(2,0) = 0.0;  D(2,1) = 0.0;  D(2,2) = eig[2];
       
       
       term = mat.GetTranspose();
       logs = term * D * mat;
       
       for(int j=0; j<3; j++)
       {
         for(int k=0;k<3;k++)
	 { 
	 term3(j,k) = trace * iden(j,k);
	 }
       }
        
       term2 = (logs-term3) * (logs-term3);
       
       logtens[0] = term2(0,0);   logtens[1] = term2(0,1);  logtens[2] = term2(0,2);
       logtens[3] = term2(1,1);   logtens[4] = term2(1,2);  logtens[5] = term2(2,2);
       
       
       logtens.ComputeEigenAnalysis(e2,mat2);
       
       // Remvoe tanh if GA required to be unbounded. 
       
       GA = tanh(sqrt(e2[0]+e2[1]+e2[2]));  
              
       ot.Set(GA);
      }
	
 
  

  // Write the FA image
  //
  typedef itk::ImageFileWriter< GAImageType >  GAWriterType;
  GAWriterType::Pointer gaWriter = GAWriterType::New();
  gaWriter->SetInput( output);
  gaWriter->SetFileName( OutputImageFilename );
  gaWriter->Update();
  
  

  
  return 0;
 }
   
