#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkTransformFileReader.h"
#include "itkTransformToDeformationFieldFilter.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkTransformToDeformationCLP.h"

int main( int argc, char *argv[] )
{
   PARSE_ARGS;
   
  std::cout << "Input Transform Filename: " << inputTransform << std::endl;
  std::cout << "Input Fixed Image: " << fixedImage << std::endl;
  std::cout << "Output Deformation Field: " << outputDeformationField <<std::endl;
  
 typedef float PixelType;
 typedef itk::Image<PixelType, 3> ImageType;
 typedef itk::Vector< PixelType, 3 >    VectorPixelType;
 typedef itk::Image< VectorPixelType, 3 > DeformationFieldType;
 
 typedef itk::TransformFileReader TransformReaderType;
 typedef itk::ImageFileReader< ImageType > ReaderType;
 
 ReaderType::Pointer reader = ReaderType::New();
 reader->SetFileName( fixedImage);
 reader->Update();
 
 
 
 
 TransformReaderType::Pointer transformReader = TransformReaderType::New(); 
   transformReader->SetFileName(  inputTransform );
      
      
      try
      {
         std::cout << " Reading Transform ....." << std::endl;
	 transformReader->Update();
	 
      }
      catch( itk::ExceptionObject& err )
      {
         std::cout << "Could not read the input transform." << std::endl;
         std::cout << err << std::endl;
         exit( EXIT_FAILURE );
      }
      
 typedef TransformReaderType::TransformType BaseTransformType;
 BaseTransformType* baseTrsf(0);
 const TransformReaderType::TransformListType* trsflistptr = transformReader->GetTransformList();
 
      if ( trsflistptr->empty() )
      {
         std::cout << "Could not read the input transform." << std::endl;
         exit( EXIT_FAILURE );
      }
      else if (trsflistptr->size()>1 )
      {
         std::cout << "The input transform file contains more than one transform, we use the first one." << std::endl;
         exit( EXIT_FAILURE );
      }

      baseTrsf = trsflistptr->front();
      if ( !baseTrsf )
      {
         std::cout << "Could not read the input transform." << std::endl;
         exit( EXIT_FAILURE );
      }
      
 typedef itk::TransformToDeformationFieldFilter <DeformationFieldType> FieldGeneratorType;
 typedef FieldGeneratorType::TransformType TransformType;

      TransformType* trsf = dynamic_cast<TransformType*>(baseTrsf);
      if ( !trsf )
      {
         std::cout << "Could not cast input transform to a usable transform." << std::endl;
         exit( EXIT_FAILURE );
      }

      FieldGeneratorType::Pointer fieldGenerator = FieldGeneratorType::New();
      fieldGenerator->SetTransform( trsf );
      fieldGenerator->SetOutputRegion( reader->GetOutput()->GetRequestedRegion());
      fieldGenerator->SetOutputSpacing(reader->GetOutput()->GetSpacing());
      fieldGenerator->SetOutputOrigin( reader->GetOutput()->GetOrigin());
      fieldGenerator->SetOutputDirection(reader->GetOutput()->GetDirection());

      // Update the fieldGenerator
      try
      {
         fieldGenerator->Update();
      }
      catch( itk::ExceptionObject& err )
      {
         std::cout << "Could not generate the input field." << std::endl;
         std::cout << err << std::endl;
         exit( EXIT_FAILURE );
      }

     DeformationFieldType::Pointer inputDefField = fieldGenerator->GetOutput();
     
     typedef itk::ImageFileWriter<DeformationFieldType>  WriterType;
     
     WriterType::Pointer writer = WriterType::New();
     writer->SetInput( inputDefField);
     writer->SetFileName( outputDeformationField);
     writer->Update();
     
     return 0;
     
   }
      
