/*=========================================================================

  Program:   Insight Segmentation & Registration Toolkit
  Module:    $RCSfile: itkTensorReorientImageFilterTest.cxx,v $
  Language:  C++
  Date:      $Date: 2007/01/29 14:42:11 $
  Version:   $Revision: 1.10 $

  Copyright (c) Insight Software Consortium. All rights reserved.
  See ITKCopyright.txt or http://www.itk.org/HTML/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#if defined(_MSC_VER)
#pragma warning ( disable : 4786 )
#endif

#include <iostream>

#include "itkVector.h"
#include "itkIndex.h"
#include "itkImage.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkTensorReorientImageFilter.h"
#include "itkVectorCastImageFilter.h"
#include "itkStreamingImageFilter.h"
#include "itkCommand.h"
#include "vnl/vnl_math.h"


int main(int, char* [] )
{
  enum { ImageDimension = 3 };
  typedef itk::DiffusionTensor3D<double> PixelType;
  typedef itk::Image<PixelType,ImageDimension> ImageType;

  typedef itk::Vector<float,ImageDimension> VectorType;
  typedef itk::Image<VectorType,ImageDimension> FieldType;

  bool testPassed = true;


  //=============================================================
 std::cout << "Create the Input Tensor Image." << std::endl;
 
  ImageType::SpacingType spacing;
  spacing.Fill( 1.0 );

  ImageType::PointType origin;
  origin.Fill( 0.0 );

  ImageType::RegionType     region;
  ImageType::SizeType       size;
  ImageType::IndexType      start;

  size[0] = 4;
  size[1] = 2;
  size[2] = 4;

  start[0] = 0;
  start[1] = 0;
  start[2] = 0;

  region.SetSize( size );
  region.SetIndex( start );
  std::cout<< " Tensor Image size: " << size << std::endl;
  ImageType::Pointer image = ImageType::New();

  image->SetOrigin( origin );
  image->SetSpacing( spacing );
  image->SetBufferedRegion( region );
  image->SetLargestPossibleRegion(region);
  image->Allocate();

  PixelType pixelValue;

  typedef itk::ImageRegionIteratorWithIndex< ImageType > Iterator;
  Iterator it( image, region );

  // Fill the image with some constant tensor
  it.GoToBegin();
  while( !it.IsAtEnd() )
    {
    ImageType::IndexType index = it.GetIndex();
	pixelValue[0] =  2;
	pixelValue[1] =  0;
	pixelValue[2] =  0;
	pixelValue[3] =  1;
	pixelValue[4] =  0;
	pixelValue[5] =  1;

	

    it.Set( pixelValue );
    ++it;
    }


  //=============================================================

  std::cout << "Create the input deformation field." << std::endl;

  unsigned int factors[ImageDimension] = { 1, 1, 1 };

  FieldType::RegionType fieldRegion;
  FieldType::SizeType fieldSize;
 // for(unsigned int j = 0; j < ImageDimension; j++ )
   // {
    fieldSize[0] = 3;
    fieldSize[1] = 4;
    fieldSize[2] = 3;
    //}
  fieldRegion.SetSize( fieldSize );
 // std::cout << "Deformation field size: "<< fieldSize << std::endl;

  FieldType::Pointer field = FieldType::New();
  field->SetLargestPossibleRegion( fieldRegion );
  field->SetBufferedRegion( fieldRegion );
  field->Allocate(); 
  
  FieldType::Pointer invField = FieldType::New();
  invField->SetRequestedRegion( region );
 // invField->SetBufferedRegion( region );
  invField->Allocate(); 

  typedef itk::ImageRegionIteratorWithIndex<FieldType> FieldIterator;
  FieldIterator fieldIter( field, fieldRegion );

  for( ; !fieldIter.IsAtEnd(); ++fieldIter )
    {
    FieldType::IndexType index = fieldIter.GetIndex();
	VectorType displacement;
	for (int i =0 ; i<3; i++)
	{
	displacement[i] = 0.5*index[i] ;
	}
	/*if (index[0]== 0 && index[1] ==1 && index[2]==1)
	{ 
		displacement[0] = 5;
		displacement[1] = 1; 
		displacement[2] = 5;
	}

	else if (index[0]== 2 && index[1] ==1 && index[2]==1)
	{ 
		displacement[0] = 1;
		displacement[1] = 1; 
		displacement[2] = 1;
	}

	else if (index[0]== 1 && index[1] ==1 && index[2]==0)
	{ 
		displacement[0] = 3;
		displacement[1] = 3; 
		displacement[2] = 3;
	}

	else if (index[0]== 1 && index[1] ==1 && index[2]==2)
	{ 
		displacement[0] = 1;
		displacement[1] = 1; 
		displacement[2] = 1;
	}

	else if (index[0]== 1 && index[1] ==0 && index[2]==1)
	{ 
		displacement[0] = 4;
		displacement[1] = 4; 
		displacement[2] = 4;
	}

	else if (index[0]== 1 && index[1] ==2 && index[2]==1)
	{ 
		displacement[0] = 1;
		displacement[1] = 1; 
		displacement[2] = 1;
	}


	else
	{

   
	    for(unsigned int j = 0; j < ImageDimension; j++ )
      {
      displacement[j] = 0; //* ( (1.0 / factors[j]) - 1.0 );
      }
	}*/
    fieldIter.Set( displacement );
	}


FieldIterator invfieldIter( invField, region );

  for( ; !invfieldIter.IsAtEnd(); ++invfieldIter )
    {
    FieldType::IndexType invIndex = invfieldIter.GetIndex();
	VectorType invDisplacement;
	for (int i =0 ; i<3; i++)
	{	
        invDisplacement[i]= -(0.5*invIndex[i]);
	}
    invfieldIter.Set( invDisplacement );
    } 
    
    std::cout << "Inverse Field Size" <<invField->GetRequestedRegion().GetSize() <<std::endl;
  //=============================================================

  std::cout << "Run TensorReorientImageFilter in standalone mode with progress.";
  std::cout << std::endl;
  typedef itk::TensorReorientImageFilter<ImageType,ImageType,FieldType> TensorReorienterType;
  TensorReorienterType::Pointer TensorReorienter = TensorReorienterType::New();

  ImageType::PixelType padValue; 
  padValue[0] = 0;
  padValue[1] = 0;
  padValue[2] = 0;
  padValue[3] = 0;
  padValue[4] = 0;
  padValue[5] = 0;
  
  ImageType::SizeType newSize;
  
  newSize[0] = 3;
  newSize[1] = 4;
  newSize[2] = 3;
  double spac[3];
  spac[0] = 1; 
  spac[1] = 1;
  spac[2] = 1;
  

  TensorReorienter->SetInput( image );
  TensorReorienter->SetDeformationField( field );
//  TensorReorienter->SetInvDeformationField(field);
  TensorReorienter->SetOutputSpacing( spac);
  TensorReorienter->SetOutputOrigin( field->GetOrigin());
  TensorReorienter->SetSize(newSize);
  TensorReorienter->SetEdgePaddingValue( padValue );

  // exercise Get methods
 // std::cout << "Interpolator: " << TensorReorienter->GetInterpolator() << std::endl;
//  std::cout << "DeformationField: " << TensorReorienter->GetDeformationField() << std::endl;
 // std::cout << "EdgePaddingValue: " << TensorReorienter->GetEdgePaddingValue() << std::endl;

  // exercise Set methods
  itk::FixedArray<double,ImageDimension> array;
  array.Fill( 2.0 );
  TensorReorienter->SetOutputSpacing( array.GetDataPointer() );
  array.Fill( 1.0 );
  TensorReorienter->SetOutputSpacing( array.GetDataPointer() );

  array.Fill( -10.0 );
  TensorReorienter->SetOutputOrigin( array.GetDataPointer() );
  array.Fill( 0.0 );
  TensorReorienter->SetOutputOrigin( array.GetDataPointer() );
 
  // Update the filter
  try
  {
    TensorReorienter->Update();
    TensorReorienter->UpdateLargestPossibleRegion();
   }
   catch (itk::ExceptionObject & ee)
  {
   std::cerr << "Filter Exception thrown " << std::endl;
   std::cerr << ee << std::endl;
  }

  //=============================================================


  //=============================================================

 return EXIT_SUCCESS;

}
