#ifndef __itkVectorImageCentralDifferenceFunction_txx
#define __itkVectorImageCentralDifferenceFunction_txx

#include "itkVectorImageCentralDifferenceFunction.h"

namespace itk
{


/**
 * Constructor
 */
template <class TInputImage, class TCoordRep>
VectorImageCentralDifferenceFunction<TInputImage,TCoordRep>
::VectorImageCentralDifferenceFunction()
{

m_VectorLength = 1;
}


/**
 *
 */
template <class TInputImage, class TCoordRep>
void
VectorImageCentralDifferenceFunction<TInputImage,TCoordRep>
::PrintSelf(std::ostream& os, Indent indent) const
{
  this->Superclass::PrintSelf(os,indent);
}


/**
 *
 */
template <class TInputImage, class TCoordRep>
typename VectorImageCentralDifferenceFunction<TInputImage,TCoordRep>::OutputType
VectorImageCentralDifferenceFunction<TInputImage,TCoordRep>
::EvaluateAtIndex( const IndexType& index ) const
{
  
 MatrixType derivative(m_VectorLength, TInputImage::ImageDimension);
  derivative.Fill( 0.0 );
  
  IndexType neighIndex = index;
  InputPixelType pix(m_VectorLength);

  const typename InputImageType::SizeType& size =
    this->GetInputImage()->GetBufferedRegion().GetSize();
  const typename InputImageType::IndexType& start =
    this->GetInputImage()->GetBufferedRegion().GetIndex();

  for ( unsigned int dim = 0; dim < TInputImage::ImageDimension; dim++ )
    {
    // bounds checking
    if( index[dim] < static_cast<long>(start[dim]) + 1 ||
        index[dim] > (start[dim] + static_cast<long>(size[dim]) - 2 ) )
      {
      for ( int vdim=0; vdim<m_VectorLength; ++vdim)
        {
        derivative(vdim,dim) = 0.0;
        }
      continue;
      }
    
    // compute derivative
    neighIndex[dim] += 1;
    pix = this->GetInputImage()->GetPixel( neighIndex );
    for (int vdim=0; vdim<m_VectorLength; ++vdim)
      {
      derivative(vdim,dim) = pix[vdim];
      }

    neighIndex[dim] -= 2;
    pix = this->GetInputImage()->GetPixel( neighIndex );
    for ( int vdim=0; vdim<m_VectorLength; ++vdim)
      {
      derivative(vdim,dim) -= pix[vdim];
      }

    for ( int vdim=0; vdim<m_VectorLength; ++vdim)
      {
      derivative(vdim,dim) *= 0.5 / this->GetInputImage()->GetSpacing()[dim];
      }
    neighIndex[dim] += 1;
    }

  return ( derivative );

}


} // end namespace itk

#endif
