/*--------------------------------------------------------
----------------------------------------------------------
This program creates a vector image from n number of scalar 
images and a tensor image. Please define the number of channels 
and set the input images. The code has been designed such that 
the vector image created will look like:
scalar 1
scalar 2
  .
  .
scalar n
tensor comp 1
   .
   .
tensor comp 6


Author: Madhura A. Ingalhalikar
University of Iowa, Iowa City IA. 
---------------------------------------------------------
----------------------------------------------------------*/
#include "itkImageFileWriter.h"
#include "itkImageFileReader.h"
#include "itkImage.h"
#include "itkVector.h"
#include "itkVectorImage.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include <iostream>
#include "itkImageToVectorImageFilter.h"
#include "CreateTensorVectorImageCLP.h"



int main( int argc, char* argv[] )
{

PARSE_ARGS;


  std::cout << " Input Scalar Images (e.g. T1,FA etc): " << InputVolume.size() << std::endl;
  std::cout << " Input Tensor Image : " << TensorVolume << std::endl;
  std::cout << " Output Vector Image: "<< OutputVolume << std::endl;
 
  
  typedef float PixelType;
  const unsigned int dimension = 3;
  typedef itk::Image<PixelType,dimension>		ImageType;
  typedef itk::VectorImage<PixelType, dimension> 	VectorImageType;
  typedef itk::ImageFileReader<ImageType>    		ReaderType;
  typedef itk::ImageFileReader<VectorImageType>    		TensorReaderType;
  typedef itk::ImageFileWriter<VectorImageType> 	WriterType;
 
  

  ReaderType::Pointer reader = ReaderType::New();
  WriterType::Pointer writer = WriterType::New();
  
  typedef itk::ImageToVectorImageFilter<ImageType> VecFilterType;
  VecFilterType::Pointer vecFilter = VecFilterType::New();
  
  ImageType::Pointer image = ImageType::New();
  unsigned int length = InputVolume.size();
  
  TensorReaderType::Pointer read = TensorReaderType::New();
  read->SetFileName(TensorVolume );
  std::cout << " Reading tensor image" << std::endl;
  read->Update();
  
  typedef itk::VectorIndexSelectionCastImageFilter<VectorImageType, ImageType> VectorSelectFilterType;
  typedef VectorSelectFilterType::Pointer 	VectorSelectFilterPointer;
  
  VectorSelectFilterPointer SelectIndexImageFilter = VectorSelectFilterType::New();
  SelectIndexImageFilter->SetInput( read->GetOutput() );
  ImageType::Pointer img = ImageType::New();
 
 for (unsigned int i= 0; i<length; i++)
 { 
 
   reader->SetFileName(InputVolume[i] );
  
		  
 	 try
  	{
    	reader->Update();
  	}
 	 catch (itk::ExceptionObject &ex)
  	{
   	 std::cout << ex << std::endl;
   	 throw;
 	}
  
  image = reader->GetOutput(); 
  vecFilter->SetNthInput( i, image );   
   std::cout << "Adiing Volume .... "<< InputVolume[i] << std::endl;
  image->DisconnectPipeline();
  }
  
  for (unsigned int j= 0; j<6; j++)
  {
   SelectIndexImageFilter->SetIndex(j);
   SelectIndexImageFilter->Update();
   img = SelectIndexImageFilter->GetOutput();
   vecFilter->SetNthInput( length+j ,img  ); 
    std::cout << "Adding tensor component ....: "<< j << std::endl; 
   img->DisconnectPipeline();
  } 
  
  vecFilter->Update();
 
  VectorImageType::Pointer vectorImage = vecFilter->GetOutput();
  std::cout << vectorImage <<std::endl; 
  std::cout  << "Writing out vector image.. " << std::endl ;
  writer->SetFileName( OutputVolume );
  writer->SetInput(vectorImage);
    
    try
      {
      writer->Update();
      
      }
    catch (itk::ExceptionObject &ex)
      {
      std::cout << ex;
      return EXIT_FAILURE;
      }
  
   

  return EXIT_SUCCESS;

}
