#include "fRecurrenceDialog.h"
#include "fProgressDialog.h"

fRecurrenceDialog::fRecurrenceDialog()
{
  this->setWindowTitle("Glioblastoma Infiltration Index");
  //TBD read this from common place 
  setupUi(this);
  this->setWindowModality(Qt::NonModal);
  mode = -1;
  connect(cancelButton, SIGNAL(clicked()), this, SLOT(CancelButtonPressed()));
  connect(confirmButton, SIGNAL(clicked()), this, SLOT(ConfirmButtonPressed()));
  connect(existingMasksButton, SIGNAL(clicked()), this, SLOT(OpenExistingMasksDirectory()));
  connect(svmModelButton, SIGNAL(clicked()), this, SLOT(OpenSVMModelFile()));
  connect(testSubjectsDirectoryButton, SIGNAL(clicked()), this, SLOT(OpenTestSubjectsDirectory()));
  connect(outputDirectoryButton, SIGNAL(clicked()), this, SLOT(SelectOutputDirectory()));
  connect(rdExistingClassification, SIGNAL(toggled(bool)), this, SLOT(ExistingClassificationRadioButtonChecked()));
  connect(rdCreateModel, SIGNAL(toggled(bool)), this, SLOT(NewModelRadioButtonChecked()));

  rdNewClassification->setChecked(true);
  rdExistingClassification->setChecked(false);
  svmModelButton->setEnabled(false);
  svmModelFileName->setEnabled(false);
  testSubjectsDirectoryButton->setEnabled(false);
  testSubjectsDirectoryName->setEnabled(false);
  
  existingMaskDirectoryName->setEnabled(false);
  existingMasksButton->setEnabled(false);
}
fRecurrenceDialog::~fRecurrenceDialog()
{
}
void fRecurrenceDialog::CancelButtonPressed()
{
  this->close();
}
void fRecurrenceDialog::ConfirmButtonPressed()
{
  if (rdNewClassification->isChecked())
  {
    emit SubjectBasedRecurrenceEstimate(outputDirectoryName->text().toStdString(), cbT1Data->isChecked(), cbT1ceData->isChecked(), cbT2Data->isChecked(), cbT2FlairData->isChecked(), cbDTIData->isChecked(), cbPerfData->isChecked(), cbDistanceData->isChecked());
    this->close();
  }
  else if (rdExistingClassification->isChecked())
  {
    if (svmModelFileName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the directory of SVM model.");
      return;
    }
    if (testSubjectsDirectoryName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the directory of test subjects.");
      return;
    }
    if (outputDirectoryName->text().toStdString() == "")
    {
      ShowErrorMessage("Please specify the output directory.");
      return;
    }
    if (!cbT1Data->isChecked() && !cbT1ceData->isChecked() && !cbT2Data->isChecked() && !cbT2Data->isChecked() && !cbDTIData->isChecked() && !cbPerfData->isChecked() && !cbDistanceData->isChecked())
    {
      ShowErrorMessage("Please specify the required modalities.");
      return;
    }
    emit ExistingModelBasedRecurrenceEstimate(svmModelFileName->text().toStdString(), testSubjectsDirectoryName->text().toStdString(), outputDirectoryName->text().toStdString(), cbT1Data->isChecked(), cbT1ceData->isChecked(), cbT2Data->isChecked(), cbT2FlairData->isChecked(), cbDTIData->isChecked(), cbPerfData->isChecked(), cbDistanceData->isChecked());
  }
  else
    emit TrainNewModel(existingMaskDirectoryName->text().toStdString(), outputDirectoryName->text().toStdString(), cbT1Data->isChecked(), cbT1ceData->isChecked(), cbT2Data->isChecked(), cbT2FlairData->isChecked(), cbDTIData->isChecked(), cbPerfData->isChecked(), cbDistanceData->isChecked());
  this->close();
}

void fRecurrenceDialog::OpenSVMModelFile()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"),QString(mInputPathName.c_str()), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    svmModelFileName->setText(directory);
}

void fRecurrenceDialog::OpenExistingMasksDirectory()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), QString(mInputPathName.c_str()), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    existingMaskDirectoryName->setText(directory);
}


void fRecurrenceDialog::SelectOutputDirectory()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), QString(mInputPathName.c_str()), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    outputDirectoryName->setText(directory);
}
void fRecurrenceDialog::OpenTestSubjectsDirectory()
{
  std::string root_directory;
  //int imagetype;
  QString directory = QFileDialog::getExistingDirectory(this, tr("Open Directory"), QString(mInputPathName.c_str()), QFileDialog::ShowDirsOnly | QFileDialog::DontResolveSymlinks | QFileDialog::DontUseNativeDialog);
  if (directory.isNull())
    return;
  else
    testSubjectsDirectoryName->setText(directory);
}

void fRecurrenceDialog::ExistingClassificationRadioButtonChecked()
{
  if (rdExistingClassification->isChecked())
  {
    svmModelButton->setEnabled(true);
    svmModelFileName->setEnabled(true);
    testSubjectsDirectoryButton->setEnabled(true);
    testSubjectsDirectoryName->setEnabled(true);
    existingMaskDirectoryName->setEnabled(false);
    existingMasksButton->setEnabled(false);
  }
}
void fRecurrenceDialog::NewModelRadioButtonChecked()
{
  if (rdCreateModel->isChecked())
  {
    svmModelButton->setEnabled(false);
    svmModelFileName->setEnabled(false);
    testSubjectsDirectoryButton->setEnabled(false);
    testSubjectsDirectoryName->setEnabled(false);
    existingMaskDirectoryName->setEnabled(true);
    existingMasksButton->setEnabled(true);
  }
}