/**
\file Landmarks.h

\brief Declaration of Landmarks class
*/


#ifndef _Landmarks_h_
#define _Landmarks_h_


#include "CAPTk.h"


#define LANDMARK_TYPE_NONE -1 // TBD and replaced with enums
#define LANDMARK_TYPE_LANDMARKS 0
#define LANDMARK_TYPE_SEED_POINTS 1
#define LANDMARK_TYPE_TISSUE_POINTS 2

#define LANDMARK_MAX_LANDMARKS 200
#define LANDMARK_MAX_SEED_POINTS 10
#define LANDMARK_MAX_TISSUE_POINTS 300

#define MaxNumberOFTumorSeeds	20
#define MaxNumberOFPoints		300

#define NumberOfPriorChannels 15
static const char labels[NumberOfPriorChannels][32] = { "BG", "CSF", "GM", "WM", "VS", "ED", "NCR", "TU", "NE", "CB", "VT", "CAN", "CAE", "RTN", "RTE" };

//! Enum for different Tissue Types
enum TissueTypes
{
  BG, CSF, GM, WM, VS, ED, NCR, TU, NE, CB, VT, CAN, CAE, RTN, RTE
};


struct sLandmark 
{
  bool bValid;
  float coordinates[3];
  float image_coordinates[3];
  double pixel_value;
  float radius;
  int id;
};


/**
\class Landmarks

\brief Tumor landmarks
*/
class Landmarks
{
public:
  Landmarks(int type);
  ~Landmarks();
  bool AddLandmark(float x, float y, float z, float r, double value, int id);
  bool SetLandmark(int index, float x, float y, float z, float r, double value, int id);
  bool RemoveLastLandmark();
  bool RemoveLandmark(int index);
  unsigned int GetNumberOfPoints() { return static_cast<unsigned int>(mLandmarks.size()); }
  void UpdateData();
  void Clear();

  int mType;
  std::vector<sLandmark> mLandmarks;
  vtkPoints* mPoint;
  vtkFloatArray* mRadius;
  vtkFloatArray* mLandID;
  vtkPolyData* mLandDataWithID;
  vtkPolyData* mLandDataWithRadius;
};


#endif
