///////////////////////////////////////////////////////////////////////////////////////
// fDrawingPanel.cpp
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
// Contact details: software@cbica.upenn.edu
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#include "fDrawingPanel.h"
#include "CAPTk.h"
#include "fMainWindow.h"
#include "SlicerManager.h"
#include "Landmarks.h"
#include <QtSvg>
#include "qimage.h"
#include <QStyle>

fDrawingPanel::fDrawingPanel(QWidget * parent) : QWidget(parent)
{
  setupUi(this);

  connect(drawNearButton, SIGNAL(clicked()), this, SLOT(DrawNearButton()));
  connect(drawFarButton, SIGNAL(clicked()), this, SLOT(DrawFarButton()));
  connect(escapeButton, SIGNAL(clicked()), this, SLOT(EscapeButton()));
  connect(eraseSelectedDrawingButton, SIGNAL(clicked()), this, SLOT(EraseSelectedButton()));
  connect(eraseNearDrawingButton, SIGNAL(clicked()), this, SLOT(EraseNearButton()));
  connect(eraseFarDrawingButton, SIGNAL(clicked()), this, SLOT(EraseFarButton()));
  connect(sizeComboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(CurrentSizeChanged(int)));
  connect(UndoButton, SIGNAL(clicked()), this, SLOT(UndoButtonFunctionality()));
}

void fDrawingPanel::DrawNearButton()
{
  emit DrawNearButtonClicked();
}
void fDrawingPanel::DrawFarButton()
{
  emit DrawFarButtonClicked();
}
void fDrawingPanel::EscapeButton()
{
  emit EscapeButtonClicked();
}
void fDrawingPanel::EraseSelectedButton()
{
  emit EraseSelectedButtonClicked();
}
void fDrawingPanel::EraseNearButton()
{
  emit EraseNearButtonClicked();
}
void fDrawingPanel::EraseFarButton()
{
  emit EraseFarButtonClicked();
}
void fDrawingPanel::CurrentSizeChanged(int size)
{
  emit CurrentBrushSizeChanged(size);
}
void fDrawingPanel::UndoButtonFunctionality()
{
  emit UndoButtonClicked();
}
