#ifndef _SlicerManagerCommand_h_
#define _SlicerManagerCommand_h_


#include "CAPTk.h"
#include "SlicerManager.h"
#include "InteractorStyleNavigator.h"
#include "fMainWindow.h"


class SlicerManagerCommand : public vtkCommand
{
public:
  static SlicerManagerCommand *New()
  {
    return new SlicerManagerCommand;
  }

  void Execute(vtkObject *caller, unsigned long event, void *vtkNotUsed(callData));

  SlicerManager *SM;
  void Dolly(double factor, vtkRenderWindowInteractor *interactor);
  void SetSlicerNumber(int slicer) { mSlicerNumber = slicer; }
  void AddActions();
  void moveCursor(int VisibleInWindow, double x, double y)
  {
		vtkRenderer* renderer = this->SM->GetSlicer(VisibleInWindow)->GetRenderer();
		renderer->DisplayToNormalizedDisplay(x, y);
		renderer->NormalizedDisplayToViewport(x, y);
		renderer->ViewportToNormalizedViewport(x, y);
		double z = 0;
		renderer->NormalizedViewportToView(x, y, z);
		renderer->ViewToWorld(x, y, z);

		double X = (x - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[0]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[0];
		double Y = (y - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[1]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[1];
		double Z = (z - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[2]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[2];

		switch (this->SM->GetSlicer(VisibleInWindow)->GetSliceOrientation()) {
		case vtkImageViewer2::SLICE_ORIENTATION_XY:
			X = ROUND(X);
			Y = ROUND(Y);
			Z = this->SM->GetSlicer(VisibleInWindow)->GetSlice();
			break;
		case vtkImageViewer2::SLICE_ORIENTATION_XZ:
			X = ROUND(X);
			Y = this->SM->GetSlicer(VisibleInWindow)->GetSlice();
			Z = ROUND(Z);
			break;
		case vtkImageViewer2::SLICE_ORIENTATION_YZ:
			X = this->SM->GetSlicer(VisibleInWindow)->GetSlice();
			Y = ROUND(Y);
			Z = ROUND(Z);
			break;
		}
		//
		double xWorld = X * this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[0] + this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[0];
		double yWorld = Y * this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[1] + this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[1];
		double zWorld = Z * this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[2] + this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[2];

		//Update the cursur position 
		this->SM->GetSlicer(VisibleInWindow)->SetCurrentPosition(xWorld, yWorld, zWorld);
		this->SM->Picked();
		this->SM->UpdateViews(VisibleInWindow);
		this->SM->UpdateLinked(VisibleInWindow);
		this->SM->UpdateInfoOnCursorPosition(VisibleInWindow);
	
  }
  //TBD move these functions to utility class Bresenham Line Drawing Algorithm and others
  static pair<int, int > point3Dto2D(const PointVal& pt3D, const int orientation)
  {
    pair<int, int> pt;
    if (orientation == 2)//SLICE_ORIENTATION_XY
    {
      pt.first = pt3D.x;
      pt.second = pt3D.y;
    }
    else if (orientation == 1)//SLICE_ORIENTATION_XZ
    {
      pt.first = pt3D.x;
      pt.second = pt3D.z;
    }
    else//SLICE_ORIENTATION_YZ ==0
    {
      pt.first = pt3D.y;
      pt.second = pt3D.z;
    }
    return pt;
  }
  static PointVal point2Dto3D(const pair<int, int >& pt, const int orientation, const int slice, const int value=0)
  {
    PointVal pt3D;
    if (orientation == 2)//SLICE_ORIENTATION_XY
    {
      pt3D.x = pt.first;
      pt3D.y = pt.second;
      pt3D.z = value;
    }
    else if (orientation == 1)//SLICE_ORIENTATION_XZ
    {
      pt3D.x = pt.first;
      pt3D.y = value;
      pt3D.z = pt.second;
    }
    else//SLICE_ORIENTATION_YZ ==0
    {
      pt3D.x = value;
      pt3D.y = pt.first;
      pt3D.z = pt.second;
    }
    pt3D.value = value;
    return pt3D;
  }
  static vector< pair<int, int> > points3Dto2D(const vector<PointVal>& points3D, const int orientation)
  {
    vector< pair<int, int> > points2D;
    for (size_t i = 0; i < points3D.size(); i++)
    {
      points2D.push_back(point3Dto2D(points3D[i], orientation));
    }
    return points2D;
  }
  static vector<PointVal> points2Dto3D(const vector< pair<int, int> >& points2D, const int orientation, const int slice, const int value = 0)
  {
    vector<PointVal> points3D;
    for (size_t i = 0; i < points2D.size(); i++)
    {
      points3D.push_back(point2Dto3D(points2D[i], orientation, slice, value));
    }
    return points3D;
  }
  static vector< pair<int, int> > getCirclePoints(int x, int y, int r)
  {
    if (r <= 0) r = 1;

    vector< pair<int, int> > points;
    double dtheta = 2 * M_PI / 8 / r;
    int n = 2 * M_PI / dtheta;
    points.push_back(make_pair(x + r, y));
    for (size_t i = 1; i <= n; i++)
    {
      double theta = i*dtheta;
      int x1 = int(x + r*cos(theta) + 0.5);
      int y1 = int(y + r*sin(theta) + 0.5);
      points.push_back(make_pair(x1, y1));
    }
    points.push_back(points[0]);
    return points;
  }
  static vector< pair<int, int> > getLinePoints(int x0, int y0, int x1, int y1, float wd)
  {
    vector< pair<int, int> > points;
    int dx = abs(x1 - x0), sx = x0 < x1 ? 1 : -1;
    int dy = abs(y1 - y0), sy = y0 < y1 ? 1 : -1;
    int err = dx - dy, e2, x2, y2;                          /* error value e_xy */
    float ed = dx + dy == 0 ? 1 : sqrt((float)dx*dx + (float)dy*dy);

    for (wd = (wd + 1) / 2;;)
    {                                   /* pixel loop */
      points.push_back(make_pair(x0, y0));
      e2 = err; x2 = x0;
      if (2 * e2 >= -dx)
      {                                           /* x step */
        for (e2 += dy, y2 = y0; e2 < ed*wd && (y1 != y2 || dx > dy); e2 += dx)
        {
          points.push_back(make_pair(x0, y2 += sy));
        }
        if (x0 == x1) break;
        e2 = err; err -= dy; x0 += sx;
      }
      if (2 * e2 <= dy)
      {                                            /* y step */
        for (e2 = dx - e2; e2 < ed*wd && (x1 != x2 || dx < dy); e2 += dy)
        {
          points.push_back(make_pair(x2 += sx, y0));
        }

        if (y0 == y1) break;
        err += dx; y0 += sy;
      }
    }
    return points;
  }
  static vector<PointVal> drawLine(PointVal startPt, PointVal endPt, vtkImageData *image, const int orientation, const int slice, int width)
  {
    vector<PointVal> undoBuffer;
    pair<int, int> p1 = point3Dto2D(startPt, orientation);
    pair<int, int> p2 = point3Dto2D(endPt, orientation);
    vector< pair<int, int> > poits = getLinePoints(p1.first, p1.second, p2.first, p2.second, width);
    vector<PointVal> poits3D = points2Dto3D(poits, orientation, slice, startPt.value);

    for (size_t i = 0; i < poits3D.size(); i++)
    {
      PointVal undoPt = drawPoint(poits3D[i], image, orientation, slice);
      if (undoPt.isValid())
      {
        undoBuffer.push_back(undoPt);
      }
    }
    return undoBuffer;
  }
  static vector<PointVal> drawRectangle(PointVal startPt, PointVal endPt, vtkImageData *image, const int orientation, const int slice, int thickness)
  {
    PointVal corner1 = startPt;
    PointVal corner2 = startPt;
    if (orientation == 2)//SLICE_ORIENTATION_XY
    {
      corner1.x = endPt.x;
      corner2.y = endPt.y;
    }
    else if (orientation == 1)//SLICE_ORIENTATION_XZ
    {
      corner1.x = endPt.x;
      corner2.z = endPt.z;
    }
    else//SLICE_ORIENTATION_YZ ==0
    {
      corner1.y = endPt.y;
      corner2.z = endPt.z;
    }
    vector<PointVal> vec1 = drawLine(startPt, corner1, image, orientation, slice, thickness);
    vector<PointVal> vec2 = drawLine(corner1, endPt, image, orientation, slice, thickness);
    vector<PointVal> vec3 = drawLine(endPt, corner2, image, orientation, slice, thickness);
    vector<PointVal> vec4 = drawLine(corner2, startPt, image, orientation, slice, thickness);
    vec1.insert(vec1.end(), vec2.begin(), vec2.end());
    vec1.insert(vec1.end(), vec3.begin(), vec3.end());
    vec1.insert(vec1.end(), vec4.begin(), vec4.end());
    return vec1;
  }
  static vector<PointVal> drawCircle(PointVal startPt, PointVal endPt, vtkImageData *image, const int orientation, const int slice, int width)
  {
    vector<PointVal> undoBuffer;
    pair<int, int> p1 = point3Dto2D(startPt, orientation);
    pair<int, int> p2 = point3Dto2D(endPt, orientation);
    pair<int, int> center;
    center.first  = (p1.first + p2.first) / 2;
    center.second = (p1.second + p2.second) / 2;
    int radius = sqrt((p1.first - p2.first)*(p1.first - p2.first) + (p1.second - p2.second)*(p1.second - p2.second))/2;
    vector< pair<int, int> > circlePoints = getCirclePoints(center.first, center.second, radius);
    vector< pair<int, int> > thickCirclePoints;
    for (size_t i = 1; i < circlePoints.size(); i++)
    {
      vector< pair<int, int> > poits = getLinePoints(circlePoints[i - 1].first, circlePoints[i - 1].second, circlePoints[i].first, circlePoints[i].second, width);
      thickCirclePoints.insert(thickCirclePoints.end(), poits.begin(), poits.end());
    }
    //Lets remove duplicates 
    sort(thickCirclePoints.begin(), thickCirclePoints.end());
    thickCirclePoints.erase(unique(thickCirclePoints.begin(), thickCirclePoints.end()), thickCirclePoints.end());
    vector<PointVal> poits3D = points2Dto3D(thickCirclePoints, orientation, slice, startPt.value);
    for (size_t i = 0; i < poits3D.size(); i++)
    {
      PointVal undoPt = drawPoint(poits3D[i], image, orientation, slice);
      if (undoPt.isValid())
      {
        undoBuffer.push_back(undoPt);
      }
    }
    return undoBuffer;
  }
  static PointVal drawPoint(PointVal pt, vtkImageData *image, const int orientation,const int slice, const int i = 0, const int j=0)
  {
	  if (image == NULL)
	  {
		  return pt.getInvalidPt();
	  }
	  if (orientation ==2)//SLICE_ORIENTATION_XY
	  {
		  pt.x = pt.x + i;
		  pt.y = pt.y + j;
		  pt.z = slice;
	  }
	  else if (orientation ==1)//SLICE_ORIENTATION_XZ
	  {
		  pt.x = pt.x + i;
		  pt.y = slice;
		  pt.z = pt.z + j;
	  }
	  else//SLICE_ORIENTATION_YZ
	  {
		  pt.x = slice;
		  pt.y = pt.y + i;
		  pt.z = pt.z + j;
	  }
	  //Fix for crash check range be forre acessing pixel 
	  if (pt.isWithinRange(image->GetDimensions()))
	  {
		  float* pData = (float*)image->GetScalarPointer(pt.x, pt.y, pt.z);
		  int oldVal = *pData;
		  *pData = (float)pt.value;
		  pt.value = oldVal;
		  return pt;
	  }
	  return pt.getInvalidPt();

  }
  void makeStroke(int VisibleInWindow, double x, double y)
  {
    vtkRenderer* renderer = this->SM->GetSlicer(VisibleInWindow)->GetRenderer();
    renderer->DisplayToNormalizedDisplay(x, y);
    renderer->NormalizedDisplayToViewport(x, y);
    renderer->ViewportToNormalizedViewport(x, y);
    double z = 0;
    renderer->NormalizedViewportToView(x, y, z);
    renderer->ViewToWorld(x, y, z);

    double X = (x - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[0]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[0];
    double Y = (y - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[1]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[1];
    double Z = (z - this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetOrigin()[2]) / this->SM->GetSlicer(VisibleInWindow)->GetInput()->GetSpacing()[2];

    int orientation = this->SM->GetSlicer(VisibleInWindow)->GetSliceOrientation();
    int slice = this->SM->GetSlicer(VisibleInWindow)->GetSlice();
    int* dims = this->SM->mMask->GetDimensions();

    int color = mw->getSelectedDrawLabel();
    PointVal centerPt(ROUND(X), ROUND(Y), ROUND(Z), color);
    if (mw->m_drawShapeMode == SHAPE_MODE_FREE_HAND || mw->m_drawShapeMode == SHAPE_MODE_ERACER)
    {
      if (mw->m_drawShapeMode == SHAPE_MODE_ERACER)
      {
        centerPt.value = 0;
      }
      int size = mw->getSelectedDrawSize();
      for (int j = -size; j <= size; j++)
      {
        for (int i = -size; i <= size; i++)
        {
          PointVal pt = drawPoint(centerPt, this->SM->mMask, orientation, slice, i, j);
          m_undoBuffer.push_back(pt);
        }
      }

    }
    else
    {
      //Undo previous sahpe  draw
      if (m_shapeBuffer.empty())
      {
        m_startPoint = centerPt;
      }
      for (vector<PointVal>::iterator it = m_shapeBuffer.end(); it != m_shapeBuffer.begin();)
      {
        --it;
        drawPoint(*it, this->SM->mMask, orientation, slice);
      }
      if (mw->m_drawShapeMode == SHAPE_MODE_CIRCLE)
      {
        m_shapeBuffer = drawCircle(m_startPoint, centerPt, this->SM->mMask, orientation, slice, mw->getSelectedDrawSize());
      }
      else if (mw->m_drawShapeMode == SHAPE_MODE_RECTANGLE)
      {
        m_shapeBuffer = drawRectangle(m_startPoint, centerPt, this->SM->mMask, orientation, slice, mw->getSelectedDrawSize());
      }
      else if (mw->m_drawShapeMode == SHAPE_MODE_LINE)
      {
        m_shapeBuffer = drawLine(m_startPoint, centerPt, this->SM->mMask, orientation, slice, mw->getSelectedDrawSize());
      }
      else if (mw->m_drawShapeMode == SHAPE_MODE_LINE)
      {
        int size = mw->getSelectedDrawSize();
        for (int j = -size; j <= size; j++)
        {
          for (int i = -size; i <= size; i++)
          {
            PointVal pt = drawPoint(centerPt, this->SM->mMask, orientation, slice, i, j);
            m_undoBuffer.push_back(pt);
          }
        }
      }
    }

    this->SM->mMask->Modified();
    this->SM->GetSlicer(VisibleInWindow)->Render();

  }
protected:
  SlicerManagerCommand();
  ~SlicerManagerCommand() {}

private:
  int FindSlicerNumber(vtkRenderWindow* renwin);
  double InitialWindow;
  double InitialLevel;
  int mStartSlicer;
  int mSlicerNumber;
  fMainWindow* mw;
  std::vector< PointVal > m_undoBuffer;
  std::vector< PointVal > m_shapeBuffer;
  PointVal m_startPoint;


};


#endif
