///////////////////////////////////////////////////////////////////////////////////////
// fDrawingPanel.h
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fDrawingPanel_h_
#define _fDrawingPanel_h_


#include "CAPTk.h"
#include "Landmarks.h"
#include "ui_fDrawingPanel.h"


/**
\class fDrawingPanel

\brief This class controls the elements in the drawing panel of the tab
*/
class fDrawingPanel : public QWidget, private Ui::fDrawingPanel
{
  Q_OBJECT

public:
  //! Constructor
  fDrawingPanel(QWidget * parent = 0);

  //! Destructor
  ~fDrawingPanel() {}
  int getSelectedDrawLabel()
  {
    if (labelSelectorBox != NULL)
    {
      return labelSelectorBox->currentIndex()+1;
    }
    return 1;
  }
  int getSelectedDrawSize()
  {
    if (sizeComboBox != NULL)
    {
      return sizeComboBox->currentIndex();
    }
    return 0;
  }
  void enableShapeButton(QPushButton* button)
  {
    for (size_t i = 0; i < shapeButtons.size(); i++)
    {
      if (shapeButtons[i] == button)
      {
        shapeButtons[i]->setChecked(true);
      }
      else
      {
        shapeButtons[i]->setChecked(false);
      }
    }
  }
signals :
  void clearMask(int label=-1);
  void UndoButtonClicked();
  void shapesButtonClicked(int mode);
  void CurrentBrushSizeChanged(int);
  void CurrentDrawingLabelChanged(int); // multiLabel related change
  void CurrentMaskOpacityChanged(int); // multiLabel related change


public slots :

  //! Enable voxel based erase functionality
  void shapeEraceButtonFunctionality();

  //! Erase selected label
  void clearSelectedLabelButtonFunctionality();
  
  //! Erase all labels
  void clearAllLabelButtonFunctionality();
  
  //! Change in the size of drawing/erasing brush
  void CurrentSizeChanged(int size);

  //! Change the current selected label
  void CurrentLabelChanged(int size);

  //! Change the current mask opacity
  void CurrentOpacityChanged(int size);

  //! Undo drawing actions
  void UndoButtonFunctionality(); 

  //! Draw Shapes
  void shapesNoneButtonFunctionality();
  void shapesLineButtonFunctionality();
  void shapeFreeHandButtonFunctionality();
  void shapesRectangleButtonFunctionality();
  void shapesCircleButtonFunctionality();

};


#endif
