///////////////////////////////////////////////////////////////////////////////////////
// fRecurrenceDialog.h
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#ifndef _fRecurrenceDialog_h_
#define _fRecurrenceDialog_h_


#include "CAPTk.h"
#include "ui_fRecurrenceDialog.h"

#define SUBJECT_CLASSIFICATION 0
#define EXISTING_CLASSIFICATION 1
#define TRAIN_MODEL 2

/**
\class fRecurrenceDialog

\brief This class controls the elements in the recurrence dialog
*/
class fRecurrenceDialog : public QDialog, private Ui::fRecurrenceDialog
{
  Q_OBJECT

public:
  fRecurrenceDialog();
  ~fRecurrenceDialog();
  int mode;

  void SetCurrentImagePath(const std::string &inputPath)
  {
    mInputPathName = inputPath;
  }

  std::string mInputPathName;


  public slots:
  void CancelButtonPressed();
  void ConfirmButtonPressed();
  void OpenSVMModelFile();
  void OpenExistingMasksDirectory();
  void SelectOutputDirectory();
  void ExistingClassificationRadioButtonChecked();
  void NewModelRadioButtonChecked();
  void OpenTestSubjectsDirectory();

signals:
  void SubjectBasedRecurrenceEstimate(std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData, bool cbDistanceData);
  void ExistingModelBasedRecurrenceEstimate(std::string modeldirectory, std::string inputdirectory, std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData, bool cbDistanceData);
  void TrainNewModel(std::string directory, std::string outputdirectory, bool cbT1Data, bool cbT1ceData, bool cbT2Data, bool cbT2FlairData, bool cbDTIData, bool cbPerfData, bool cbDistanceData);
};


#endif





