
#ifndef UI_fFeaturePanel_H
#define UI_fFeaturePanel_H

#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QApplication>
#include <QtGui/QButtonGroup>
#include <QtGui/QFrame>
#include <QtGui/QGridLayout>
#include <QtGui/QHBoxLayout>
#include <QtGui/QHeaderView>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QRadioButton>
#include <QtGui/QSpacerItem>
#include <QtGui/QTableWidget>
#include <QtGui/QVBoxLayout>
#include <QtGui/QWidget>
#include <qcombobox.h>
#include <QToolButton>
#include <qgroupbox.h>
#include <qsize.h>

#include "CAPTk.h"

QT_BEGIN_NAMESPACE

class Ui_fFeaturePanel
{
public:

  QPushButton * m_btnCompute;
  QPushButton * m_btnCancel;
  QComboBox * m_cmbFeatureType;
  QLineEdit* m_txtSaveFileName;

  QLineEdit* m_txtIntesityMin;
  QLineEdit* m_txtIntesityMax;
  QCheckBox* m_Intensityfeature;
  QCheckBox* m_Statisticfeature;
  QCheckBox* m_Volumetricfeature;
  QCheckBox* m_Histogramfeature;
  QCheckBox* m_Runlenghtfeature;
  QCheckBox* m_Co_occurancefeature;
  QCheckBox* m_LBPfeature;

  QRadioButton *radio1;
  QRadioButton *radio2;

  QPushButton* m_btnBrowseSaveFile;

  std::string tempFolderLocation;

  void setupUi(QWidget *parent)
  {

    int buttonWidth = QLabel().fontMetrics().width("ButtonSize------------------");
    m_cmbFeatureType = new QComboBox();
    m_cmbFeatureType->setToolTip(QString("Set the type of Feature to be extracted/saved"));
    m_cmbFeatureType->addItem("Custom");
    m_cmbFeatureType->addItem("Torso");
    m_cmbFeatureType->addItem("Neuro");
    m_cmbFeatureType->setFixedWidth(buttonWidth + 25);
    fixComboBox(m_cmbFeatureType);
	  m_btnCompute = new QPushButton(parent);
    m_btnCompute->setText(QString("Compute"));
    m_btnCompute->setToolTip(QString("Compute features"));
    m_btnCompute->setFixedWidth(buttonWidth + 25);
    m_btnCancel = new QPushButton(parent);
    m_btnCancel->setEnabled(false);
    m_btnCancel->setText(QString("Cancel"));
    m_btnCancel->setToolTip(QString("Cancel computation"));
    m_btnCancel->setFixedWidth(buttonWidth + 25);

    QGroupBox* featureGroup = new QGroupBox("Parameters");
    QHBoxLayout* featureLayout = new QHBoxLayout();
    QVBoxLayout* featureLayout1 = new QVBoxLayout();
    QVBoxLayout* featureLayout2= new QVBoxLayout();
    QVBoxLayout* featureLayout3 = new QVBoxLayout();
    featureLayout1->addWidget(m_cmbFeatureType);
    featureLayout1->addWidget(m_btnCompute);
    featureLayout1->addWidget(m_btnCancel);
    featureLayout1->addStretch();
    m_Intensityfeature = new QCheckBox("1st Order Statistics");
    m_Intensityfeature->setToolTip(QString("Average, minimum and maximum of the intensities."));
    m_Statisticfeature =new QCheckBox("2nd Order Statistics");
    m_Statisticfeature->setToolTip(QString("Variance, standard deviation and 1st order moments."));
    m_Volumetricfeature = new QCheckBox("Volumetric");
    m_Volumetricfeature->setToolTip(QString("Volume, elongation, flatness, perimeter and 2 first principal components."));
    m_Histogramfeature = new    QCheckBox("Histogram-related");
    m_Histogramfeature->setToolTip(QString("Binning of intensities and peak estimation (See 'Usage' for details)."));
    m_Runlenghtfeature = new QCheckBox("Textural (Run-length)");
    m_Runlenghtfeature->setToolTip(QString("Creates a grey-level run length matrix (GLRLM) for an offset of 2 voxels in 3D."));
    m_Co_occurancefeature = new QCheckBox("Textural (Haralick)");
    m_Co_occurancefeature->setToolTip(QString("Creates a grey-level co-occurence matrix (GLCM) for an offset of 1 voxel in 3D."));
    m_LBPfeature = new QCheckBox("Textural (Local Binary Patterns)");
    m_LBPfeature->setToolTip(QString("Calculates LBPs for 3D image and given mask."));
  
    // QVBoxLayout *verticalbox1 = new QVBoxLayout();
    featureLayout2->addWidget(m_Intensityfeature);
    featureLayout2->addWidget(m_Statisticfeature);
    featureLayout2->addWidget(m_Histogramfeature);
    featureLayout2->addWidget(m_Volumetricfeature);
    // QVBoxLayout *verticalbox2 = new QVBoxLayout();
    featureLayout3->addWidget(m_LBPfeature);
    featureLayout3->addWidget(m_Runlenghtfeature);
    featureLayout3->addWidget(m_Co_occurancefeature);
    
  
    featureLayout->addLayout(featureLayout1);
    featureLayout->addLayout(featureLayout2);
    featureLayout->addLayout(featureLayout3);

 
    featureGroup->setLayout(featureLayout);



    QGroupBox *selectionGroup = new QGroupBox(("Image Selection"));

    radio1 = new QRadioButton("Selected Image");
    radio2 = new QRadioButton("All Images");
    QVBoxLayout *vbox = new QVBoxLayout();
    vbox->addWidget(radio1);
    vbox->addWidget(radio2);
    selectionGroup->setLayout(vbox);

    // Browse output fileName
    QGroupBox* saveGroup = new QGroupBox("Save");
    QHBoxLayout* flLayout =   new QHBoxLayout();
    QLabel* label = new QLabel("FileName:");
    m_btnBrowseSaveFile = new QPushButton("Browse");
    
    // this is done solely for the reason for saving everything in the tempDir
    tempFolderLocation = cbica::createTmpDir(); // this folder is deleted after this command to ensure no conflict with tempFolderLocation from fMainWindow
    m_txtSaveFileName = new QLineEdit(std::string(tempFolderLocation + "features.xml").c_str());
    cbica::deleteDir(tempFolderLocation); // should not be removed
    
    m_txtSaveFileName->setAlignment(Qt::AlignCenter);
    flLayout->addWidget(label);
    flLayout->addWidget(m_btnBrowseSaveFile);
    QVBoxLayout* saveLayout = new QVBoxLayout();
    saveLayout->addLayout(flLayout);
    saveLayout->addWidget(m_txtSaveFileName);
    saveGroup->setLayout(saveLayout);

    //Add user input params
    //QGroupBox* Input_params = new QGroupBox("Input Params");
    //QHBoxLayout* InputLayout = new QHBoxLayout();
    //QLabel* inputlabel1 = new QLabel("Min_intensity:");
    //InputLayout->addWidget(inputlabel1);
    //m_txtIntesityMin = new QLineEdit("45");
    //InputLayout->addWidget(m_txtIntesityMin);
    //QHBoxLayout* InputLayout2 = new QHBoxLayout();
    //QLabel* inputlabel2= new QLabel("Min_intensity:");
    //InputLayout2->addWidget(inputlabel2);
    //m_txtIntesityMax = new QLineEdit("240");
    //InputLayout2->addWidget(m_txtIntesityMax);
    //QVBoxLayout* inparamLayout = new QVBoxLayout();
    //inparamLayout->addLayout(InputLayout);   
    //inparamLayout->addLayout(InputLayout2);
    //Input_params->setLayout(inparamLayout);

    QHBoxLayout* subLayout = new QHBoxLayout();
    subLayout->addWidget(featureGroup);
    subLayout->addWidget(selectionGroup);
    subLayout->addWidget(saveGroup);
    //subLayout->addWidget(Input_params);
    subLayout->addStretch();
    QVBoxLayout* mainLayout = new QVBoxLayout(parent);
    mainLayout->addLayout(subLayout);
    mainLayout->addStretch();
  } 


};

namespace Ui {
  class fFeaturePanel : public Ui_fFeaturePanel {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_fFeaturePanel_H
