///////////////////////////////////////////////////////////////////////////////////////
// fHelpDialog.cxx
//
// Copyright (c) 2016. All rights reserved.
// Section of Biomedical Image Analysis
// Center for Biomedical Image Computing and Analytics
// Department of Radiology
// Perelman School of Medicine
// University of Pennsylvania
//
// Contact details: software@cbica.upenn.edu
//
// License Agreement: https://www.cbica.upenn.edu/sbia/software/license.html
///////////////////////////////////////////////////////////////////////////////////////

#include "fHelpDialog.h"



fHelpDialog::~fHelpDialog()
{

}
fHelpDialog::fHelpDialog()
{
  QVBoxLayout *mainLayout = new QVBoxLayout(this);
  m_helpFileFullPath = QApplication::applicationDirPath().toStdString() + "/../data/docs/index.html";
#ifdef DEVELOPER_MODE
  m_helpFileFullPath = QApplication::applicationDirPath().toStdString() + "/../../bin/docs/html/index.html";
#endif
 


  QHBoxLayout *toolbar = new QHBoxLayout();

  m_webView = new QWebView();
  homeButton = new QPushButton();
  homeButton->setMaximumSize(30, 30);
  std::string  homeIconFullPath = QApplication::applicationDirPath().toStdString() + "/../data/icons/home.png";
#ifdef DEVELOPER_MODE
  homeIconFullPath = QApplication::applicationDirPath().toStdString() + "/../../data/icons/home.png";
#endif
  QImage homeimage(homeIconFullPath.c_str());
  homeButton->setIcon(QPixmap::fromImage(homeimage));
  homeButton->setIconSize(QSize(homeButton->size().width(), homeButton->size().height()));
  homeButton->setToolTip("Home");

   
  backButton = new QPushButton();
  backButton->setMaximumSize(30, 30);
  std::string  backIconFullPath = QApplication::applicationDirPath().toStdString() + "/../data/icons/back.png";
#ifdef DEVELOPER_MODE
   backIconFullPath = QApplication::applicationDirPath().toStdString() + "/../../data/icons/back.png";
#endif
   QImage backimage(backIconFullPath.c_str());
  backButton->setIcon(QPixmap::fromImage(backimage));
  backButton->setIconSize(QSize(homeButton->size().width(), homeButton->size().height()));
  backButton->setToolTip("Back");
 
  
  forwardButton = new QPushButton();
  forwardButton->setMaximumSize(30, 30);
  std::string   forwardIconFullPath  = QApplication::applicationDirPath().toStdString() + "/../data/icons/forward.png";
#ifdef DEVELOPER_MODE
    forwardIconFullPath  = QApplication::applicationDirPath().toStdString() + "/../../data/icons/forward.png";
#endif
  QImage forwardimage(forwardIconFullPath.c_str());
  forwardButton->setIcon(QPixmap::fromImage(forwardimage));
  forwardButton->setIconSize(QSize(homeButton->size().width(), homeButton->size().height()));
  forwardButton->setToolTip("Forward");
 
  refreshButton = new QPushButton();
    refreshButton->setMaximumSize(30, 30);
    std::string   refreshIconFullPath = QApplication::applicationDirPath().toStdString() + "/../data/icons/refresh.png";
#ifdef DEVELOPER_MODE
   refreshIconFullPath = QApplication::applicationDirPath().toStdString() + "/../../data/icons/refresh.png";
#endif
  QImage refreshimage(refreshIconFullPath.c_str());
  refreshButton->setIcon(QPixmap::fromImage(refreshimage));
  refreshButton->setIconSize(QSize(homeButton->size().width(), homeButton->size().height()));
  refreshButton->setToolTip("Refresh");

  if (!cbica::fileExists(m_helpFileFullPath))
  {
    cbica::Logging(loggerFile, "Unable to set stylesheet, file not found");
  }
  else
  {
    m_webView->load(QUrl(m_helpFileFullPath.c_str()));
  }

  toolbar->addWidget(backButton);
  toolbar->addWidget(forwardButton);
  toolbar->addWidget(refreshButton);
  toolbar->addWidget(homeButton);
  toolbar->addSpacing(800);
  mainLayout->addLayout(toolbar);
  mainLayout->addWidget(m_webView);


  this->setWindowTitle("Help");
  this->setWindowModality(Qt::NonModal);
  this->show();


  QCoreApplication::processEvents();

  connect(homeButton, SIGNAL(clicked()), this, SLOT(on_homeButton_clicked()));
  connect(backButton, SIGNAL(clicked()), this, SLOT(on_backButton_clicked()));
  connect(forwardButton, SIGNAL(clicked()), this, SLOT(on_forwardButton_clicked()));
  connect(refreshButton, SIGNAL(clicked()), this, SLOT(on_refreshButton_clicked()));

}
void fHelpDialog::on_homeButton_clicked()
{
  m_webView->load(QUrl(m_helpFileFullPath.c_str()));
}
void fHelpDialog::on_backButton_clicked()
{
  m_webView->back();
  
}
void fHelpDialog::on_forwardButton_clicked()
{
  m_webView->forward();
}

void fHelpDialog::on_refreshButton_clicked()
{
  m_webView->reload();
}
