/**
\file  FeatureExtractionClass.cpp

\brief Implementation of the FeatureExtractionClass

https://www.cbica.upenn.edu/sbia/software/ <br>
software@cbica.upenn.edu

Copyright (c) 2016 University of Pennsylvania. All rights reserved. <br>
See COPYING file or https://www.cbica.upenn.edu/sbia/software/license.html

*/

#include "FeatureExtractionClass.h"
#include "itkVariableSizeMatrix.h"
#include "itkVariableLengthVector.h"
#include "CAPTk.h"

FeatureExtractionClass::FeatureExtractionClass()
{

}

VariableSizeMatrixType FeatureExtractionClass::ResampleTrainingData(const VariableSizeMatrixType &trainingdata,const int NumberOfNearSamples,const int NumberOfFarSamples)
{
  VariableSizeMatrixType sampledTrainingData;
  int NumberOfFeatures = trainingdata.Cols() - 1;
  int Fraction = NumberOfFarSamples / NumberOfNearSamples;
  int NumberOfSampledFarSamples = 0;
  int TotalSamples = NumberOfFarSamples + NumberOfNearSamples;

  for (int i = 0; i < NumberOfFarSamples; i = i + Fraction)
    NumberOfSampledFarSamples++;
  sampledTrainingData.SetSize(NumberOfNearSamples + NumberOfSampledFarSamples, NumberOfFeatures + 1);

  for (int i = 0; i < NumberOfNearSamples; i++)
  {
    for (unsigned int j = 0; j < trainingdata.Cols(); j++)
      sampledTrainingData(i, j) = trainingdata(i, j);
  }
  int counter = NumberOfNearSamples;

  for (int i = NumberOfNearSamples; i < TotalSamples; i = i + Fraction)
  {
    for (unsigned int j = 0; j < trainingdata.Cols(); j++)
      sampledTrainingData(counter, j) = trainingdata(i, j);
    counter = counter + 1;
  }
  return sampledTrainingData;
}


void FeatureExtractionClass::FormulateTrainingData(const std::vector< VectorDouble > &nearintensitities, const std::vector< VectorDouble > &farintensitities)
{
  int NumberOfNearSamples = nearintensitities.size();
  int NumberOfFarSamples = farintensitities.size();
  int NumberOfFeatures = nearintensitities[0].size();

  mTrainingData.SetSize(NumberOfNearSamples + NumberOfFarSamples, NumberOfFeatures + 1);
  for (int i = 0; i < NumberOfNearSamples; i++)
  {
    for (int j = 0; j < NumberOfFeatures; j++)
      mTrainingData(i, j) = nearintensitities[i][j];
    mTrainingData(i, NumberOfFeatures) = TRAINING_LABEL_NEAR;
  }
  for (int i = 0; i < NumberOfFarSamples; i++)
  {
    for (int j = 0; j < NumberOfFeatures; j++)
      mTrainingData(i + NumberOfNearSamples, j) = farintensitities[i][j];

    mTrainingData(i + NumberOfNearSamples, NumberOfFeatures) = TRAINING_LABEL_FAR;
  }
}


VariableSizeMatrixType FeatureExtractionClass::FormulateTestData(const std::vector< VectorDouble > &testdata)
{
  int NumberOfFeatures = testdata[0].size();
  int NumberOfSamples = testdata.size();

  mTestData.SetSize(NumberOfSamples, NumberOfFeatures + 1);

  for (int i = 0; i < NumberOfSamples; i++)
  {
    for (int j = 0; j < NumberOfFeatures; j++)
      mTestData(i, j) = testdata[i][j];
    mTestData(i, NumberOfFeatures) = TRAINING_LABEL_FAR;
  }

  return mTestData;
}
